/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Team {
    public static final int MAX_NAME_LENGTH = 32;
    public static final String CATEGORY_MEMBER = "MEMBER";
    public static final String CATEGORY_ADMIN = "ADMIN";
    public static final String CATEGORY_REMOVE = "REMOVE";
    public static final String CATEGORY_OWNER = "OWNER";
    final UUID id;
    PlayerReference owner = null;
    String teamName = "Some Team";
    private boolean isClient = false;
    List<PlayerReference> admins = Lists.newArrayList();
    List<PlayerReference> members = Lists.newArrayList();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;

    public UUID getID() {
        return this.id;
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.teamName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    public List<PlayerReference> getAdmins() {
        return this.admins;
    }

    public List<PlayerReference> getMembers() {
        return this.members;
    }

    public int getBankLimit() {
        return this.bankAccountLimit;
    }

    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    public boolean canAccessBankAccount(PlayerEntity player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public boolean isOwner(PlayerEntity player) {
        return this.owner != null && this.owner.is((Entity)player) || TradingOffice.isAdminPlayer(player);
    }

    public boolean isOwner(UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    public boolean isAdmin(PlayerEntity player) {
        return PlayerReference.listContains(this.admins, player.func_110124_au()) || this.isOwner(player);
    }

    public boolean isAdmin(UUID playerID) {
        return PlayerReference.listContains(this.admins, playerID) || this.isOwner(playerID);
    }

    public boolean isMember(PlayerEntity player) {
        return PlayerReference.listContains(this.members, player.func_110124_au()) || this.isAdmin(player);
    }

    public boolean isMember(UUID playerID) {
        return PlayerReference.listContains(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changeAddMember(PlayerEntity requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_MEMBER);
    }

    public void changeAddAdmin(PlayerEntity requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_ADMIN);
    }

    public void changeRemoveMember(PlayerEntity requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_REMOVE);
    }

    public void changeOwner(PlayerEntity requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_OWNER);
    }

    public void changeName(PlayerEntity requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            this.markDirty();
        }
    }

    public void changeAny(PlayerEntity requestor, String playerName, String category) {
        GameProfile profile;
        if (category.contentEquals(CATEGORY_MEMBER) && this.isAdmin(requestor)) {
            GameProfile profile2 = this.getProfile(playerName);
            if (profile2 != null) {
                if (this.isMember(profile2.getId())) {
                    return;
                }
                this.members.add(PlayerReference.of(profile2));
                this.markDirty();
            }
        } else if (category.contentEquals(CATEGORY_ADMIN) && this.isAdmin(requestor)) {
            GameProfile profile3 = this.getProfile(playerName);
            if (profile3 != null) {
                if (this.isAdmin(profile3.getId())) {
                    if (this.isOwner(profile3.getId())) {
                        return;
                    }
                    if (PlayerReference.of(requestor).is(profile3) || this.isOwner(requestor)) {
                        boolean notFound = true;
                        for (int i = 0; notFound && i < this.admins.size(); ++i) {
                            if (!this.admins.get(i).is(profile3)) continue;
                            notFound = false;
                            this.admins.remove(i);
                        }
                        this.members.add(PlayerReference.of(profile3));
                        this.markDirty();
                    }
                } else if (this.isOwner(requestor)) {
                    if (this.isMember(profile3.getId())) {
                        boolean notFound = true;
                        for (int i = 0; notFound && i < this.members.size(); ++i) {
                            if (!this.members.get(i).is(profile3)) continue;
                            notFound = false;
                            this.members.remove(i);
                        }
                    }
                    this.admins.add(PlayerReference.of(profile3));
                    this.markDirty();
                }
            }
        } else if (category.contentEquals(CATEGORY_REMOVE) && (this.isAdmin(requestor) || PlayerReference.of(requestor).is(playerName))) {
            GameProfile profile4 = this.getProfile(playerName);
            if (profile4 != null) {
                if (!this.isMember(profile4.getId())) {
                    return;
                }
                if (this.isAdmin(profile4.getId()) && !this.isOwner(requestor) && !PlayerReference.of(requestor).is(profile4)) {
                    return;
                }
                if (this.isOwner(profile4.getId())) {
                    return;
                }
                boolean notFound = true;
                if (this.isAdmin(profile4.getId())) {
                    for (int i = 0; notFound && i < this.admins.size(); ++i) {
                        if (!this.admins.get(i).is(profile4)) continue;
                        notFound = false;
                        this.admins.remove(i);
                    }
                } else {
                    for (int i = 0; notFound && i < this.members.size(); ++i) {
                        if (!this.members.get(i).is(profile4)) continue;
                        notFound = false;
                        this.members.remove(i);
                    }
                }
                if (notFound) {
                    return;
                }
                this.markDirty();
            }
        } else if (category.contentEquals(CATEGORY_OWNER) && this.isOwner(requestor) && (profile = this.getProfile(playerName)) != null) {
            int i;
            if (this.owner.is(profile)) {
                return;
            }
            this.admins.add(this.owner);
            this.owner = PlayerReference.of(profile);
            for (i = 0; i < this.admins.size(); ++i) {
                if (!this.admins.get(i).is(this.owner)) continue;
                this.admins.remove(i--);
            }
            for (i = 0; i < this.members.size(); ++i) {
                if (!this.members.get(i).is(this.owner)) continue;
                this.members.remove(i--);
            }
            this.markDirty();
        }
    }

    public void createBankAccount(PlayerEntity requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(() -> this.markDirty());
        this.markDirty();
    }

    public void changeBankLimit(PlayerEntity requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    private GameProfile getProfile(String playerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.func_152358_ax().func_152655_a(playerName);
        }
        return null;
    }

    private Team(@Nonnull UUID teamID, @Nonnull PlayerReference owner, @Nonnull String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TradingOffice.MarkTeamDirty(this.id);
        }
    }

    public CompoundNBT save() {
        CompoundNBT compound = new CompoundNBT();
        if (this.id != null) {
            compound.func_186854_a("id", this.id);
        }
        if (this.owner != null) {
            compound.func_218657_a("Owner", (INBT)this.owner.save());
        }
        compound.func_74778_a("Name", this.teamName);
        ListNBT memberList = new ListNBT();
        for (int i = 0; i < this.members.size(); ++i) {
            CompoundNBT thisMember = this.members.get(i).save();
            memberList.add((Object)thisMember);
        }
        compound.func_218657_a("Members", (INBT)memberList);
        ListNBT adminList = new ListNBT();
        for (int i = 0; i < this.admins.size(); ++i) {
            CompoundNBT thisAdmin = this.admins.get(i).save();
            adminList.add((Object)thisAdmin);
        }
        compound.func_218657_a("Admins", (INBT)adminList);
        if (this.bankAccount != null) {
            compound.func_218657_a("BankAccount", (INBT)this.bankAccount.save());
            compound.func_74768_a("BankLimit", this.bankAccountLimit);
        }
        return compound;
    }

    public static Team load(@Nonnull CompoundNBT compound) {
        PlayerReference owner = null;
        UUID id = null;
        if (compound.func_74764_b("id")) {
            id = compound.func_186857_a("id");
        }
        if (compound.func_150297_b("Owner", 10)) {
            owner = PlayerReference.load(compound.func_74775_l("Owner"));
        }
        String name = compound.func_74779_i("Name");
        if (id != null && owner != null) {
            Team team = Team.of(id, owner, name);
            ListNBT adminList = compound.func_150295_c("Admins", 10);
            for (int i = 0; i < adminList.size(); ++i) {
                PlayerReference admin = PlayerReference.load(adminList.func_150305_b(i));
                if (admin == null) continue;
                team.admins.add(admin);
            }
            ListNBT memberList = compound.func_150295_c("Members", 10);
            for (int i = 0; i < memberList.size(); ++i) {
                PlayerReference member = PlayerReference.load(memberList.func_150305_b(i));
                if (member == null) continue;
                team.members.add(member);
            }
            if (compound.func_150297_b("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.func_74775_l("BankAccount"));
                if (compound.func_150297_b("BankLimit", 3)) {
                    team.bankAccountLimit = compound.func_74762_e("BankLimit");
                }
            }
            return team;
        }
        return null;
    }

    public static Team of(@Nonnull UUID id, @Nonnull PlayerReference owner, @Nonnull String name) {
        return new Team(id, owner, name);
    }

    public static TeamReference referenceOf(@Nullable UUID id) {
        if (id == null) {
            return null;
        }
        return new TeamReference(id);
    }

    public static Comparator<Team> sorterFor(PlayerEntity player) {
        return new TeamSorter(player);
    }

    private static class TeamSorter
    implements Comparator<Team> {
        private final PlayerEntity player;

        private TeamSorter(PlayerEntity player) {
            this.player = player;
        }

        @Override
        public int compare(Team o1, Team o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }

    public static class TeamReference {
        UUID teamID;

        private TeamReference(UUID teamID) {
            this.teamID = teamID;
        }

        public UUID getID() {
            return this.teamID;
        }

        @Nullable
        public Team getTeam(boolean isClient) {
            if (isClient) {
                return ClientTradingOffice.getTeam(this.teamID);
            }
            return TradingOffice.getTeam(this.teamID);
        }
    }
}

