/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.IUniversalDataDeserializer;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageInitializeClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.message.command.MessageSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageInitializeClientTeams;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageRemoveClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageUpdateClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageUpdateClientData;
import io.github.lightman314.lightmanscurrency.tileentity.UniversalTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class TradingOffice
extends WorldSavedData {
    public static final String PERSISTENT_TRADER_FILENAME = "config/lightmanscurrency/persistentTraders.json";
    private static final Map<ResourceLocation, Supplier<? extends UniversalTraderData>> registeredDeserializers = Maps.newHashMap();
    private static final String DATA_NAME = "lightmanscurrency_trading_office";
    private static List<UUID> adminPlayers = new ArrayList<UUID>();
    private Map<UUID, UniversalTraderData> persistentTraderMap = new HashMap<UUID, UniversalTraderData>();
    private Map<UUID, String> persistentTraderIDs = new HashMap<UUID, String>();
    private Map<UUID, UniversalTraderData> universalTraderMap = new HashMap<UUID, UniversalTraderData>();
    private Map<UUID, Team> playerTeams = new HashMap<UUID, Team>();
    private Map<UUID, BankAccount> playerBankAccounts = new HashMap<UUID, BankAccount>();
    ListNBT persistentData = new ListNBT();

    public static final void RegisterDataType(ResourceLocation key, Supplier<? extends UniversalTraderData> source) {
        if (registeredDeserializers.containsKey(key)) {
            LightmansCurrency.LogError("A universal trader type of key " + key + " has already been registered.");
            return;
        }
        registeredDeserializers.put(key, source);
    }

    public TradingOffice() {
        super(DATA_NAME);
    }

    public static UniversalTraderData Deserialize(CompoundNBT compound) {
        ResourceLocation thisType = new ResourceLocation(compound.func_74779_i("type"));
        if (registeredDeserializers.containsKey(thisType)) {
            UniversalTraderData data = (UniversalTraderData)registeredDeserializers.get(thisType).get();
            data.read(compound);
            return data;
        }
        return IUniversalDataDeserializer.ClassicDeserialize(compound);
    }

    public static UniversalTraderData Deserialize(JsonObject json) throws Throwable {
        if (!(json.has("type") && json.get("type").isJsonPrimitive() && json.get("type").getAsJsonPrimitive().isString())) {
            throw new Exception("No string 'type' entry for this trader.");
        }
        ResourceLocation thisType = new ResourceLocation(json.get("type").getAsString());
        if (registeredDeserializers.containsKey(thisType)) {
            UniversalTraderData data = (UniversalTraderData)registeredDeserializers.get(thisType).get();
            data.loadFromJson(json);
            return data;
        }
        throw new Exception("Trader type '" + thisType + "' is undefined.");
    }

    public void func_76184_a(CompoundNBT compound) {
        int i;
        if (compound.func_150297_b("UniversalTraders", 9)) {
            this.universalTraderMap.clear();
            ListNBT universalTraderDataList = compound.func_150295_c("UniversalTraders", 10);
            universalTraderDataList.forEach(nbt -> {
                CompoundNBT traderNBT = (CompoundNBT)nbt;
                UniversalTraderData data = TradingOffice.Deserialize(traderNBT);
                if (data != null) {
                    this.universalTraderMap.put(data.getTraderID(), data);
                }
            });
        }
        if (compound.func_150297_b("Teams", 9)) {
            this.playerTeams.clear();
            ListNBT teamList = compound.func_150295_c("Teams", 10);
            for (i = 0; i < teamList.size(); ++i) {
                Team team = Team.load(teamList.func_150305_b(i));
                if (team == null) continue;
                this.playerTeams.put(team.getID(), team);
            }
        }
        if (compound.func_150297_b("BankAccounts", 9)) {
            this.playerBankAccounts.clear();
            ListNBT bankAccountList = compound.func_150295_c("BankAccounts", 10);
            for (i = 0; i < bankAccountList.size(); ++i) {
                CompoundNBT accountCompound = bankAccountList.func_150305_b(i);
                try {
                    UUID owner = accountCompound.func_186857_a("Player");
                    BankAccount bankAccount = new BankAccount(() -> TradingOffice.MarkBankAccountDirty(owner), accountCompound);
                    if (owner == null || bankAccount == null) continue;
                    this.playerBankAccounts.put(owner, bankAccount);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (compound.func_150297_b("PersistentTraderData", 9)) {
            this.persistentData = compound.func_150295_c("PersistentTraderData", 10);
        }
        if (compound.func_150297_b("PersistentTraderIDs", 9)) {
            this.persistentTraderIDs.clear();
            ListNBT persistentIDs = compound.func_150295_c("PersistentTraderIDs", 10);
            for (i = 0; i < persistentIDs.size(); ++i) {
                try {
                    CompoundNBT idData = persistentIDs.func_150305_b(i);
                    UUID uuid = idData.func_186857_a("UUID");
                    String traderID = idData.func_74779_i("TraderID");
                    if (uuid == null || traderID == null) continue;
                    this.persistentTraderIDs.put(uuid, traderID);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.loadPersistentTraders();
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT universalTraderDataList = new ListNBT();
        this.universalTraderMap.forEach((traderID, traderData) -> {
            if (traderData != null) {
                CompoundNBT traderNBT = traderData.write(new CompoundNBT());
                traderNBT.func_186854_a("ID", traderID);
                universalTraderDataList.add((Object)traderNBT);
            }
        });
        compound.func_218657_a("UniversalTraders", (INBT)universalTraderDataList);
        ListNBT teamList = new ListNBT();
        this.playerTeams.forEach((teamID, team) -> {
            if (team != null) {
                teamList.add((Object)team.save());
            }
        });
        compound.func_218657_a("Teams", (INBT)teamList);
        ListNBT bankAccountList = new ListNBT();
        this.playerBankAccounts.forEach((playerID, account) -> {
            CompoundNBT accountNBT = account.save();
            accountNBT.func_186854_a("Player", playerID);
            bankAccountList.add((Object)accountNBT);
        });
        compound.func_218657_a("BankAccounts", (INBT)bankAccountList);
        this.persistentTraderMap.forEach((ID, traderData) -> {
            if (traderData != null && this.persistentTraderIDs.containsKey(ID)) {
                CompoundNBT data = traderData.getPersistentData();
                String traderID = this.persistentTraderIDs.get(ID);
                data.func_74778_a("traderID", traderID);
                this.setPersistentData(traderID, data);
            }
        });
        compound.func_218657_a("PersistentTraderData", (INBT)this.persistentData);
        ListNBT persistentTraderIDs = new ListNBT();
        this.persistentTraderIDs.forEach((uuid, traderID) -> {
            CompoundNBT idData = new CompoundNBT();
            idData.func_186854_a("UUID", uuid);
            idData.func_74778_a("TraderID", traderID);
        });
        compound.func_218657_a("PersistentTraderIDs", (INBT)persistentTraderIDs);
        return compound;
    }

    public static void reloadPersistentTraders() {
        TradingOffice office = TradingOffice.get(ServerLifecycleHooks.getCurrentServer());
        office.resendTraderData();
    }

    private void loadPersistentTraders() {
        LightmansCurrency.LogInfo("Begining to load persistent traders.");
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        if (!ptf.exists()) {
            this.createPersistentTraderFile(ptf);
        }
        try {
            JsonObject fileData = JSONUtils.func_212745_a((String)Files.toString((File)ptf, (Charset)StandardCharsets.UTF_8));
            this.loadPersistentTraders(fileData);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Persistent Traders.", e);
        }
        LightmansCurrency.LogInfo("Finished loading persistent traders.");
    }

    private void loadPersistentTraders(JsonObject fileData) throws Exception {
        if (fileData.has("Traders")) {
            this.persistentTraderMap.clear();
            ArrayList<String> loadedIDs = new ArrayList<String>();
            JsonArray traderList = fileData.get("Traders").getAsJsonArray();
            for (int i = 0; i < traderList.size(); ++i) {
                try {
                    JsonObject traderTag = traderList.get(i).getAsJsonObject();
                    if (!traderTag.has("id")) {
                        throw new Exception("Trader has no defined id.");
                    }
                    String traderID = traderTag.get("id").getAsString();
                    if (loadedIDs.contains(traderID)) {
                        throw new Exception("Trader with id '" + traderID + "' already exists. Cannot have duplicate ids.");
                    }
                    UniversalTraderData data = TradingOffice.Deserialize(traderTag);
                    data.getCoreSettings().forceCreative();
                    data.loadPersistentData(this.getPersistentData(traderID));
                    UUID id = this.getPersistentTraderUUID(traderID);
                    if (id == null) {
                        id = this.getValidTraderID();
                        this.persistentTraderIDs.put(id, traderID);
                        this.func_76185_a();
                    }
                    data.initTraderID(id);
                    this.persistentTraderMap.put(id, data);
                    loadedIDs.add(traderID);
                    LightmansCurrency.LogInfo("Successfully loaded persistent trader '" + traderID + "' with UUID " + id.toString() + ".");
                    continue;
                }
                catch (Throwable e) {
                    LightmansCurrency.LogError("Error loading Persistent Trader at index " + i, e);
                }
            }
        } else {
            throw new Exception("Json Data has no 'Traders' entry.");
        }
    }

    private UUID getPersistentTraderUUID(String traderID) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        if (this.persistentTraderIDs.containsValue(traderID)) {
            this.persistentTraderIDs.forEach((uuid, id) -> {
                if (id.contentEquals(traderID)) {
                    result.set(uuid);
                }
            });
        }
        return result.get();
    }

    private CompoundNBT getPersistentData(String traderID) {
        for (int i = 0; i < this.persistentData.size(); ++i) {
            CompoundNBT thisData = this.persistentData.func_150305_b(i);
            if (!thisData.func_74779_i("traderID").contentEquals(traderID)) continue;
            return thisData;
        }
        return new CompoundNBT();
    }

    private void setPersistentData(String traderID, CompoundNBT data) {
        for (int i = 0; i < this.persistentData.size(); ++i) {
            CompoundNBT thisData = this.persistentData.func_150305_b(i);
            if (!thisData.func_74779_i("traderID").contentEquals(traderID)) continue;
            this.persistentData.set(i, (INBT)data);
            return;
        }
        this.persistentData.add((Object)data);
    }

    private void createPersistentTraderFile(File ptf) {
        File dir = new File(ptf.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                ptf.createNewFile();
                FileUtil.writeStringToFile(ptf, "{\n    \"Traders\":[]\n}");
                LightmansCurrency.LogInfo("persistentTraders.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'persistentTraders.json' file.", e);
            }
        }
    }

    public static UniversalTraderData getData(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.universalTraderMap.containsKey(traderID)) {
                return office.universalTraderMap.get(traderID);
            }
            if (office.persistentTraderMap.containsKey(traderID)) {
                return office.persistentTraderMap.get(traderID);
            }
        }
        return null;
    }

    public static List<UniversalTraderData> getTraders() {
        TradingOffice office = TradingOffice.get(ServerLifecycleHooks.getCurrentServer());
        List<UniversalTraderData> traders = office.universalTraderMap.values().stream().collect(Collectors.toList());
        traders.addAll(office.persistentTraderMap.values());
        return traders;
    }

    public static List<UniversalTraderData> filterTraders(String searchFilter, List<UniversalTraderData> traders) {
        if (searchFilter.isEmpty()) {
            return traders;
        }
        Stream<UniversalTraderData> stream = traders.stream().filter(entry -> {
            String searchText = searchFilter.toLowerCase().trim();
            if (entry.getName().getString().toLowerCase().contains(searchText)) {
                return true;
            }
            if (entry.getCoreSettings().getOwner().lastKnownName().toLowerCase().contains(searchText)) {
                return true;
            }
            return TraderSearchFilter.checkFilters(entry, searchText);
        });
        return stream.collect(Collectors.toList());
    }

    public static List<UniversalTraderData> getTraders(String searchFilter) {
        return TradingOffice.filterTraders(searchFilter, TradingOffice.getTraders());
    }

    public static void MarkDirty(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).func_76185_a();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                CompoundNBT compound = data.write(new CompoundNBT());
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            }
        }
    }

    public static void MarkDirty(UUID traderID, CompoundNBT updateMessage) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).func_76185_a();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(updateMessage));
            }
        }
    }

    public static List<Team> getTeams() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return TradingOffice.get((MinecraftServer)server).playerTeams.values().stream().collect(Collectors.toList());
        }
        return new ArrayList<Team>();
    }

    public static Team getTeam(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.playerTeams.containsKey(teamID)) {
                return office.playerTeams.get(teamID);
            }
        }
        return null;
    }

    public static void MarkTeamDirty(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).func_76185_a();
            Team team = TradingOffice.getTeam(teamID);
            if (team != null) {
                CompoundNBT compound = team.save();
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientTeam(compound));
            }
        }
    }

    private UUID getValidTraderID() {
        UUID traderID = UUID.randomUUID();
        while (this.universalTraderMap.containsKey(traderID) || this.persistentTraderIDs.containsKey(traderID)) {
            traderID = UUID.randomUUID();
        }
        return traderID;
    }

    public static UUID registerTrader(UniversalTraderData data, PlayerEntity owner) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            UUID traderID = office.getValidTraderID();
            data.initTraderID(traderID);
            LightmansCurrency.LogInfo("Successfully registered the universal trader with id '" + traderID + "'!");
            office.universalTraderMap.put(traderID, data);
            office.func_76185_a();
            CompoundNBT compound = data.write(new CompoundNBT());
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeCreateEvent(traderID, owner));
            return traderID;
        }
        return null;
    }

    public static void removeTrader(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office.universalTraderMap.containsKey(traderID)) {
            UniversalTraderData removedData = office.universalTraderMap.get(traderID);
            office.universalTraderMap.remove(traderID);
            office.func_76185_a();
            LightmansCurrency.LogInfo("Successfully removed the universal trader with id '" + traderID + "'!");
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageRemoveClientTrader(traderID));
            MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeRemoveEvent(traderID, removedData));
        }
    }

    public static Team registerTeam(PlayerEntity owner, String teamName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            UUID teamID = UUID.randomUUID();
            while (office.playerTeams.containsKey(teamID)) {
                teamID = UUID.randomUUID();
            }
            Team newTeam = Team.of(teamID, PlayerReference.of(owner), teamName);
            office.playerTeams.put(teamID, newTeam);
            TradingOffice.MarkTeamDirty(newTeam.getID());
            return newTeam;
        }
        return null;
    }

    public static void removeTeam(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.playerTeams.containsKey(teamID)) {
                office.playerTeams.remove(teamID);
                office.func_76185_a();
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageRemoveClientTeam(teamID));
            }
        }
    }

    public static BankAccount getBankAccount(PlayerEntity player) {
        return TradingOffice.getBankAccount(player.func_110124_au());
    }

    public static BankAccount getBankAccount(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office != null) {
            if (office.playerBankAccounts.containsKey(playerID)) {
                return office.playerBankAccounts.get(playerID);
            }
            BankAccount newAccount = new BankAccount(() -> TradingOffice.MarkBankAccountDirty(playerID));
            office.playerBankAccounts.put(playerID, newAccount);
            office.func_76185_a();
            TradingOffice.MarkBankAccountDirty(playerID);
        }
        return null;
    }

    public static void MarkBankAccountDirty(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        TradingOffice.MarkBankAccountDirty(player.func_110124_au());
    }

    public static void MarkBankAccountDirty(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).func_76185_a();
            BankAccount bankAccount = TradingOffice.getBankAccount(playerID);
            CompoundNBT compound = bankAccount.save();
            compound.func_186854_a("Player", playerID);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientBank(compound));
        }
    }

    private static TradingOffice get(MinecraftServer server) {
        ServerWorld world = server.func_71218_a(World.field_234918_g_);
        TradingOffice office = (TradingOffice)world.func_217481_x().func_215753_b(TradingOffice::new, DATA_NAME);
        if (office == null) {
            office = (TradingOffice)world.func_217481_x().func_215752_a(TradingOffice::new, DATA_NAME);
            office.loadPersistentTraders();
        }
        return office;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
            TradingOffice office = TradingOffice.get(server);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageClearClientTraders());
            office.universalTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundNBT()))));
            office.persistentTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundNBT()))));
            CompoundNBT compound2 = new CompoundNBT();
            ListNBT teamList = new ListNBT();
            office.playerTeams.forEach((id, team) -> teamList.add((Object)team.save()));
            compound2.func_218657_a("Teams", (INBT)teamList);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageInitializeClientTeams(compound2));
            TradingOffice.getBankAccount(event.getPlayer());
            CompoundNBT compound3 = new CompoundNBT();
            ListNBT bankList = new ListNBT();
            office.playerBankAccounts.forEach((id, team) -> {
                CompoundNBT tag = team.save();
                tag.func_186854_a("Player", id);
                bankList.add((Object)tag);
            });
            compound3.func_218657_a("BankAccounts", (INBT)bankList);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageInitializeClientBank(compound3));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.func_71259_af() % 1200 == 0) {
            TradingOffice office = TradingOffice.get(server);
            office.universalTraderMap.values().removeIf(traderData -> {
                BlockPos pos = traderData.getPos();
                ServerWorld world = server.func_71218_a(traderData.getWorld());
                if (world.isAreaLoaded(pos, 0)) {
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof UniversalTraderTileEntity) {
                        UniversalTraderTileEntity traderEntity = (UniversalTraderTileEntity)tileEntity;
                        return traderEntity.getTraderID() == null || !traderEntity.getTraderID().equals(traderData.getTraderID());
                    }
                    return true;
                }
                return false;
            });
        }
    }

    private void resendTraderData() {
        PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageClearClientTraders());
        this.universalTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundNBT()))));
        this.persistentTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundNBT()))));
    }

    public static boolean isAdminPlayer(PlayerEntity player) {
        return adminPlayers.contains(player.func_110124_au()) && player.func_211513_k(2);
    }

    public static void toggleAdminPlayer(PlayerEntity player) {
        UUID playerID = player.func_110124_au();
        if (adminPlayers.contains(playerID)) {
            adminPlayers.remove(playerID);
            if (!player.field_70170_p.field_72995_K) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)TradingOffice.getAdminSyncMessage());
            }
        } else {
            adminPlayers.add(playerID);
            if (!player.field_70170_p.field_72995_K) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)TradingOffice.getAdminSyncMessage());
            }
        }
    }

    public static MessageSyncAdminList getAdminSyncMessage() {
        return new MessageSyncAdminList(adminPlayers);
    }

    public static void loadAdminPlayers(List<UUID> serverAdminList) {
        adminPlayers = serverAdminList;
    }
}

