/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.RemoteTradeData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.containers.ItemEditContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderStorageContainer;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageAddOrRemoveTrade2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageSetItemPrice2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageSetTradeItem2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageUpdateTradeRule2;
import io.github.lightman314.lightmanscurrency.tileentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class UniversalItemTraderData
extends UniversalTraderData
implements IItemTrader {
    public static final int TRADE_LIMIT = 16;
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    public static final int VERSION = 1;
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    private ItemTraderSettings itemSettings = new ItemTraderSettings(this, this::markItemSettingsDirty, this::sendSettingsUpdateToServer);
    int tradeCount = 1;
    List<ItemTradeData> trades = null;
    IInventory storage;
    private final ItemShopLogger logger = new ItemShopLogger();
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    @Override
    public IItemHandler getItemHandler(Direction relativeSide) {
        ItemTraderSettings.ItemHandlerSettings setting = this.itemSettings.getHandlerSetting(relativeSide);
        return this.itemHandler.getHandler(setting);
    }

    public UniversalItemTraderData() {
    }

    public UniversalItemTraderData(PlayerReference owner, BlockPos pos, RegistryKey<World> world, UUID traderID, int tradeCount) {
        super(owner, pos, world, traderID);
        this.tradeCount = MathUtil.clamp(tradeCount, 1, 16);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.storage = new Inventory(this.inventorySize());
    }

    @Override
    public void read(CompoundNBT compound) {
        if (compound.func_150297_b("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.func_74762_e("TradeLimit"), 1, 16);
        }
        if (compound.func_150297_b("Trades", 9)) {
            this.trades = ItemTradeData.loadAllData(compound, this.tradeCount);
        }
        if (this.storage == null) {
            this.storage = new Inventory(this.inventorySize());
        }
        if (compound.func_150297_b("Storage", 9)) {
            this.storage = InventoryUtil.loadAllItems("Storage", compound, this.inventorySize());
        }
        this.logger.read(compound);
        if (compound.func_150297_b("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        if (compound.func_150297_b("ItemSettings", 10)) {
            this.itemSettings.load(compound.func_74775_l("ItemSettings"));
        }
        super.read(compound);
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        this.writeTrades(compound);
        this.writeStorage(compound);
        this.writeLogger(compound);
        this.writeRules(compound);
        this.writeItemSettings(compound);
        return super.write(compound);
    }

    protected final CompoundNBT writeTrades(CompoundNBT compound) {
        compound.func_74768_a("TradeLimit", this.trades.size());
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    protected final CompoundNBT writeStorage(CompoundNBT compound) {
        InventoryUtil.saveAllItems("Storage", compound, this.storage);
        return compound;
    }

    protected final CompoundNBT writeLogger(CompoundNBT compound) {
        this.logger.write(compound);
        return compound;
    }

    protected final CompoundNBT writeRules(CompoundNBT compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    protected final CompoundNBT writeItemSettings(CompoundNBT compound) {
        compound.func_218657_a("ItemSettings", (INBT)this.itemSettings.save(new CompoundNBT()));
        return compound;
    }

    @Override
    public int getTradeCount() {
        return this.tradeCount;
    }

    @Override
    public int getTradeCountLimit() {
        return 16;
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade2(this.traderID, isAdd));
    }

    @Override
    public void addTrade(PlayerEntity requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            Settings.PermissionWarning(requestor, "add trader slot", "LC_ADMIN_MODE");
            return;
        }
        if (this.getTradeCount() >= 16) {
            return;
        }
        this.overrideTradeCount(this.tradeCount + 1);
        this.forceReopen();
        this.coreSettings.getLogger().LogAddRemoveTrade(requestor, true, this.tradeCount);
        this.markCoreSettingsDirty();
    }

    @Override
    public void removeTrade(PlayerEntity requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            Settings.PermissionWarning(requestor, "remove trader slot", "LC_ADMIN_MODE");
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        this.overrideTradeCount(this.tradeCount - 1);
        this.forceReopen();
        this.coreSettings.getLogger().LogAddRemoveTrade(requestor, false, this.tradeCount);
        this.markCoreSettingsDirty();
    }

    public void overrideTradeCount(int newTradeCount) {
        int i;
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 16);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i2 = 0; i2 < oldTrades.size() && i2 < this.trades.size(); ++i2) {
            this.trades.set(i2, oldTrades.get(i2));
        }
        IInventory oldInventory = this.storage;
        this.storage = new Inventory(this.inventorySize());
        for (i = 0; i < this.storage.func_70302_i_() && i < oldInventory.func_70302_i_(); ++i) {
            this.storage.func_70299_a(i, oldInventory.func_70301_a(i));
        }
        if (oldInventory.func_70302_i_() > this.inventorySize()) {
            for (i = this.inventorySize(); i < oldInventory.func_70302_i_(); ++i) {
                InventoryUtil.TryPutItemStack(this.storage, oldInventory.func_70301_a(i));
            }
        }
        CompoundNBT compound = this.writeTrades(new CompoundNBT());
        this.writeStorage(compound);
        this.markDirty(compound);
    }

    @Override
    public ItemTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.getTradeCount()) {
            return this.trades.get(tradeIndex);
        }
        return new ItemTradeData();
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.getTrade(tradeIndex).stockCount(this);
    }

    @Override
    public List<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeTrades));
    }

    @Override
    public ItemTraderSettings getItemSettings() {
        return this.itemSettings;
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return Lists.newArrayList();
    }

    @Override
    public void markItemSettingsDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeItemSettings));
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeLogger));
    }

    public int inventorySize() {
        return this.tradeCount * 9;
    }

    @Override
    public IInventory getStorage() {
        return this.storage;
    }

    @Override
    public void markStorageDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeStorage));
    }

    public void markDirtyAfterTrade() {
        CompoundNBT compound = this.writeStorage(new CompoundNBT());
        this.writeStoredMoney(compound);
        this.markDirty(compound);
    }

    @Override
    public ResourceLocation getTraderType() {
        return TYPE;
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("gui.lightmanscurrency.universaltrader.item");
    }

    @Override
    protected INamedContainerProvider getTradeMenuProvider() {
        return new TraderProvider(this.traderID);
    }

    @Override
    protected INamedContainerProvider getStorageMenuProvider() {
        return new StorageProvider(this.traderID);
    }

    protected INamedContainerProvider getItemEditMenuProvider(int tradeIndex) {
        return new ItemEditProvider(this.traderID, tradeIndex);
    }

    @Override
    public void openItemEditMenu(PlayerEntity player, int tradeIndex) {
        INamedContainerProvider provider = this.getItemEditMenuProvider(tradeIndex);
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (Consumer)new UniversalTraderData.TradeIndexDataWriter(this, this.getTraderID(), tradeIndex));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                ItemStack tradeStack = trade.getSellItem();
                if (!tradeStack.func_190926_b()) {
                    tradeStack = InventoryUtil.TryPutItemStack(this.storage, tradeStack);
                }
                if (tradeStack.func_190926_b()) continue;
                LightmansCurrency.LogWarning(tradeStack.func_190916_E() + " items lost during Universal Item Trader version update for trader " + this.traderID + ".");
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            return;
        }
        this.tradeRules.add(newRule);
    }

    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeRules));
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler() {
        return new TradeRuleScreenHandler(this);
    }

    @Override
    public RemoteTradeData.RemoteTradeResult handleRemotePurchase(int tradeIndex, RemoteTradeData data) {
        if (tradeIndex < 0 || tradeIndex >= this.trades.size()) {
            return RemoteTradeData.RemoteTradeResult.FAIL_INVALID_TRADE;
        }
        ItemTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return RemoteTradeData.RemoteTradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            return RemoteTradeData.RemoteTradeResult.FAIL_INVALID_TRADE;
        }
        if (this.runPreTradeEvent(data.getPlayerSource(), tradeIndex).isCanceled()) {
            return RemoteTradeData.RemoteTradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(data.getPlayerSource(), tradeIndex).getCostResult();
        if (trade.isSale()) {
            if (!trade.hasStock(this) && !this.getCoreSettings().isCreative()) {
                return RemoteTradeData.RemoteTradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!data.canFitItem(trade.getSellItem())) {
                return RemoteTradeData.RemoteTradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!data.getPayment(price)) {
                return RemoteTradeData.RemoteTradeResult.FAIL_CANNOT_AFFORD;
            }
            ItemStack giveStack = trade.getSellItem();
            data.putItem(giveStack);
            this.getLogger().AddLog(data.getPlayerSource(), trade, price, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.runPostTradeEvent(data.getPlayerSource(), tradeIndex, price);
            if (!this.getCoreSettings().isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage());
                this.addStoredMoney(price);
                this.markStorageDirty();
            }
            return RemoteTradeData.RemoteTradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            if (!data.hasItem(trade.getSellItem())) {
                return RemoteTradeData.RemoteTradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.getCoreSettings().isCreative()) {
                return RemoteTradeData.RemoteTradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(this) && !this.getCoreSettings().isCreative()) {
                return RemoteTradeData.RemoteTradeResult.FAIL_OUT_OF_STOCK;
            }
            data.collectItem(trade.getSellItem());
            data.givePayment(price);
            this.getLogger().AddLog(data.getPlayerSource(), trade, price, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.runPostTradeEvent(data.getPlayerSource(), tradeIndex, price);
            if (!this.getCoreSettings().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getStorage(), trade.getSellItem());
                this.removeStoredMoney(price);
                this.markStorageDirty();
            }
            return RemoteTradeData.RemoteTradeResult.SUCCESS;
        }
        if (trade.isBarter()) {
            if (!data.hasItem(trade.getBarterItem())) {
                return RemoteTradeData.RemoteTradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this) && !this.getCoreSettings().isCreative()) {
                return RemoteTradeData.RemoteTradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(this) && !this.getCoreSettings().isCreative()) {
                return RemoteTradeData.RemoteTradeResult.FAIL_OUT_OF_STOCK;
            }
            data.collectItem(trade.getBarterItem());
            if (!data.putItem(trade.getSellItem())) {
                data.putItem(trade.getBarterItem());
                return RemoteTradeData.RemoteTradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.getLogger().AddLog(data.getPlayerSource(), trade, CoinValue.EMPTY, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.runPostTradeEvent(data.getPlayerSource(), tradeIndex, price);
            if (!this.getCoreSettings().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getStorage(), trade.getBarterItem());
                trade.RemoveItemsFromStorage(this.getStorage());
                this.markStorageDirty();
            }
            return RemoteTradeData.RemoteTradeResult.SUCCESS;
        }
        return RemoteTradeData.RemoteTradeResult.FAIL_INVALID_TRADE;
    }

    @Override
    protected void forceReopen(List<PlayerEntity> users) {
        for (PlayerEntity player : users) {
            if (player.field_71070_bA instanceof ItemTraderStorageContainer) {
                this.openStorageMenu(player);
                continue;
            }
            if (!(player.field_71070_bA instanceof ItemTraderContainer)) continue;
            this.openTradeMenu(player);
        }
    }

    @Override
    public void sendSetTradeItemMessage(int tradeIndex, ItemStack sellItem, int slot) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTradeItem2(this.traderID, tradeIndex, sellItem, slot));
        }
    }

    @Override
    public void sendSetTradePriceMessage(int tradeIndex, CoinValue newPrice, String newCustomName, ItemTradeData.ItemTradeType newTradeType) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetItemPrice2(this.traderID, tradeIndex, newPrice, newCustomName, newTradeType.name()));
        }
    }

    @Override
    public void sendTradeRuleUpdateMessage(int tradeIndex, ResourceLocation type, CompoundNBT updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule2(this.traderID, tradeIndex, type, updateInfo));
        }
    }

    @Override
    public CompoundNBT getPersistentData() {
        CompoundNBT data = new CompoundNBT();
        ITradeRuleHandler.savePersistentRuleData(data, this, this.trades);
        this.logger.write(data);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
        ITradeRuleHandler.readPersistentRuleData(data, this, this.trades);
        this.logger.read(data);
    }

    @Override
    public void loadFromJson(JsonObject json) throws Exception {
        super.loadFromJson(json);
        if (!json.has("Trades")) {
            throw new Exception("Item Trader must have a trade list.");
        }
        JsonArray tradeList = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<ItemTradeData>();
        for (int i = 0; i < tradeList.size() && this.trades.size() < 16; ++i) {
            try {
                JsonObject tradeData = tradeList.get(i).getAsJsonObject();
                ItemTradeData newTrade = new ItemTradeData();
                JsonObject sellItem = tradeData.get("SellItem").getAsJsonObject();
                newTrade.setSellItem(FileUtil.parseItemStack(sellItem));
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeType(ItemTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                if (tradeData.has("Price")) {
                    if (newTrade.isBarter()) {
                        LightmansCurrency.LogWarning("Price is being defined for a barter trade. Price will be ignored.");
                    } else {
                        newTrade.setCost(CoinValue.Parse(tradeData.get("Price")));
                    }
                } else if (!newTrade.isBarter()) {
                    LightmansCurrency.LogWarning("Price is not defined on a non-barter trade. Price will be assumed to be free.");
                    newTrade.getCost().setFree(true);
                }
                if (tradeData.has("BarterItem")) {
                    if (newTrade.isBarter()) {
                        JsonObject barterItem = tradeData.get("BarterItem").getAsJsonObject();
                        newTrade.setBarterItem(FileUtil.parseItemStack(barterItem));
                    } else {
                        LightmansCurrency.LogWarning("BarterItem is being defined for a non-barter trade. Barter item will be ignored.");
                    }
                }
                if (tradeData.has("DisplayName")) {
                    newTrade.setCustomName(tradeData.get("DisplayName").getAsString());
                }
                if (tradeData.has("TradeRules")) {
                    newTrade.setRules(TradeRule.Parse(tradeData.get("TradeRules").getAsJsonArray()));
                }
                this.trades.add(newTrade);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing item trade at index " + i, e);
            }
            if (this.trades.size() <= 0) {
                throw new Exception("Trader has no valid trades!");
            }
            this.tradeCount = this.trades.size();
            this.storage = new Inventory(this.inventorySize());
        }
        if (json.has("TradeRules")) {
            this.tradeRules = TradeRule.Parse(json.get("TradeRules").getAsJsonArray());
        }
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        super.saveToJson(json);
        JsonArray trades = new JsonArray();
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            tradeData.addProperty("TradeType", trade.getTradeType().name());
            tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem()));
            if (trade.isSale() || trade.isPurchase()) {
                tradeData.add("Price", trade.getCost().toJson());
            }
            if (trade.isBarter()) {
                tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem()));
            }
            if (trade.hasCustomName()) {
                tradeData.addProperty("DisplayName", trade.getCustomName());
            }
            if (trade.getRules().size() > 0) {
                tradeData.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson(trade.getRules()));
            }
            trades.add((JsonElement)tradeData);
        }
        json.add("Trades", (JsonElement)trades);
        if (this.tradeRules.size() > 0) {
            json.add("TradeRules", (JsonElement)TradeRule.saveRulesToJson(this.tradeRules));
        }
        return json;
    }

    @Override
    public boolean canInteractRemotely() {
        return true;
    }

    @Override
    public void receiveTradeRuleMessage(PlayerEntity player, int index, ResourceLocation ruleType, CompoundNBT updateInfo) {
        if (!this.hasPermission(player, "editTradeRules")) {
            Settings.PermissionWarning(player, "edit trade rule", "editTradeRules");
            return;
        }
        if (index >= 0) {
            this.getTrade(index).updateRule(ruleType, updateInfo);
            this.markTradesDirty();
        } else {
            this.updateRule(ruleType, updateInfo);
            this.markRulesDirty();
        }
    }

    private static class TradeRuleScreenHandler
    implements ITradeRuleScreenHandler {
        private final UniversalItemTraderData trader;

        public TradeRuleScreenHandler(UniversalItemTraderData trader) {
            this.trader = trader;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.trader;
        }

        @Override
        public void reopenLastScreen() {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(this.trader.traderID));
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundNBT updateInfo) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule2(this.trader.traderID, type, updateInfo));
        }

        @Override
        public boolean stillValid() {
            return ClientTradingOffice.getData(this.trader.traderID) != null;
        }
    }

    private static class ItemEditProvider
    implements INamedContainerProvider {
        final UUID traderID;
        final int tradeIndex;

        private ItemEditProvider(UUID traderID, int tradeIndex) {
            this.traderID = traderID;
            this.tradeIndex = tradeIndex;
        }

        public Container createMenu(int menuID, PlayerInventory inventory, PlayerEntity player) {
            return new ItemEditContainer.UniversalItemEditContainer(menuID, inventory, this.traderID, this.tradeIndex);
        }

        public ITextComponent func_145748_c_() {
            return new StringTextComponent("");
        }
    }

    private static class StorageProvider
    implements INamedContainerProvider {
        final UUID traderID;

        private StorageProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public Container createMenu(int menuID, PlayerInventory inventory, PlayerEntity player) {
            return new ItemTraderStorageContainer.ItemTraderStorageContainerUniversal(menuID, inventory, this.traderID);
        }

        public ITextComponent func_145748_c_() {
            return new StringTextComponent("");
        }
    }

    private static class TraderProvider
    implements INamedContainerProvider {
        final UUID traderID;

        private TraderProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public Container createMenu(int menuID, PlayerInventory inventory, PlayerEntity player) {
            return new ItemTraderContainer.ItemTraderContainerUniversal(menuID, inventory, this.traderID);
        }

        public ITextComponent func_145748_c_() {
            return new StringTextComponent("");
        }
    }
}

