/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.RemoteTradeData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.logger.MessageClearUniversalLogger;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageChangeSettings2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenTrades2;
import io.github.lightman314.lightmanscurrency.tileentity.IPermissions;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class UniversalTraderData
implements IPermissions,
ITrader {
    public static final ResourceLocation ICON_RESOURCE = new ResourceLocation("lightmanscurrency", "textures/gui/universal_trader_icons.png");
    CoreTraderSettings coreSettings = new CoreTraderSettings(this, this::markCoreSettingsDirty, this::sendSettingsUpdateToServer);
    UUID traderID = null;
    BlockPos pos;
    RegistryKey<World> world = World.field_234918_g_;
    CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private boolean isServer = true;
    private List<PlayerEntity> users = new ArrayList<PlayerEntity>();

    public UUID getTraderID() {
        return this.traderID;
    }

    public void initTraderID(UUID traderID) {
        if (this.traderID == null) {
            this.traderID = traderID;
        } else {
            LightmansCurrency.LogWarning("Attempted to set the traders ID when it's already been defined.");
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public RegistryKey<World> getWorld() {
        return this.world;
    }

    @Override
    public CoinValue getStoredMoney() {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            return account.getCoinStorage().copy();
        }
        return this.storedMoney;
    }

    @Override
    public CoinValue getInternalStoredMoney() {
        return this.storedMoney;
    }

    @Override
    public final boolean isServer() {
        return this.isServer;
    }

    @Override
    public final boolean isClient() {
        return !this.isServer;
    }

    public final UniversalTraderData flagAsClient() {
        this.isServer = false;
        return this;
    }

    @Deprecated
    public final void markDirty() {
        if (this.isServer) {
            TradingOffice.MarkDirty(this.traderID);
        }
    }

    public final void markDirty(CompoundNBT compound) {
        if (this.isServer) {
            this.writeCoreData(compound);
            TradingOffice.MarkDirty(this.traderID, compound);
        }
    }

    public final void markDirty(Function<CompoundNBT, CompoundNBT> writer) {
        if (this.isServer) {
            this.markDirty((CompoundNBT)writer.apply((Object)new CompoundNBT()));
        }
    }

    @Override
    public CoreTraderSettings getCoreSettings() {
        return this.coreSettings;
    }

    @Override
    public void markCoreSettingsDirty() {
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeCoreSettings));
    }

    protected final void sendSettingsUpdateToServer(ResourceLocation type, CompoundNBT updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageChangeSettings2(this.traderID, type, updateInfo));
        }
    }

    public final void changeSettings(ResourceLocation type, PlayerEntity requestor, CompoundNBT updateInfo) {
        if (this.isClient()) {
            LightmansCurrency.LogError("UniversalTraderData.changeSettings was called on a client.");
        }
        if (type.equals((Object)this.coreSettings.getType())) {
            this.coreSettings.changeSetting(requestor, updateInfo);
        } else {
            this.getAdditionalSettings().forEach(setting -> {
                if (type.equals((Object)setting.getType())) {
                    setting.changeSetting(requestor, updateInfo);
                }
            });
        }
    }

    @Override
    public void addStoredMoney(CoinValue addedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.depositCoins(addedAmount);
            account.LogInteraction(this, addedAmount, true);
            return;
        }
        this.storedMoney.addValue(addedAmount);
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeStoredMoney));
    }

    @Override
    public void removeStoredMoney(CoinValue removedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.withdrawCoins(removedAmount);
            account.LogInteraction(this, removedAmount, false);
            return;
        }
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeStoredMoney));
    }

    @Override
    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.markDirty((Function<CompoundNBT, CompoundNBT>)((Function)this::writeStoredMoney));
    }

    public UniversalTraderData() {
    }

    public UniversalTraderData(PlayerReference owner, BlockPos pos, RegistryKey<World> world, UUID traderID) {
        this.coreSettings.initializeOwner(owner);
        this.pos = pos;
        this.traderID = traderID;
        this.world = world;
    }

    @Deprecated
    public UniversalTraderData(CompoundNBT compound) {
        this.read(compound, false);
    }

    public void read(CompoundNBT compound) {
        this.read(compound, true);
    }

    private void read(CompoundNBT compound, boolean checkVersion) {
        if (compound.func_74764_b("ID")) {
            this.traderID = compound.func_186857_a("ID");
        }
        if (compound.func_150297_b("CoreSettings", 10)) {
            this.coreSettings.load(compound.func_74775_l("CoreSettings"));
        } else if (compound.func_74764_b("OwnerID")) {
            this.coreSettings.loadFromOldUniversalData(compound);
        }
        if (compound.func_74764_b("x") && compound.func_74764_b("y") && compound.func_74764_b("z")) {
            this.pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        }
        if (compound.func_74764_b("World")) {
            this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("World")));
        }
        if (compound.func_74764_b("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (checkVersion) {
            this.readVersion(compound);
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        this.writeCoreData(compound);
        this.writeCoreSettings(compound);
        this.writeStoredMoney(compound);
        this.writeWorldData(compound);
        this.writeVersion(compound);
        return compound;
    }

    protected final CompoundNBT writeCoreData(CompoundNBT compound) {
        if (this.traderID != null) {
            compound.func_186854_a("ID", this.traderID);
        }
        compound.func_74778_a("type", this.getTraderType().toString());
        return compound;
    }

    protected final CompoundNBT writeCoreSettings(CompoundNBT compound) {
        compound.func_218657_a("CoreSettings", (INBT)this.coreSettings.save(new CompoundNBT()));
        return compound;
    }

    protected final CompoundNBT writeWorldData(CompoundNBT compound) {
        if (this.pos != null) {
            compound.func_74768_a("x", this.pos.func_177958_n());
            compound.func_74768_a("y", this.pos.func_177956_o());
            compound.func_74768_a("z", this.pos.func_177952_p());
        }
        if (this.world != null) {
            compound.func_74778_a("World", this.world.func_240901_a_().toString());
        }
        return compound;
    }

    protected final CompoundNBT writeStoredMoney(CompoundNBT compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected final CompoundNBT writeVersion(CompoundNBT compound) {
        compound.func_74768_a("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    protected final void readVersion(CompoundNBT compound) {
        int oldVersion;
        if (compound.func_150297_b("TraderVersion", 3) && (oldVersion = compound.func_74762_e("TraderVersion")) < this.GetCurrentVersion()) {
            this.onVersionUpdate(oldVersion);
        }
    }

    public RemoteTradeData.RemoteTradeResult handleRemotePurchase(int tradeIndex, RemoteTradeData data) {
        return RemoteTradeData.RemoteTradeResult.FAIL_NOT_SUPPORTED;
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public abstract ResourceLocation getTraderType();

    protected abstract INamedContainerProvider getTradeMenuProvider();

    public void openTradeMenu(PlayerEntity playerEntity) {
        INamedContainerProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (playerEntity instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    protected abstract INamedContainerProvider getStorageMenuProvider();

    public void openStorageMenu(PlayerEntity player) {
        if (!this.hasPermission(player, "openStorage")) {
            Settings.PermissionWarning(player, "open trader storage", "openStorage");
            return;
        }
        INamedContainerProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (Consumer)new DataWriter(this.getTraderID()));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("gui.lightmanscurrency.universaltrader.default");
    }

    @Override
    public ITextComponent getName() {
        if (this.coreSettings.hasCustomName()) {
            return new StringTextComponent(this.coreSettings.getCustomName());
        }
        return this.getDefaultName();
    }

    @Override
    public ITextComponent getTitle() {
        if (this.coreSettings.isCreative() || this.coreSettings.getOwnerName().isEmpty()) {
            return this.getName();
        }
        return new TranslationTextComponent("gui.lightmanscurrency.trading.title", new Object[]{this.getName(), this.coreSettings.getOwnerName()});
    }

    public static boolean equals(UniversalTraderData data1, UniversalTraderData data2) {
        return data1.write(new CompoundNBT()).equals((Object)data2.write(new CompoundNBT()));
    }

    public abstract IconData getIcon();

    @Override
    public void userOpen(PlayerEntity player) {
        if (!this.users.contains(player)) {
            this.users.add(player);
        }
    }

    @Override
    public void userClose(PlayerEntity player) {
        if (this.users.contains(player)) {
            this.users.remove(player);
        }
    }

    public final void forceReopen() {
        if (this.isServer()) {
            this.forceReopen(Lists.newArrayList(this.users));
        }
    }

    protected abstract void forceReopen(List<PlayerEntity> var1);

    @Override
    public void sendOpenTraderMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades2(this.traderID));
        }
    }

    @Override
    public void sendOpenStorageMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(this.traderID));
        }
    }

    @Override
    public void sendClearLogMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageClearUniversalLogger(this.traderID));
        }
    }

    public abstract CompoundNBT getPersistentData();

    public abstract void loadPersistentData(CompoundNBT var1);

    public void loadFromJson(JsonObject json) throws Exception {
        if (json.has("TraderName")) {
            this.coreSettings.forceCustomName(json.get("TraderName").getAsString());
        }
        if (json.has("OwnerName")) {
            this.coreSettings.setCustomOwnerName(json.get("OwnerName").getAsString());
        }
    }

    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("id", "ExampleID");
        json.addProperty("type", this.getTraderType().toString());
        if (this.coreSettings.hasCustomName()) {
            json.addProperty("TraderName", this.coreSettings.getCustomName());
        }
        json.addProperty("OwnerName", "Minecraft");
        return json;
    }

    protected class TradeIndexDataWriter
    implements Consumer<PacketBuffer> {
        final UUID traderID;
        final int tradeIndex;

        public TradeIndexDataWriter(UUID traderID, int tradeIndex) {
            this.traderID = traderID;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179252_a(this.traderID);
            buffer.writeInt(this.tradeIndex);
        }
    }

    protected class DataWriter
    implements Consumer<PacketBuffer> {
        final UUID traderID;

        public DataWriter(UUID traderID) {
            this.traderID = traderID;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179252_a(this.traderID);
        }
    }
}

