/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching;

import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;

public class ItemTraderSearchFilter
extends TraderSearchFilter {
    @Override
    public boolean filter(UniversalTraderData data, String searchText) {
        if (data instanceof UniversalItemTraderData) {
            List<ItemTradeData> trades = ((UniversalItemTraderData)data).getAllTrades();
            for (int i = 0; i < trades.size(); ++i) {
                if (!trades.get(i).isValid()) continue;
                ItemStack sellItem = trades.get(i).getSellItem();
                if (sellItem.func_200301_q().getString().toLowerCase().contains(searchText)) {
                    return true;
                }
                if (trades.get(i).getCustomName().toLowerCase().contains(searchText)) {
                    return true;
                }
                AtomicBoolean foundEnchantment = new AtomicBoolean(false);
                EnchantmentHelper.func_82781_a((ItemStack)sellItem).forEach((enchantment, level) -> {
                    if (enchantment.func_200305_d(level.intValue()).getString().toLowerCase().contains(searchText)) {
                        foundEnchantment.set(true);
                    }
                });
                if (foundEnchantment.get()) {
                    return true;
                }
                if (!trades.get(i).isBarter()) continue;
                ItemStack barterItem = trades.get(i).getBarterItem();
                if (barterItem.func_200301_q().getString().toLowerCase().contains(searchText)) {
                    return true;
                }
                foundEnchantment.set(false);
                EnchantmentHelper.func_82781_a((ItemStack)barterItem).forEach((enchantment, level) -> {
                    if (enchantment.func_200305_d(level.intValue()).getString().toLowerCase().contains(searchText)) {
                        foundEnchantment.set(true);
                    }
                });
                if (!foundEnchantment.get()) continue;
                return true;
            }
        }
        return false;
    }
}

