/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.containers.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ATMContainer
extends Container
implements BankAccount.IBankAccountTransferMenu {
    private PlayerEntity player;
    private final IInventory coinInput = new Inventory(9);
    private BankAccount.AccountReference accountSource;
    private ITextComponent transferMessage = new StringTextComponent("");

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public IInventory getCoinInput() {
        return this.coinInput;
    }

    @Override
    public BankAccount getAccount() {
        if (this.accountSource == null) {
            return null;
        }
        return this.accountSource.get();
    }

    public ATMContainer(int windowId, PlayerInventory inventory) {
        super(ModContainers.ATM, windowId);
        int x;
        this.player = inventory.field_70458_d;
        this.accountSource = BankAccount.GenerateReference(this.player);
        for (x = 0; x < this.coinInput.func_70302_i_(); ++x) {
            this.func_75146_a(new CoinSlot(this.coinInput, x, 8 + x * 18, 98, false));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 130 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 188));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.coinInput);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index < this.coinInput.func_70302_i_() ? MoneyUtil.isCoin(slotStack.func_77973_b()) && !this.func_75135_a(slotStack, this.coinInput.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.coinInput.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public void SetAccount(BankAccount.AccountReference account) {
        this.accountSource = account;
    }

    @Override
    public BankAccount.AccountReference getAccountSource() {
        return this.accountSource;
    }

    public void ConvertCoins(int buttonInput) {
        if (buttonInput == 100) {
            MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        } else if (buttonInput == 1) {
            MoneyUtil.ConvertCoinsUp(this.coinInput, ModItems.COIN_COPPER);
        } else if (buttonInput == 2) {
            MoneyUtil.ConvertCoinsUp(this.coinInput, ModItems.COIN_IRON);
        } else if (buttonInput == 3) {
            MoneyUtil.ConvertCoinsUp(this.coinInput, ModItems.COIN_GOLD);
        } else if (buttonInput == 4) {
            MoneyUtil.ConvertCoinsUp(this.coinInput, ModItems.COIN_EMERALD);
        } else if (buttonInput == 5) {
            MoneyUtil.ConvertCoinsUp(this.coinInput, ModItems.COIN_DIAMOND);
        } else if (buttonInput == -100) {
            MoneyUtil.ConvertAllCoinsDown(this.coinInput);
        } else if (buttonInput == -5) {
            MoneyUtil.ConvertCoinsDown(this.coinInput, ModItems.COIN_NETHERITE);
        }
        if (buttonInput == -4) {
            MoneyUtil.ConvertCoinsDown(this.coinInput, ModItems.COIN_DIAMOND);
        }
        if (buttonInput == -3) {
            MoneyUtil.ConvertCoinsDown(this.coinInput, ModItems.COIN_EMERALD);
        }
        if (buttonInput == -2) {
            MoneyUtil.ConvertCoinsDown(this.coinInput, ModItems.COIN_GOLD);
        }
        if (buttonInput == -1) {
            MoneyUtil.ConvertCoinsDown(this.coinInput, ModItems.COIN_IRON);
        }
    }

    @Override
    public ITextComponent getLastMessage() {
        return this.transferMessage;
    }

    @Override
    public void setMessage(ITextComponent component) {
        this.transferMessage = component;
    }
}

