/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.containers.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageItemEditClose;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageItemEditSet;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemEditContainer
extends Container {
    public static List<ItemGroup> ITEM_GROUP_BLACKLIST = ImmutableList.of((Object)ItemGroup.field_192395_m, (Object)ItemGroup.field_78036_m, (Object)ItemGroup.field_78027_g);
    public static final int columnCount = 9;
    public static final int rowCount = 6;
    private static List<ItemStack> allItems = null;
    public final PlayerEntity player;
    private final Supplier<IItemTrader> traderSource;
    public final int tradeIndex;
    List<ItemStack> filteredResultItems;
    List<ItemStack> searchResultItems;
    IInventory displayInventory;
    private String searchString;
    private int stackCount = 1;
    private int page = 0;
    private int editSlot = 0;
    final List<Slot> tradeSlots;

    public IItemTrader getTrader() {
        return (IItemTrader)this.traderSource.get();
    }

    public ItemTradeData getTrade() {
        return (ItemTradeData)this.getTrader().getTrade(this.tradeIndex);
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public int getPage() {
        return this.page;
    }

    public int getEditSlot() {
        return this.editSlot;
    }

    protected boolean isClient() {
        return this.player.field_70170_p.field_72995_K;
    }

    public ItemEditContainer(int windowId, PlayerInventory inventory, BlockPos traderPos, int tradeIndex) {
        this(ModContainers.ITEM_EDIT, windowId, inventory, tradeIndex, (Supplier<IItemTrader>)((Supplier)() -> {
            TileEntity te = inventory.field_70458_d.field_70170_p.func_175625_s(traderPos);
            if (te instanceof IItemTrader) {
                return (IItemTrader)te;
            }
            return null;
        }));
    }

    protected ItemEditContainer(ContainerType<?> type, int windowId, PlayerInventory inventory, int tradeIndex, Supplier<IItemTrader> traderSource) {
        super(type, windowId);
        this.player = inventory.field_70458_d;
        this.tradeIndex = tradeIndex;
        this.traderSource = traderSource;
        this.tradeSlots = new ArrayList<Slot>();
        this.displayInventory = new Inventory(54);
        if (!this.isClient()) {
            return;
        }
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(this.displayInventory, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        ItemEditContainer.initItemList();
        this.filteredResultItems = this.getFilteredItems();
        this.modifySearch("");
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (!this.isClient()) {
            return ItemStack.field_190927_a;
        }
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            if (slot == null) {
                return ItemStack.field_190927_a;
            }
            if (slot instanceof DisplaySlot) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                this.setItem(stack, this.editSlot);
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void initItemList() {
        if (allItems != null) {
            return;
        }
        allItems = new ArrayList<ItemStack>();
        for (ItemGroup group : ItemGroup.field_78032_a) {
            if (ITEM_GROUP_BLACKLIST.contains(group)) continue;
            NonNullList items = NonNullList.func_191196_a();
            group.func_78018_a(items);
            for (ItemStack stack : items) {
                if (!ItemEditContainer.itemListAlreadyContains(stack)) {
                    allItems.add(stack);
                }
                if (stack.func_77973_b() != Items.field_151134_bR) continue;
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                        ItemStack newBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (ItemStack)newBook);
                        if (ItemEditContainer.itemListAlreadyContains(newBook)) continue;
                        allItems.add(newBook);
                    }
                });
            }
        }
    }

    private static boolean itemListAlreadyContains(ItemStack stack) {
        for (ItemStack s : allItems) {
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.getTrader() != null && this.getTrader().hasPermission(playerIn, "editTrades");
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultItems = new ArrayList<ItemStack>();
            List<ItemStack> validItems = this.editSlot == 0 ? this.filteredResultItems : allItems;
            for (ItemStack stack : validItems) {
                if (stack.func_200301_q().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (stack.func_77973_b().getRegistryName().toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (enchantment.getRegistryName().toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.func_200305_d(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = this.editSlot == 0 ? this.filteredResultItems : allItems;
        }
        this.refreshPage();
    }

    private List<ItemStack> getFilteredItems() {
        ArrayList results = Lists.newArrayList();
        ItemTradeRestriction restriction = this.getTrade().getRestriction();
        for (int i = 0; i < allItems.size(); ++i) {
            if (!restriction.allowItemSelectItem(allItems.get(i))) continue;
            results.add(allItems.get(i));
        }
        return results;
    }

    public void modifyStackSize(int deltaCount) {
        this.stackCount = MathUtil.clamp(this.stackCount + deltaCount, 1, 64);
        for (int i = 0; i < this.displayInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.displayInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stack.func_190920_e(MathUtil.clamp(this.stackCount, 1, stack.func_77976_d()));
        }
    }

    public int maxPage() {
        return (this.searchResultItems.size() - 1) / this.displayInventory.func_70302_i_();
    }

    public void modifyPage(int deltaPage) {
        this.page += deltaPage;
        this.refreshPage();
    }

    public void refreshPage() {
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.page > this.maxPage()) {
            this.page = this.maxPage();
        }
        int startIndex = this.page * 9 * 6;
        for (int i = 0; i < this.displayInventory.func_70302_i_(); ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex < this.searchResultItems.size()) {
                ItemStack stack = this.searchResultItems.get(thisIndex).func_77946_l();
                stack.func_190920_e(MathUtil.clamp(this.stackCount, 1, stack.func_77976_d()));
                this.displayInventory.func_70299_a(i, stack);
                continue;
            }
            this.displayInventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void toggleEditSlot() {
        if (this.getTrade().isBarter()) {
            this.editSlot = this.editSlot == 1 ? 0 : 1;
            this.modifySearch(this.searchString);
        }
    }

    public void setItem(ItemStack stack, int slot) {
        if (!((IItemTrader)this.traderSource.get()).hasPermission(this.player, "editTrades")) {
            return;
        }
        if (this.isClient()) {
            if (this.editSlot == 1) {
                this.getTrade().setBarterItem(stack);
            } else {
                this.getTrade().setSellItem(stack);
            }
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageItemEditSet(stack, this.editSlot));
        } else {
            if (slot == 1) {
                ((ItemTradeData)((IItemTrader)this.traderSource.get()).getTrade(this.tradeIndex)).setBarterItem(stack);
            } else {
                ((ItemTradeData)((IItemTrader)this.traderSource.get()).getTrade(this.tradeIndex)).setSellItem(stack);
            }
            ((IItemTrader)this.traderSource.get()).markTradesDirty();
        }
    }

    public void openTraderStorage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageItemEditClose());
        } else {
            ((IItemTrader)this.traderSource.get()).openStorageMenu(this.player);
        }
    }

    public static class UniversalItemEditContainer
    extends ItemEditContainer {
        public UniversalItemEditContainer(int windowId, PlayerInventory inventory, UUID traderID, int tradeIndex) {
            super(ModContainers.UNIVERSAL_ITEM_EDIT, windowId, inventory, tradeIndex, (Supplier<IItemTrader>)((Supplier)() -> {
                UniversalTraderData data = null;
                data = inventory.field_70458_d.field_70170_p.field_72995_K ? ClientTradingOffice.getData(traderID) : TradingOffice.getData(traderID);
                if (data instanceof IItemTrader) {
                    return (IItemTrader)((Object)data);
                }
                return null;
            }));
        }
    }
}

