/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.containers.interfaces.ITraderCashRegisterContainer;
import io.github.lightman314.lightmanscurrency.containers.interfaces.ITraderContainer;
import io.github.lightman314.lightmanscurrency.containers.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.tileentity.CashRegisterTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ItemTraderContainer
extends Container
implements ITraderContainer {
    public final PlayerEntity player;
    protected static final ContainerType<?> type = ModContainers.ITEM_TRADER;
    protected final IInventory coinSlots = new Inventory(5);
    protected final IInventory itemSlots = new Inventory(3);
    private final Supplier<IItemTrader> traderSource;

    public final IItemTrader getTrader() {
        return this.traderSource == null ? null : this.traderSource.get();
    }

    public ItemTraderContainer(int windowId, PlayerInventory inventory, BlockPos traderPos) {
        this(ModContainers.ITEM_TRADER, windowId, inventory, traderPos);
    }

    protected ItemTraderContainer(ContainerType<?> type, int windowId, PlayerInventory inventory, BlockPos traderPos) {
        this(type, windowId, inventory, () -> {
            TileEntity te = inventory.field_70458_d.field_70170_p.func_175625_s(traderPos);
            if (te instanceof IItemTrader) {
                return (IItemTrader)te;
            }
            return null;
        });
    }

    protected ItemTraderContainer(ContainerType<?> type, int windowId, PlayerInventory inventory, Supplier<IItemTrader> traderSource) {
        super(type, windowId);
        int x;
        this.traderSource = traderSource;
        this.player = inventory.field_70458_d;
        this.getTrader().userOpen(this.player);
        for (x = 0; x < this.coinSlots.func_70302_i_(); ++x) {
            this.func_75146_a(new CoinSlot(this.coinSlots, x, ItemTraderUtil.getInventoryDisplayOffset(this.getTrader()) + 8 + (x + 4) * 18, this.getCoinSlotHeight()));
        }
        for (x = 0; x < this.itemSlots.func_70302_i_(); ++x) {
            this.func_75146_a(new Slot(this.itemSlots, x, ItemTraderUtil.getInventoryDisplayOffset(this.getTrader()) + 8 + x * 18, this.getCoinSlotHeight()));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)inventory, x2 + y * 9 + 9, ItemTraderUtil.getInventoryDisplayOffset(this.getTrader()) + 8 + x2 * 18, this.getPlayerInventoryStartHeight() + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, ItemTraderUtil.getInventoryDisplayOffset(this.getTrader()) + 8 + x * 18, this.getPlayerInventoryStartHeight() + 58));
        }
    }

    public int getTradeCount() {
        return this.getTrader().getTradeCount();
    }

    protected int getTradeButtonBottom() {
        return ItemTraderUtil.getTradeDisplayHeight(this.getTrader());
    }

    protected int getCoinSlotHeight() {
        return this.getTradeButtonBottom() + 19;
    }

    protected int getPlayerInventoryStartHeight() {
        return this.getCoinSlotHeight() + 32;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.getTrader() != null;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.coinSlots);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.itemSlots);
        if (this.getTrader() != null) {
            this.getTrader().userClose(this.player);
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index < this.coinSlots.func_70302_i_() + this.itemSlots.func_70302_i_() ? !this.func_75135_a(slotStack, this.coinSlots.func_70302_i_() + this.itemSlots.func_70302_i_(), this.field_75151_b.size(), true) : index < this.field_75151_b.size() && (MoneyUtil.isCoin(slotStack.func_77973_b()) ? !this.func_75135_a(slotStack, 0, this.coinSlots.func_70302_i_(), false) : !this.func_75135_a(slotStack, this.coinSlots.func_70302_i_(), this.coinSlots.func_70302_i_() + this.itemSlots.func_70302_i_(), false))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public long GetCoinValue() {
        long value = 0L;
        for (int i = 0; i < this.coinSlots.func_70302_i_(); ++i) {
            value += MoneyUtil.getValue(this.coinSlots.func_70301_a(i));
        }
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.func_190926_b()) {
            value += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        return value;
    }

    public IInventory GetItemInventory() {
        return this.itemSlots;
    }

    public ItemTradeData GetTrade(int tradeIndex) {
        return (ItemTradeData)this.getTrader().getTrade(tradeIndex);
    }

    @Override
    public void ExecuteTrade(int tradeIndex) {
        if (this.getTrader() == null) {
            this.player.func_71053_j();
            return;
        }
        ItemTradeData trade = (ItemTradeData)this.getTrader().getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return;
        }
        if (this.getTrader().runPreTradeEvent(this.player, tradeIndex).isCanceled()) {
            return;
        }
        CoinValue price = this.getTrader().runTradeCostEvent(this.player, tradeIndex).getCostResult();
        if (trade.isSale()) {
            if (!trade.hasStock(this.getTrader()) && !this.getTrader().getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            if (!InventoryUtil.CanPutItemStack(this.itemSlots, trade.getSellItem())) {
                LightmansCurrency.LogInfo("Not enough room for the output item. Aborting trade!");
                return;
            }
            if (!MoneyUtil.ProcessPayment(this.coinSlots, this.player, price)) {
                LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            ItemStack giveStack = trade.getSellItem();
            if (!InventoryUtil.PutItemStack(this.itemSlots, giveStack)) {
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                List<ItemStack> refundCoins = MoneyUtil.getCoinsOfValue(price);
                ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
                for (int i = 0; i < refundCoins.size(); ++i) {
                    ItemStack coins = refundCoins.get(i);
                    if (!wallet.func_190926_b()) {
                        coins = WalletItem.PickupCoin(wallet, coins);
                    }
                    if (coins.func_190926_b() || (coins = InventoryUtil.TryPutItemStack(this.coinSlots, coins)).func_190926_b()) continue;
                    Inventory temp = new Inventory(1);
                    temp.func_70299_a(0, coins);
                    this.func_193327_a(this.player, this.player.field_70170_p, (IInventory)temp);
                }
                return;
            }
            ((ItemShopLogger)this.getTrader().getLogger()).AddLog(this.player, trade, price, this.getTrader().getCoreSettings().isCreative());
            this.getTrader().markLoggerDirty();
            if (!this.getTrader().getCoreSettings().isCreative()) {
                trade.RemoveItemsFromStorage(this.getTrader().getStorage());
                this.getTrader().addStoredMoney(price);
            }
            this.getTrader().runPostTradeEvent(this.player, tradeIndex, price);
        } else if (trade.isPurchase()) {
            if (InventoryUtil.GetItemCount(this.itemSlots, trade.getSellItem()) < trade.getSellItem().func_190916_E()) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the purchase.");
                return;
            }
            if (!trade.hasSpace(this.getTrader()) && !this.getTrader().getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return;
            }
            if (!trade.hasStock(this.getTrader()) && !this.getTrader().getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough money in storage to pay for the purchased items.");
                return;
            }
            InventoryUtil.RemoveItemCount(this.itemSlots, trade.getSellItem());
            MoneyUtil.ProcessChange(this.coinSlots, this.player, price);
            ((ItemShopLogger)this.getTrader().getLogger()).AddLog(this.player, trade, price, this.getTrader().getCoreSettings().isCreative());
            this.getTrader().markLoggerDirty();
            if (!this.getTrader().getCoreSettings().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getTrader().getStorage(), trade.getSellItem());
                this.getTrader().removeStoredMoney(price);
            }
            this.getTrader().runPostTradeEvent(this.player, tradeIndex, price);
        } else if (trade.isBarter()) {
            if (InventoryUtil.GetItemCount(this.itemSlots, trade.getBarterItem()) < trade.getBarterItem().func_190916_E()) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the barter.");
                return;
            }
            if (!trade.hasSpace(this.getTrader()) && !this.getTrader().getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return;
            }
            if (!trade.hasStock(this.getTrader()) && !this.getTrader().getCoreSettings().isCreative()) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return;
            }
            InventoryUtil.RemoveItemCount(this.itemSlots, trade.getBarterItem());
            if (!InventoryUtil.CanPutItemStack(this.itemSlots, trade.getSellItem())) {
                LightmansCurrency.LogDebug("Not enough room for the output item. Aborting trade!");
                InventoryUtil.PutItemStack(this.itemSlots, trade.getBarterItem());
                return;
            }
            InventoryUtil.PutItemStack(this.itemSlots, trade.getSellItem());
            ((ItemShopLogger)this.getTrader().getLogger()).AddLog(this.player, trade, CoinValue.EMPTY, this.getTrader().getCoreSettings().isCreative());
            this.getTrader().markLoggerDirty();
            if (!this.getTrader().getCoreSettings().isCreative()) {
                InventoryUtil.TryPutItemStack(this.getTrader().getStorage(), trade.getBarterItem());
                trade.RemoveItemsFromStorage(this.getTrader().getStorage());
            }
            this.getTrader().runPostTradeEvent(this.player, tradeIndex, price);
        }
    }

    @Override
    public void CollectCoinStorage() {
        if (this.getTrader() == null) {
            this.player.func_71053_j();
            return;
        }
        if (!this.getTrader().hasPermission(this.player, "collectCoins")) {
            Settings.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            return;
        }
        if (this.getTrader().getCoreSettings().hasBankAccount()) {
            return;
        }
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.getTrader().getInternalStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.func_190926_b()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (int i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.func_190926_b()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            if (InventoryUtil.PutItemStack(this.coinSlots, coinList.get(i))) continue;
            Inventory inventory = new Inventory(1);
            inventory.func_70299_a(0, coinList.get(i));
            this.func_193327_a(this.player, this.player.func_130014_f_(), (IInventory)inventory);
        }
        this.getTrader().clearStoredMoney();
    }

    public boolean hasPermission(String permission) {
        if (this.getTrader() != null) {
            return this.getTrader().hasPermission(this.player, permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        if (this.getTrader() != null) {
            return this.getTrader().getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    public boolean isUniversal() {
        return false;
    }

    public boolean isCashRegister() {
        return false;
    }

    public CashRegisterTileEntity getCashRegister() {
        return null;
    }

    public int getThisCRIndex() {
        return 0;
    }

    public int getTotalCRSize() {
        return 0;
    }

    public static class ItemTraderContainerCR
    extends ItemTraderContainer
    implements ITraderCashRegisterContainer {
        private CashRegisterTileEntity cashRegister;

        public ItemTraderContainerCR(int windowID, PlayerInventory inventory, BlockPos traderPos, CashRegisterTileEntity cashRegister) {
            super(ModContainers.ITEM_TRADER_CR, windowID, inventory, traderPos);
            this.cashRegister = cashRegister;
        }

        @Override
        public boolean isCashRegister() {
            return true;
        }

        @Override
        public CashRegisterTileEntity getCashRegister() {
            return this.cashRegister;
        }

        private TraderTileEntity getTraderTE() {
            IItemTrader trader = super.getTrader();
            if (trader instanceof TraderTileEntity) {
                return (TraderTileEntity)((Object)trader);
            }
            return null;
        }

        @Override
        public int getThisCRIndex() {
            return this.cashRegister.getTraderIndex(this.getTraderTE());
        }

        @Override
        public int getTotalCRSize() {
            return this.cashRegister.getPairedTraderSize();
        }

        @Override
        public void OpenNextContainer(int direction) {
            int thisIndex = this.getThisCRIndex();
            this.cashRegister.OpenContainer(thisIndex, thisIndex + direction, direction, this.player);
        }

        @Override
        public void OpenContainerIndex(int index) {
            int previousIndex = index - 1;
            if (previousIndex < 0) {
                previousIndex = this.cashRegister.getPairedTraderSize() - 1;
            }
            this.cashRegister.OpenContainer(previousIndex, index, 1, this.player);
        }
    }

    public static class ItemTraderContainerUniversal
    extends ItemTraderContainer {
        public ItemTraderContainerUniversal(int windowID, PlayerInventory inventory, UUID traderID) {
            super(ModContainers.ITEM_TRADER_UNIVERSAL, windowID, inventory, () -> {
                UniversalTraderData data = null;
                data = inventory.field_70458_d.field_70170_p.field_72995_K ? ClientTradingOffice.getData(traderID) : TradingOffice.getData(traderID);
                if (data instanceof IItemTrader) {
                    return (IItemTrader)((Object)data);
                }
                return null;
            });
        }

        @Override
        public boolean isUniversal() {
            return true;
        }
    }
}

