/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.ItemTraderStorageUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.containers.interfaces.IItemEditCapable;
import io.github.lightman314.lightmanscurrency.containers.interfaces.ITraderStorageContainer;
import io.github.lightman314.lightmanscurrency.containers.inventories.SuppliedInventory;
import io.github.lightman314.lightmanscurrency.containers.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageOpenItemEdit;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ItemTraderStorageContainer
extends Container
implements ITraderStorageContainer,
IItemEditCapable {
    public static final int SCREEN_EXTENSION = 99;
    public final PlayerEntity player;
    private final Supplier<IItemTrader> traderSource;
    final IInventory safeStorage;
    final IInventory coinSlots;

    public IItemTrader getTrader() {
        return this.traderSource.get();
    }

    public ItemTraderStorageContainer(int windowId, PlayerInventory inventory, BlockPos traderPos) {
        this(ModContainers.ITEM_TRADER_STORAGE, windowId, inventory, () -> {
            TileEntity te = inventory.field_70458_d.field_70170_p.func_175625_s(traderPos);
            if (te instanceof IItemTrader) {
                return (IItemTrader)te;
            }
            return null;
        });
    }

    protected ItemTraderStorageContainer(ContainerType<?> type, int windowId, PlayerInventory inventory, Supplier<IItemTrader> traderSource) {
        super(type, windowId);
        int x;
        this.traderSource = traderSource;
        this.player = inventory.field_70458_d;
        this.getTrader().userOpen(this.player);
        int tradeCount = this.getTrader().getTradeCount();
        int rowCount = ItemTraderStorageUtil.getRowCount(tradeCount);
        int columnCount = 9 * ItemTraderStorageUtil.getColumnCount(tradeCount);
        this.safeStorage = new SuppliedInventory(new SafeStorageSupplier(this.traderSource));
        for (int y = 0; y < rowCount; ++y) {
            for (x = 0; x < columnCount && x + y * columnCount < this.safeStorage.func_70302_i_(); ++x) {
                this.func_75146_a(new Slot(this.safeStorage, x + y * columnCount, 8 + x * 18 + 99 + ItemTraderStorageUtil.getStorageSlotOffset(tradeCount, y), 18 + y * 18));
            }
        }
        int inventoryOffset = ItemTraderStorageUtil.getInventoryOffset(tradeCount);
        this.coinSlots = new Inventory(5);
        for (int i = 0; i < 5; ++i) {
            this.func_75146_a(new CoinSlot(this.coinSlots, i, inventoryOffset + 176 + 8 + 99, this.getStorageBottom() + 3 + i * 18));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)inventory, x2 + y * 9 + 9, inventoryOffset + 8 + x2 * 18 + 99, this.getStorageBottom() + 15 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, inventoryOffset + 8 + x * 18 + 99, this.getStorageBottom() + 15 + 58));
        }
    }

    public int getStorageBottom() {
        return ItemTraderStorageUtil.getRowCount(this.getTrader().getTradeCount()) * 18 + 28;
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index < this.getTrader().getStorage().func_70302_i_()) {
                if (!this.func_75135_a(slotStack, this.getTrader().getStorage().func_70302_i_() + this.coinSlots.func_70302_i_(), this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index < this.getTrader().getStorage().func_70302_i_() + this.coinSlots.func_70302_i_()) {
                LightmansCurrency.LogInfo("Merging coin slots back into inventory.");
                if (!this.func_75135_a(slotStack, this.getTrader().getStorage().func_70302_i_() + this.coinSlots.func_70302_i_(), this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (MoneyUtil.isCoin(slotStack) ? !this.func_75135_a(slotStack, this.getTrader().getStorage().func_70302_i_(), this.getTrader().getStorage().func_70302_i_() + this.coinSlots.func_70302_i_(), false) : !this.func_75135_a(slotStack, 0, this.getTrader().getStorage().func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.getTrader() != null && this.getTrader().hasPermission(playerIn, "openStorage");
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.coinSlots);
        super.func_75134_a(playerIn);
        if (this.getTrader() != null) {
            this.getTrader().userClose(this.player);
        }
    }

    public boolean hasPermission(String permission) {
        if (this.getTrader() != null) {
            return this.getTrader().hasPermission(this.player, permission);
        }
        return false;
    }

    public int getPermissionLevel(String permission) {
        if (this.getTrader() != null) {
            return this.getTrader().getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    @Override
    public void openItemEditScreenForTrade(int tradeIndex) {
        if (!this.hasPermission("editTrades")) {
            Settings.PermissionWarning(this.player, "open item edit", "editTrades");
            return;
        }
        if (this.player.field_70170_p.field_72995_K) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenItemEdit(tradeIndex));
        } else {
            this.getTrader().openItemEditMenu(this.player, tradeIndex);
        }
    }

    public boolean HasCoinsToAdd() {
        return !this.coinSlots.func_191420_l();
    }

    @Override
    public void AddCoins() {
        if (this.getTrader() == null) {
            this.player.func_71053_j();
            return;
        }
        if (!this.hasPermission("storeCoins")) {
            Settings.PermissionWarning(this.player, "store coins", "storeCoins");
            return;
        }
        CoinValue addValue = CoinValue.easyBuild2(this.coinSlots);
        this.getTrader().addStoredMoney(addValue);
        this.coinSlots.func_174888_l();
    }

    @Override
    public void CollectCoinStorage() {
        int i;
        if (this.getTrader() == null) {
            this.player.func_71053_j();
            return;
        }
        if (!this.hasPermission("collectCoins")) {
            Settings.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            return;
        }
        if (this.getTrader().getCoreSettings().hasBankAccount()) {
            return;
        }
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.getTrader().getInternalStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.func_190926_b()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.func_190926_b()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        Inventory inventory = new Inventory(coinList.size());
        for (i = 0; i < coinList.size(); ++i) {
            inventory.func_70299_a(i, coinList.get(i));
        }
        this.func_193327_a(this.player, this.player.func_130014_f_(), (IInventory)inventory);
        this.getTrader().clearStoredMoney();
    }

    public boolean isUniversal() {
        return false;
    }

    private class SafeStorageSupplier
    implements Supplier<IInventory> {
        private final Supplier<IItemTrader> traderSource;
        private final int storageSize;

        private final IItemTrader getTrader() {
            return this.traderSource.get();
        }

        SafeStorageSupplier(Supplier<IItemTrader> traderSource) {
            this.traderSource = traderSource;
            this.storageSize = this.getTrader().getStorage().func_70302_i_();
        }

        @Override
        public IInventory get() {
            IItemTrader trader = this.getTrader();
            if (trader != null) {
                return trader.getStorage();
            }
            return new Inventory(this.storageSize);
        }
    }

    public static class ItemTraderStorageContainerUniversal
    extends ItemTraderStorageContainer {
        public ItemTraderStorageContainerUniversal(int windowID, PlayerInventory inventory, UUID traderID) {
            super(ModContainers.ITEM_TRADER_STORAGE_UNIVERSAL, windowID, inventory, () -> {
                UniversalTraderData data = null;
                data = inventory.field_70458_d.field_70170_p.field_72995_K ? ClientTradingOffice.getData(traderID) : TradingOffice.getData(traderID);
                if (data instanceof IItemTrader) {
                    return (IItemTrader)((Object)data);
                }
                return null;
            });
        }

        @Override
        public boolean isUniversal() {
            return true;
        }
    }
}

