/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.containers.interfaces.ITraderContainerPrimitive;
import io.github.lightman314.lightmanscurrency.containers.inventories.TicketInventory;
import io.github.lightman314.lightmanscurrency.containers.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.containers.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.tileentity.PaygateTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class PaygateContainer
extends Container
implements ITraderContainerPrimitive {
    public final PlayerEntity player;
    protected static final ContainerType<?> type = ModContainers.ITEM_TRADER;
    protected final IInventory coinInput = new Inventory(5);
    protected final IInventory ticketInput = new TicketInventory(1);
    public final PaygateTileEntity tileEntity;
    public final int priceInputOffset;

    public PaygateContainer(int windowId, PlayerInventory inventory, PaygateTileEntity tileEntity) {
        super(ModContainers.PAYGATE, windowId);
        int x;
        this.tileEntity = tileEntity;
        this.player = inventory.field_70458_d;
        this.priceInputOffset = this.isOwner() ? 69 : 0;
        for (x = 0; x < this.coinInput.func_70302_i_(); ++x) {
            this.func_75146_a(new CoinSlot(this.coinInput, x, 8 + (x + 4) * 18, 37 + this.priceInputOffset));
        }
        this.func_75146_a(new TicketSlot(this.ticketInput, 0, 62, 37 + this.priceInputOffset));
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 69 + y * 18 + this.priceInputOffset));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 127 + this.priceInputOffset));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.coinInput);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.ticketInput);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index < this.coinInput.func_70302_i_() ? !this.func_75135_a(slotStack, this.coinInput.func_70302_i_(), this.field_75151_b.size(), true) : (index >= this.coinInput.func_70302_i_() && index < this.coinInput.func_70302_i_() + this.ticketInput.func_70302_i_() ? !this.func_75135_a(slotStack, this.coinInput.func_70302_i_() + this.ticketInput.func_70302_i_(), this.field_75151_b.size(), true) : index < this.field_75151_b.size() && !this.func_75135_a(slotStack, 0, this.coinInput.func_70302_i_() + this.ticketInput.func_70302_i_(), false))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public boolean HasMasterTicket() {
        return TicketItem.isMasterTicket(this.ticketInput.func_70301_a(0));
    }

    public boolean HasValidTicket() {
        ItemStack ticket = this.ticketInput.func_70301_a(0);
        if (TicketItem.isMasterTicket(ticket)) {
            return false;
        }
        return this.tileEntity.validTicket(ticket);
    }

    public UUID GetTicketID() {
        return TicketItem.GetTicketID(this.ticketInput.func_70301_a(0));
    }

    public long GetCoinValue() {
        long value = 0L;
        for (int i = 0; i < this.coinInput.func_70302_i_(); ++i) {
            value += MoneyUtil.getValue(this.coinInput.func_70301_a(i));
        }
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.func_190926_b()) {
            value += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        return value;
    }

    public boolean CanActivate() {
        if (this.tileEntity.isActive()) {
            return false;
        }
        if (this.tileEntity.HasPairedTicket()) {
            if (this.tileEntity.getPrice().getRawValue() <= 0L) {
                return this.HasValidTicket();
            }
            return this.HasValidTicket() || this.GetCoinValue() >= this.tileEntity.getPrice().getRawValue();
        }
        return this.GetCoinValue() >= this.tileEntity.getPrice().getRawValue();
    }

    public void Activate() {
        if (!this.CanActivate()) {
            return;
        }
        if (this.HasValidTicket()) {
            this.ticketInput.func_70298_a(0, 1);
            ItemStack ticketStub = new ItemStack((IItemProvider)ModItems.TICKET_STUB);
            if (this.ticketInput.func_70301_a(0).func_190926_b()) {
                this.ticketInput.func_70299_a(0, ticketStub);
            } else {
                Inventory temp = new Inventory(1);
                temp.func_70299_a(0, ticketStub);
                this.func_193327_a(this.player, this.player.field_70170_p, (IInventory)temp);
            }
        } else {
            if (!MoneyUtil.ProcessPayment(this.coinInput, this.player, this.tileEntity.getPrice())) {
                return;
            }
            this.tileEntity.addStoredMoney(this.tileEntity.getPrice());
        }
        this.tileEntity.activate();
    }

    @Override
    public void CollectCoinStorage() {
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.tileEntity.getStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.func_190926_b()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (int i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.func_190926_b()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            if (this.manualCoinMerge(coinList.get(i))) continue;
            Inventory inventory = new Inventory(1);
            inventory.func_70299_a(0, coinList.get(i));
            this.func_193327_a(this.player, this.player.func_130014_f_(), (IInventory)inventory);
        }
        this.tileEntity.clearStoredMoney();
    }

    private boolean manualCoinMerge(ItemStack mergeStack) {
        int availableSlots;
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = mergeStack.func_190916_E();
        Item mergeItem = mergeStack.func_77973_b();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < this.coinInput.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = this.coinInput.func_70301_a(i);
            if (inventoryStack.func_77973_b() != mergeItem || inventoryStack.func_190916_E() == inventoryStack.func_77976_d()) continue;
            amountToPlace = amountToMerge;
            availableSlots = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
            if (amountToPlace > availableSlots) {
                amountToPlace = availableSlots;
            }
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < this.coinInput.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = this.coinInput.func_70301_a(i);
            if (!inventoryStack.func_190926_b()) continue;
            amountToPlace = amountToMerge;
            availableSlots = 64;
            if (amountToPlace > availableSlots) {
                amountToPlace = availableSlots;
            }
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            ItemStack itemStack = this.coinInput.func_70301_a(((Integer)order.getFirst()).intValue());
            if (itemStack.func_190926_b()) {
                this.coinInput.func_70299_a(((Integer)order.getFirst()).intValue(), new ItemStack((IItemProvider)mergeItem, ((Integer)order.getSecond()).intValue()));
            } else {
                this.coinInput.func_70299_a(((Integer)order.getFirst()).intValue(), new ItemStack((IItemProvider)mergeItem, (Integer)order.getSecond() + itemStack.func_190916_E()));
            }
        });
        return true;
    }

    public boolean isOwner() {
        return this.tileEntity.isOwner((Entity)this.player);
    }
}

