/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.containers.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.containers.slots.TicketMasterSlot;
import io.github.lightman314.lightmanscurrency.containers.slots.TicketMaterialSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.tileentity.TicketMachineTileEntity;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class TicketMachineContainer
extends Container {
    private final IInventory outputSlot = new Inventory(1);
    private final IInventory objectInputs;
    private final TicketMachineTileEntity tileEntity;

    public TicketMachineContainer(int windowId, PlayerInventory inventory, TicketMachineTileEntity tileEntity) {
        super(ModContainers.TICKET_MACHINE, windowId);
        this.tileEntity = tileEntity;
        this.objectInputs = new DoubleSidedInventory(this.tileEntity.getStorage(), this.outputSlot);
        this.func_75146_a(new TicketMasterSlot(this.objectInputs, 0, 20, 21));
        this.func_75146_a(new TicketMaterialSlot(this.objectInputs, 1, 56, 21));
        this.func_75146_a(new OutputSlot(this.objectInputs, 2, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, x + y * 9 + 9, 8 + x * 18, 56 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 114));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.outputSlot);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index < this.objectInputs.func_70302_i_() ? !this.func_75135_a(slotStack, this.objectInputs.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.objectInputs.func_70302_i_() - 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        return !this.objectInputs.func_70301_a(1).func_190926_b();
    }

    public boolean validOutputs() {
        ItemStack outputStack = this.objectInputs.func_70301_a(2);
        if (outputStack.func_190926_b()) {
            return true;
        }
        if (this.hasMasterTicket() && outputStack.func_77973_b() == ModItems.TICKET) {
            UUID ticketID = this.getTicketID();
            UUID outputTicketID = TicketItem.GetTicketID(outputStack);
            return outputTicketID != null && ticketID.equals(outputTicketID);
        }
        return false;
    }

    public boolean hasMasterTicket() {
        ItemStack masterTicket = this.objectInputs.func_70301_a(0);
        return !masterTicket.func_190926_b() && TicketItem.isMasterTicket(masterTicket);
    }

    public void craftTickets(boolean fullStack) {
        if (!this.validInputs()) {
            LightmansCurrency.LogWarning("Inputs for the Ticket Machine are not valid. Cannot craft tickets.");
            return;
        }
        if (!this.validOutputs()) {
            LightmansCurrency.LogWarning("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        if (this.hasMasterTicket()) {
            ItemStack outputStack;
            int count = 1;
            if (fullStack) {
                count = this.objectInputs.func_70301_a(1).func_190916_E();
            }
            if ((outputStack = this.objectInputs.func_70301_a(2)).func_190926_b()) {
                ItemStack newTicket = TicketItem.CreateTicket(this.getTicketID(), count);
                this.objectInputs.func_70299_a(2, newTicket);
            } else {
                count = outputStack.func_77976_d() - outputStack.func_190916_E();
                outputStack.func_190920_e(outputStack.func_190916_E() + count);
            }
            this.objectInputs.func_70298_a(1, count);
        } else {
            ItemStack newTicket = TicketItem.CreateMasterTicket(UUID.randomUUID());
            this.objectInputs.func_70299_a(2, newTicket);
            this.objectInputs.func_70298_a(1, 1);
        }
    }

    public UUID getTicketID() {
        ItemStack masterTicket = this.objectInputs.func_70301_a(0);
        if (TicketItem.isMasterTicket(masterTicket)) {
            return TicketItem.GetTicketID(masterTicket);
        }
        return null;
    }
}

