/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.containers.slots.BlacklistSlot;
import io.github.lightman314.lightmanscurrency.containers.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.containers.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.containers.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WalletContainer
extends Container
implements BankAccount.IBankAccountMenu {
    private final int walletStackIndex;
    private final PlayerInventory inventory;
    private final List<IWalletContainerListener> listeners = Lists.newArrayList();
    private final IInventory walletInventory;
    private IInventory coinInput;
    private WalletItem walletItem;
    boolean autoConvert = false;
    private final PlayerEntity player;
    BankAccount.AccountReference accountSource;
    int width = 0;
    int height = 0;

    public int getWalletIndex() {
        return this.walletStackIndex;
    }

    public boolean hasWallet() {
        ItemStack wallet = this.getWallet();
        return !wallet.func_190926_b() && wallet.func_77973_b() instanceof WalletItem;
    }

    private ItemStack getWallet() {
        if (this.walletStackIndex < 0) {
            return LightmansCurrency.getWalletStack(this.inventory.field_70458_d);
        }
        return this.inventory.func_70301_a(this.walletStackIndex);
    }

    public ITextComponent getTitle() {
        ItemStack wallet = this.getWallet();
        if (wallet.func_190926_b()) {
            return new StringTextComponent("");
        }
        return wallet.func_200301_q();
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public BankAccount getAccount() {
        return this.accountSource.get();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public WalletContainer(int windowId, PlayerInventory inventory, int walletStackIndex) {
        super(ModContainers.WALLET, windowId);
        this.walletStackIndex = walletStackIndex;
        this.inventory = inventory;
        AtomicReference walletInvReference = new AtomicReference();
        WalletCapability.getWalletHandler((Entity)inventory.field_70458_d).ifPresent(walletHandler -> walletInvReference.set(walletHandler.getInventory()));
        this.walletInventory = (IInventory)walletInvReference.get();
        if (this.walletInventory == null) {
            LightmansCurrency.LogError("Cannot open a Wallet Container for a player that doesn't have a valid WalletHandler capability present.");
            inventory.field_70458_d.func_71053_j();
        }
        this.player = inventory.field_70458_d;
        this.accountSource = BankAccount.GenerateReference(this.player);
        this.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void init() {
        int x;
        int y;
        this.field_75151_b.clear();
        Item wi = this.getWallet().func_77973_b();
        this.walletItem = wi instanceof WalletItem ? (WalletItem)wi : null;
        int yOffset = this.getVerticalOffset();
        this.coinInput = new Inventory(WalletItem.InventorySize(this.walletItem));
        NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(this.getWallet());
        for (int i = 0; i < this.coinInput.func_70302_i_() && i < walletInventory.size(); ++i) {
            this.coinInput.func_70299_a(i, (ItemStack)walletInventory.get(i));
        }
        WalletSlot walletSlot = new WalletSlot(this.walletInventory, 0, -22, 6 + yOffset).addListener(this::init);
        if (this.walletStackIndex >= 0) {
            walletSlot.setBlacklist((IInventory)this.inventory, this.walletStackIndex);
        }
        this.func_75146_a(walletSlot);
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                if (x + y * 9 + 9 == this.walletStackIndex) {
                    this.func_75146_a(new DisplaySlot((IInventory)this.inventory, x + y * 9 + 9, 8 + x * 18, 32 + (y + this.getRowCount()) * 18 + yOffset));
                    continue;
                }
                this.func_75146_a(new BlacklistSlot((IInventory)this.inventory, x + y * 9 + 9, 8 + x * 18, 32 + (y + this.getRowCount()) * 18 + yOffset, (IInventory)this.inventory, this.walletStackIndex));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            if (x2 == this.walletStackIndex) {
                this.func_75146_a(new DisplaySlot((IInventory)this.inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18 + yOffset));
                continue;
            }
            this.func_75146_a(new BlacklistSlot((IInventory)this.inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18 + yOffset, (IInventory)this.inventory, this.walletStackIndex));
        }
        y = 0;
        while (y * 9 < this.coinInput.func_70302_i_()) {
            for (x = 0; x < 9 && x + y * 9 < this.coinInput.func_70302_i_(); ++x) {
                this.func_75146_a(new CoinSlot(this.coinInput, x + y * 9, 8 + x * 18, 18 + y * 18 + yOffset));
            }
            ++y;
        }
        this.autoConvert = WalletItem.getAutoConvert(this.getWallet());
        this.listeners.forEach(listener -> listener.onReload());
    }

    public void addListener(IWalletContainerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public int getVerticalOffset() {
        if (this.hasBankAccess()) {
            return 109;
        }
        return 0;
    }

    public int getRowCount() {
        return 1 + (this.coinInput.func_70302_i_() - 1) / 9;
    }

    public int getSlotCount() {
        return this.coinInput.func_70302_i_();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.saveWalletContents();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        if (this.getWallet().func_190926_b()) {
            return;
        }
        this.saveWalletContents();
    }

    public void saveWalletContents() {
        if (this.getWallet().func_190926_b()) {
            return;
        }
        NonNullList walletInventory = NonNullList.func_191197_a((int)WalletItem.InventorySize(this.getWallet()), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < walletInventory.size() && i < this.coinInput.func_70302_i_(); ++i) {
            walletInventory.set(i, (Object)this.coinInput.func_70301_a(i));
        }
        WalletItem.putWalletInventory(this.getWallet(), (NonNullList<ItemStack>)walletInventory);
        if (this.autoConvert != WalletItem.getAutoConvert(this.getWallet())) {
            WalletItem.toggleAutoConvert(this.getWallet());
        }
    }

    public boolean canConvert() {
        if (this.getWallet().func_190926_b()) {
            return false;
        }
        return WalletItem.CanConvert(this.walletItem);
    }

    public boolean canPickup() {
        return WalletItem.CanPickup(this.walletItem);
    }

    public boolean hasBankAccess() {
        return WalletItem.HasBankAccess(this.walletItem);
    }

    public boolean getAutoConvert() {
        return this.autoConvert;
    }

    public void ToggleAutoConvert() {
        this.autoConvert = !this.autoConvert;
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        if (index + this.coinInput.func_70302_i_() == this.walletStackIndex) {
            return ItemStack.field_190927_a;
        }
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            clickedStack = slotStack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(slotStack, 1, 37, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index < 37) {
                if (clickedStack.func_77973_b() instanceof WalletItem && !this.func_75135_a(slotStack, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slotStack, 37, this.field_75151_b.size(), false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, 1, 37, true)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }

    public void ConvertCoins() {
        MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        MoneyUtil.SortCoins(this.coinInput);
    }

    @Override
    public void onDepositOrWithdraw() {
        if (this.canConvert()) {
            this.ConvertCoins();
        }
    }

    public ItemStack PickupCoins(ItemStack stack) {
        ItemStack returnValue = stack.func_77946_l();
        for (int i = 0; i < this.coinInput.func_70302_i_() && !returnValue.func_190926_b(); ++i) {
            ItemStack thisStack = this.coinInput.func_70301_a(i);
            if (thisStack.func_190926_b()) {
                this.coinInput.func_70299_a(i, returnValue.func_77946_l());
                returnValue = ItemStack.field_190927_a;
                continue;
            }
            if (thisStack.func_77973_b() != returnValue.func_77973_b()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.func_190916_E(), 0, thisStack.func_77976_d() - thisStack.func_190916_E());
            thisStack.func_190920_e(thisStack.func_190916_E() + amountToAdd);
            returnValue.func_190920_e(returnValue.func_190916_E() - amountToAdd);
        }
        if (this.autoConvert) {
            this.ConvertCoins();
        }
        return returnValue;
    }

    @Override
    public IInventory getCoinInput() {
        return this.coinInput;
    }

    public static interface IWalletContainerListener {
        public void onReload();
    }
}

