/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers.slots;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.containers.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CoinSlot
extends SimpleSlot {
    public static final ResourceLocation EMPTY_COIN_SLOT = new ResourceLocation("lightmanscurrency", "items/empty_coin_slot");
    private boolean acceptHiddenCoins;
    private boolean lockInput = false;
    private boolean lockOutput = false;
    private List<ICoinSlotListener> listeners = Lists.newArrayList();

    public void LockInput() {
        this.lockInput = true;
    }

    public void UnlockInput() {
        this.lockInput = false;
    }

    public void LockOutput() {
        this.lockOutput = true;
    }

    public void UnlockOutput() {
        this.lockOutput = false;
    }

    public void Lock() {
        this.lockOutput = true;
        this.lockInput = true;
    }

    public void Unlock() {
        this.lockOutput = false;
        this.lockInput = false;
    }

    public CoinSlot(IInventory inventory, int index, int x, int y) {
        this(inventory, index, x, y, true);
    }

    public CoinSlot(IInventory inventory, int index, int x, int y, boolean acceptHiddenCoins) {
        super(inventory, index, x, y);
        this.acceptHiddenCoins = acceptHiddenCoins;
    }

    public CoinSlot addListener(ICoinSlotListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public boolean func_75214_a(ItemStack stack) {
        if (this.lockInput) {
            return false;
        }
        if (this.acceptHiddenCoins) {
            return MoneyUtil.isCoin(stack.func_77973_b());
        }
        return MoneyUtil.isCoin(stack.func_77973_b()) && !MoneyUtil.isCoinHidden(stack.func_77973_b());
    }

    public void func_75215_d(ItemStack stack) {
        if (this.lockInput && !stack.func_190926_b()) {
            return;
        }
        super.func_75215_d(stack);
    }

    public ItemStack func_75209_a(int amount) {
        if (this.lockOutput) {
            return ItemStack.field_190927_a;
        }
        return super.func_75209_a(amount);
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        if (this.lockOutput) {
            return false;
        }
        return super.func_82869_a(playerIn);
    }

    public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
        return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_COIN_SLOT);
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.listeners.forEach(listener -> listener.onCoinSlotChanged());
    }

    public static interface ICoinSlotListener {
        public void onCoinSlotChanged();
    }
}

