/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.containers.slots;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WalletSlot
extends Slot {
    public static final ResourceLocation EMPTY_WALLET_SLOT = new ResourceLocation("lightmanscurrency", "items/empty_wallet_slot");
    private final List<IWalletSlotListener> listeners = Lists.newArrayList();
    IInventory blacklistInventory;
    int blacklistIndex;

    public WalletSlot(IInventory inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public boolean func_75214_a(ItemStack stack) {
        if (this.blacklistIndex >= 0 && this.blacklistInventory != null && stack == this.getBlacklistedItem()) {
            return false;
        }
        return WalletSlot.isValidWallet(stack);
    }

    public WalletSlot addListener(IWalletSlotListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public static boolean isValidWallet(ItemStack stack) {
        return stack.func_77973_b() instanceof WalletItem;
    }

    public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
        return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_WALLET_SLOT);
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.listeners.forEach(listener -> listener.onWalletSlotChanged());
    }

    ItemStack getBlacklistedItem() {
        return this.blacklistInventory.func_70301_a(this.blacklistIndex);
    }

    public void setBlacklist(IInventory blacklistInventory, int blacklistIndex) {
        this.blacklistInventory = blacklistInventory;
        this.blacklistIndex = blacklistIndex;
    }

    public static interface IWalletSlotListener {
        public void onWalletSlotChanged();
    }
}

