/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.SpawnTrackerCapability;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LootManager {
    public static final float LOOTING_MODIFIER = 0.01f;
    private static final String ENTITY = "minecraft:";
    private static final String CHEST = "minecraft:chests/";
    public static final List<String> ENTITY_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:slime", (Object)"minecraft:silverfish");
    public static final List<String> ENTITY_IRON_DROPLIST = ImmutableList.of((Object)"minecraft:zombie", (Object)"minecraft:skeleton", (Object)"minecraft:creeper", (Object)"minecraft:spider", (Object)"minecraft:cave_spider", (Object)"minecraft:husk", (Object)"minecraft:stray", (Object)"minecraft:magma_cube", (Object)"minecraft:zombie_villager", (Object)"minecraft:drowned");
    public static final List<String> ENTITY_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:guardian", (Object)"minecraft:elder_guardian", (Object)"minecraft:phantom", (Object)"minecraft:blaze", (Object)"minecraft:ghast", (Object)"minecraft:witch", (Object)"minecraft:hoglin", (Object)"minecraft:piglin_brute", (Object)"minecraft:piglin", (Object)"minecraft:zombified_piglin");
    public static final List<String> ENTITY_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:enderman", (Object)"minecraft:evoker", (Object)"minecraft:vindicator", (Object)"minecraft:pillager", (Object)"minecraft:ravager", (Object)"minecraft:shulker");
    public static final List<String> ENTITY_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:wither_skeleton");
    public static final List<String> ENTITY_NETHERITE_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_COPPER_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_GOLD_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_EMERALD_DROPLIST = ImmutableList.of();
    public static final List<String> ENTITY_BOSS_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:ender_dragon");
    public static final List<String> ENTITY_BOSS_NETHERITE_DROPLIST = ImmutableList.of((Object)"minecraft:wither");
    public static final List<String> CHEST_COPPER_DROPLIST = ImmutableList.of((Object)"minecraft:chests/underwater_ruin_small", (Object)"minecraft:chests/underwater_ruin_big");
    public static final List<String> CHEST_IRON_DROPLIST = ImmutableList.of();
    public static final List<String> CHEST_GOLD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/jungle_temple", (Object)"minecraft:chests/nether_bridge", (Object)"minecraft:chests/simple_dungeon", (Object)"minecraft:chests/ruined_portal");
    public static final List<String> CHEST_EMERALD_DROPLIST = ImmutableList.of((Object)"minecraft:chests/stronghold_crossing", (Object)"minecraft:chests/stronghold_corridor", (Object)"minecraft:chests/stronghold_library");
    public static final List<String> CHEST_DIAMOND_DROPLIST = ImmutableList.of((Object)"minecraft:chests/buried_treasure", (Object)"minecraft:chests/bastion_hoglin_stable", (Object)"minecraft:chests/bastion_bridge", (Object)"minecraft:chests/bastion_other", (Object)"minecraft:chests/bastion_treasure", (Object)"minecraft:chests/end_city_treasure");
    public static final List<String> CHEST_NETHERITE_DROPLIST = ImmutableList.of();
    private static final List<Pair<String, PoolLevel>> EXTERNAL_ENTITY_ENTRIES = new ArrayList<Pair<String, PoolLevel>>();
    private static final List<Pair<String, PoolLevel>> EXTERNAL_CHEST_ENTRIES = new ArrayList<Pair<String, PoolLevel>>();
    private static final LootPool.Builder ENTITY_LOOT_COPPER = LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 1.0f, 10.0f, 0.75f, "lightmanscurrency:entityloot_copper", true);
    private static final LootPool.Builder ENTITY_LOOT_IRON = LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 1.0f, 5.0f, 0.5f, "lightmanscurrency:entityloot_iron", true);
    private static final LootPool.Builder ENTITY_LOOT_GOLD = LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 1.0f, 5.0f, 0.25f, "lightmanscurrency:entityloot_gold", true);
    private static final LootPool.Builder ENTITY_LOOT_EMERALD = LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 1.0f, 3.0f, 0.1f, "lightmanscurrency:entityloot_emerald", true);
    private static final LootPool.Builder ENTITY_LOOT_DIAMOND = LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 1.0f, 3.0f, 0.05f, "lightmanscurrency:entityloot_diamond", true);
    private static final LootPool.Builder ENTITY_LOOT_NETHERITE = LootManager.GenerateEntityCoinPool(ModItems.COIN_NETHERITE, 1.0f, 3.0f, 0.025f, "lightmanscurrency:entityloot_netherite", true);
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_COPPER = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_IRON = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_GOLD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_EMERALD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_DIAMOND = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false));
    private static final List<LootPool.Builder> ENTITY_LOOT_BOSS_NETHERITE = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_COPPER, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_IRON, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_GOLD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_EMERALD, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_DIAMOND, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false), (Object)LootManager.GenerateEntityCoinPool(ModItems.COIN_NETHERITE, 1.0f, 5.0f, 1.0f, "lightmanscurrency:coinloot_boss_netherite", false));
    private static final LootPool.Builder CHEST_LOOT_COPPER = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER}, 1.0f, 5.0f, "lightmanscurrency:chestloot_copper");
    private static final LootPool.Builder CHEST_LOOT_IRON = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON}, 1.0f, 5.0f, "lightmanscurrency:chestloot_iron");
    private static final LootPool.Builder CHEST_LOOT_GOLD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD}, 2.0f, 6.0f, "lightmanscurrency:chestloot_gold");
    private static final LootPool.Builder CHEST_LOOT_EMERALD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD}, 3.0f, 6.0f, "lightmanscurrency:chestloot_emerald");
    private static final LootPool.Builder CHEST_LOOT_DIAMOND = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND}, 3.0f, 6.0f, "lightmanscurrency:chestloot_diamond");
    private static final LootPool.Builder CHEST_LOOT_NETHERITE = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND, ChestLootEntryData.NETHERITE}, 3.0f, 6.0f, "lightmanscurrency:chestloot_netherite");

    public static boolean isValidSpawnReason(String reasonString) {
        for (SpawnReason reason : SpawnReason.values()) {
            if (reason.toString() != reasonString) continue;
            return true;
        }
        return false;
    }

    public static SpawnReason deserializeSpawnReason(String reasonString) {
        return LootManager.deserializeSpawnReason(reasonString, SpawnReason.NATURAL);
    }

    public static SpawnReason deserializeSpawnReason(String reasonString, SpawnReason defaultReason) {
        for (SpawnReason reason : SpawnReason.values()) {
            if (!reason.toString().contentEquals(reasonString)) continue;
            return reason;
        }
        LightmansCurrency.LogWarning("Reason string \"" + reasonString + "\" could not be properly deserialized. Returning the default spawn reason.");
        return defaultReason;
    }

    public static boolean containsReason(List<? extends String> reasonList, SpawnReason reason) {
        for (int i = 0; i < reasonList.size(); ++i) {
            if (!reason.toString().contentEquals(reasonList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getSpawnReasonList() {
        StringBuffer output = new StringBuffer();
        for (SpawnReason reason : SpawnReason.values()) {
            if (output.length() > 0) {
                output.append(", ");
            }
            output.append(reason);
        }
        return output.toString();
    }

    @SubscribeEvent
    public static void onLootTablesLoaded(LootTableLoadEvent event) {
        String name = event.getName().toString();
        LootTable table = event.getTable();
        if (((List)Config.COMMON.copperChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.COPPER, name);
        } else if (((List)Config.COMMON.ironChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.IRON, name);
        } else if (((List)Config.COMMON.goldChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.GOLD, name);
        } else if (((List)Config.COMMON.emeraldChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.EMERALD, name);
        } else if (((List)Config.COMMON.diamondChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.DIAMOND, name);
        } else if (((List)Config.COMMON.netheriteChestDrops.get()).contains(name)) {
            LootManager.AddChestPoolToTable(table, PoolLevel.NETHERITE, name);
        } else {
            for (Pair<String, PoolLevel> pair : EXTERNAL_CHEST_ENTRIES) {
                if (pair.getFirst() != name) continue;
                LootManager.AddChestPoolToTable(table, (PoolLevel)((Object)pair.getSecond()), name);
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawned(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            return;
        }
        SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).ifPresent(spawnerTracker -> spawnerTracker.setSpawnReason(event.getSpawnReason()));
        if (!SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).isPresent()) {
            LightmansCurrency.LogWarning(event.getEntityLiving().func_200200_C_().getString() + " does not have a ISpawnerTracker capability attached. Unable to flag it's SpawnReason.");
        }
    }

    @SubscribeEvent
    public static void attachSpawnTrackerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && !(event.getObject() instanceof PlayerEntity)) {
            event.addCapability(CurrencyCapabilities.ID_SPAWNER_TRACKER, SpawnTrackerCapability.createProvider((LivingEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!((Boolean)Config.COMMON.enableSpawnerEntityDrops.get()).booleanValue()) {
            AtomicReference spawnReason = new AtomicReference();
            SpawnTrackerCapability.getSpawnerTracker(event.getEntityLiving()).ifPresent(spawnerTracker -> spawnReason.set(spawnerTracker.spawnReason()));
            if (spawnReason.get() == SpawnReason.SPAWNER) {
                LightmansCurrency.LogInfo(event.getEntityLiving().func_200200_C_().getString() + " did not drop coins, as it was spawned by a spawner.");
                return;
            }
        }
        String name = event.getEntityLiving().func_70022_Q();
        PlayerEntity player = null;
        if (event.getSource().func_76364_f() instanceof PlayerEntity || event.getSource().func_76346_g() instanceof PlayerEntity) {
            player = event.getSource().func_76364_f() instanceof PlayerEntity ? (PlayerEntity)event.getSource().func_76364_f() : (PlayerEntity)event.getSource().func_76346_g();
            if (((List)Config.COMMON.copperEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.COPPER);
            } else if (((List)Config.COMMON.ironEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.IRON);
            } else if (((List)Config.COMMON.goldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.GOLD);
            } else if (((List)Config.COMMON.emeraldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.EMERALD);
            } else if (((List)Config.COMMON.diamondEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.DIAMOND);
            } else if (((List)Config.COMMON.netheriteEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.NETHERITE);
            } else if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_COPPER);
            } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_IRON);
            } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_GOLD);
            } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_EMERALD);
            } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_DIAMOND);
            } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_NETHERITE);
            } else {
                for (Pair<String, PoolLevel> pair : EXTERNAL_ENTITY_ENTRIES) {
                    if (pair.getFirst() != name || pair.getSecond() == PoolLevel.BOSS_COPPER || pair.getSecond() == PoolLevel.BOSS_IRON || pair.getSecond() == PoolLevel.BOSS_GOLD || pair.getSecond() == PoolLevel.BOSS_EMERALD || pair.getSecond() == PoolLevel.BOSS_DIAMOND || pair.getSecond() == PoolLevel.BOSS_NETHERITE) continue;
                    LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, (PoolLevel)((Object)pair.getSecond()));
                }
            }
        }
        if (((List)Config.COMMON.bossCopperEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_COPPER);
        } else if (((List)Config.COMMON.bossIronEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_IRON);
        } else if (((List)Config.COMMON.bossGoldEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_GOLD);
        } else if (((List)Config.COMMON.bossEmeraldEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_EMERALD);
        } else if (((List)Config.COMMON.bossDiamondEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_DIAMOND);
        } else if (((List)Config.COMMON.bossNetheriteEntityDrops.get()).contains(name)) {
            LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, PoolLevel.BOSS_NETHERITE);
        } else {
            for (Pair<String, PoolLevel> pair : EXTERNAL_ENTITY_ENTRIES) {
                if (pair.getFirst() != name || pair.getSecond() != PoolLevel.BOSS_COPPER && pair.getSecond() != PoolLevel.BOSS_IRON && pair.getSecond() != PoolLevel.BOSS_GOLD && pair.getSecond() != PoolLevel.BOSS_EMERALD && pair.getSecond() != PoolLevel.BOSS_DIAMOND && pair.getSecond() != PoolLevel.BOSS_NETHERITE) continue;
                LootManager.DropEntityLoot((Entity)event.getEntityLiving(), player, (PoolLevel)((Object)pair.getSecond()));
            }
        }
    }

    public static void validateEntityDropList() {
        LootManager.validateDropList(Config.COMMON.copperEntityDrops);
        LootManager.validateDropList(Config.COMMON.ironEntityDrops);
        LootManager.validateDropList(Config.COMMON.goldEntityDrops);
        LootManager.validateDropList(Config.COMMON.emeraldEntityDrops);
        LootManager.validateDropList(Config.COMMON.diamondEntityDrops);
        LootManager.validateDropList(Config.COMMON.netheriteEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossCopperEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossIronEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossGoldEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossEmeraldEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossDiamondEntityDrops);
        LootManager.validateDropList(Config.COMMON.bossNetheriteEntityDrops);
    }

    private static void validateDropList(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
        List configList = (List)config.get();
        ArrayList list = Lists.newArrayList();
        configList.forEach(value -> list.add(value));
        boolean modified = false;
        for (int i = 0; i < list.size(); ++i) {
            String value2 = (String)list.get(i);
            if (value2.contains("entities/")) {
                value2 = value2.replace("entities/", "");
                list.set(i, value2);
                modified = true;
            }
            if (!value2.contains("entities\\")) continue;
            value2 = value2.replace("entities/", "");
            list.set(i, value2);
            modified = true;
        }
        if (modified) {
            config.set((Object)list);
        }
    }

    private static void DropEntityLoot(Entity entity, PlayerEntity player, PoolLevel coinPool) {
        if (!((Boolean)Config.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        LootTable table = LootTable.func_216119_b().func_216038_b();
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)entity.field_70170_p);
        if (player != null) {
            contextBuilder.func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216282_b, (Object)player);
        }
        LootContext context = contextBuilder.func_216022_a(new LootParameterSet.Builder().func_216271_b(LootParameters.field_216282_b).func_216271_b(LootParameters.field_216284_d).func_216270_a());
        if (coinPool == PoolLevel.BOSS_COPPER) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_COPPER) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_IRON) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_IRON) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_GOLD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_GOLD) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_EMERALD) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_EMERALD) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_DIAMOND) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_DIAMOND) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        if (coinPool == PoolLevel.BOSS_NETHERITE) {
            for (LootPool.Builder builder : ENTITY_LOOT_BOSS_NETHERITE) {
                table.addPool(builder.func_216044_b());
            }
            LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
            return;
        }
        table.addPool(ENTITY_LOOT_COPPER.func_216044_b());
        if (coinPool != PoolLevel.COPPER) {
            table.addPool(ENTITY_LOOT_IRON.func_216044_b());
            if (coinPool != PoolLevel.IRON) {
                table.addPool(ENTITY_LOOT_GOLD.func_216044_b());
                if (coinPool != PoolLevel.GOLD) {
                    table.addPool(ENTITY_LOOT_EMERALD.func_216044_b());
                    if (coinPool != PoolLevel.EMERALD) {
                        table.addPool(ENTITY_LOOT_DIAMOND.func_216044_b());
                        if (coinPool != PoolLevel.DIAMOND) {
                            table.addPool(ENTITY_LOOT_NETHERITE.func_216044_b());
                        }
                    }
                }
            }
        }
        LootManager.SpawnLootDrops(entity, table.func_216113_a(context));
    }

    private static void SpawnLootDrops(Entity entity, List<ItemStack> lootDrops) {
        for (ItemStack stack : lootDrops) {
            InventoryHelper.func_180173_a((World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ItemStack)stack);
        }
    }

    private static void AddChestPoolToTable(LootTable table, PoolLevel coinPool, String name) {
        if (!((Boolean)Config.COMMON.enableChestLoot.get()).booleanValue()) {
            return;
        }
        LightmansCurrency.LogDebug("Added " + (Object)((Object)coinPool) + " level chest loot to the " + name + " loot entry.");
        if (coinPool == PoolLevel.COPPER) {
            table.addPool(CHEST_LOOT_COPPER.func_216044_b());
        } else if (coinPool == PoolLevel.IRON) {
            table.addPool(CHEST_LOOT_IRON.func_216044_b());
        } else if (coinPool == PoolLevel.GOLD) {
            table.addPool(CHEST_LOOT_GOLD.func_216044_b());
        } else if (coinPool == PoolLevel.EMERALD) {
            table.addPool(CHEST_LOOT_EMERALD.func_216044_b());
        } else if (coinPool == PoolLevel.DIAMOND) {
            table.addPool(CHEST_LOOT_DIAMOND.func_216044_b());
        } else if (coinPool == PoolLevel.NETHERITE) {
            table.addPool(CHEST_LOOT_NETHERITE.func_216044_b());
        }
    }

    public static void AddEntityCoinPoolToTable(String resource, PoolLevel coinPool) {
        EXTERNAL_ENTITY_ENTRIES.add((Pair<String, PoolLevel>)new Pair((Object)resource, (Object)coinPool));
    }

    public static void AddChestCoinPoolToTable(String resource, PoolLevel coinPool) {
        EXTERNAL_CHEST_ENTRIES.add((Pair<String, PoolLevel>)new Pair((Object)resource, (Object)coinPool));
    }

    private static LootPool.Builder GenerateEntityCoinPool(Item item, float min, float max, float chance, String name, boolean requirePlayerKill) {
        LootPool.Builder lootPoolBuilder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))).name(name);
        if (requirePlayerKill) {
            lootPoolBuilder.func_212840_b_(KilledByPlayer.func_215994_b());
        }
        if (chance < 1.0f) {
            lootPoolBuilder.func_212840_b_(RandomChanceWithLooting.func_216003_a((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }

    private static LootPool.Builder GenerateChestCoinPool(ChestLootEntryData[] lootEntries, float minRolls, float maxRolls, String name) {
        LootPool.Builder lootPoolBuilder = LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)minRolls, (float)maxRolls)).name(name);
        for (ChestLootEntryData entry : lootEntries) {
            lootPoolBuilder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)entry.item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)entry.minCount, (float)entry.maxCount))).func_216086_a(entry.weight));
        }
        return lootPoolBuilder;
    }

    private static class ChestLootEntryData {
        public final Item item;
        public final float minCount;
        public final float maxCount;
        public final int weight;
        public static ChestLootEntryData COPPER = new ChestLootEntryData(ModItems.COIN_COPPER, 1.0f, 10.0f, 1);
        public static ChestLootEntryData IRON = new ChestLootEntryData(ModItems.COIN_IRON, 1.0f, 10.0f, 2);
        public static ChestLootEntryData GOLD = new ChestLootEntryData(ModItems.COIN_GOLD, 1.0f, 10.0f, 3);
        public static ChestLootEntryData EMERALD = new ChestLootEntryData(ModItems.COIN_EMERALD, 1.0f, 10.0f, 4);
        public static ChestLootEntryData DIAMOND = new ChestLootEntryData(ModItems.COIN_DIAMOND, 1.0f, 8.0f, 5);
        public static ChestLootEntryData NETHERITE = new ChestLootEntryData(ModItems.COIN_NETHERITE, 1.0f, 3.0f, 6);

        public ChestLootEntryData(Item item, float minCount, float maxCount, int weight) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.weight = weight;
        }
    }

    public static enum PoolLevel {
        COPPER(true),
        IRON(true),
        GOLD(true),
        EMERALD(true),
        DIAMOND(true),
        NETHERITE(true),
        BOSS_COPPER(false),
        BOSS_IRON(false),
        BOSS_GOLD(false),
        BOSS_EMERALD(false),
        BOSS_DIAMOND(false),
        BOSS_NETHERITE(false);

        private final boolean requiresPlayerKill;

        public final boolean requiresPlayerKill() {
            return this.requiresPlayerKill;
        }

        private PoolLevel(boolean requiresPlayerKill) {
            this.requiresPlayerKill = requiresPlayerKill;
        }
    }
}

