/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import io.github.lightman314.lightmanscurrency.containers.ATMContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemEditContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderStorageContainer;
import io.github.lightman314.lightmanscurrency.containers.MintContainer;
import io.github.lightman314.lightmanscurrency.containers.PaygateContainer;
import io.github.lightman314.lightmanscurrency.containers.TicketMachineContainer;
import io.github.lightman314.lightmanscurrency.containers.WalletContainer;
import io.github.lightman314.lightmanscurrency.tileentity.CashRegisterTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.CoinMintTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.PaygateTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TicketMachineTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContainers {
    private static final List<ContainerType<?>> CONTAINER_TYPES = new ArrayList();
    public static final ContainerType<ATMContainer> ATM = ModContainers.register("atm", ATMContainer::new);
    public static final ContainerType<MintContainer> MINT = ModContainers.register("coinmint", (windowId, playerInventory, data) -> {
        CoinMintTileEntity tileEntity = (CoinMintTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new MintContainer(windowId, playerInventory, tileEntity);
    });
    public static final ContainerType<ItemTraderContainer> ITEM_TRADER = ModContainers.register("item_trader", (windowId, playerInventory, data) -> new ItemTraderContainer(windowId, playerInventory, data.func_179259_c()));
    public static final ContainerType<ItemTraderContainer.ItemTraderContainerCR> ITEM_TRADER_CR = ModContainers.register("item_trader_cr", (windowId, playerInventory, data) -> {
        BlockPos traderPos = data.func_179259_c();
        CashRegisterTileEntity registerEntity = (CashRegisterTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new ItemTraderContainer.ItemTraderContainerCR(windowId, playerInventory, traderPos, registerEntity);
    });
    public static final ContainerType<ItemTraderContainer.ItemTraderContainerUniversal> ITEM_TRADER_UNIVERSAL = ModContainers.register("universal_item_trader", (windowId, playerInventory, data) -> new ItemTraderContainer.ItemTraderContainerUniversal(windowId, playerInventory, data.func_179253_g()));
    public static final ContainerType<ItemTraderStorageContainer> ITEM_TRADER_STORAGE = ModContainers.register("item_trader_storage", (windowId, playerInventory, data) -> new ItemTraderStorageContainer(windowId, playerInventory, data.func_179259_c()));
    public static final ContainerType<ItemTraderStorageContainer.ItemTraderStorageContainerUniversal> ITEM_TRADER_STORAGE_UNIVERSAL = ModContainers.register("universal_item_trader_storage", (windowId, playerInventory, data) -> new ItemTraderStorageContainer.ItemTraderStorageContainerUniversal(windowId, playerInventory, data.func_179253_g()));
    public static final ContainerType<WalletContainer> WALLET = ModContainers.register("wallet", (windowId, playerInventory, data) -> new WalletContainer(windowId, playerInventory, data.readInt()));
    public static final ContainerType<PaygateContainer> PAYGATE = ModContainers.register("paygate", (windowId, playerInventory, data) -> {
        PaygateTileEntity tileEntity = (PaygateTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new PaygateContainer(windowId, playerInventory, tileEntity);
    });
    public static final ContainerType<TicketMachineContainer> TICKET_MACHINE = ModContainers.register("ticket_machine", (windowId, playerInventory, data) -> {
        TicketMachineTileEntity tileEntity = (TicketMachineTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new TicketMachineContainer(windowId, playerInventory, tileEntity);
    });
    public static final ContainerType<ItemEditContainer> ITEM_EDIT = ModContainers.register("item_edit", (windowId, playerInventory, data) -> new ItemEditContainer(windowId, playerInventory, data.func_179259_c(), data.readInt()));
    public static final ContainerType<ItemEditContainer.UniversalItemEditContainer> UNIVERSAL_ITEM_EDIT = ModContainers.register("universal_item_edit", (windowId, playerInventory, data) -> new ItemEditContainer.UniversalItemEditContainer(windowId, playerInventory, data.func_179253_g(), data.readInt()));

    private static <T extends Container> ContainerType<T> register(String key, ContainerType.IFactory<T> factory) {
        ContainerType type = new ContainerType(factory);
        type.setRegistryName(key);
        CONTAINER_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        CONTAINER_TYPES.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
        CONTAINER_TYPES.clear();
    }
}

