/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.IItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.entity.merchant.villager.CustomProfessions;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod.EventBusSubscriber
public class VillagerTradeManager {
    private static final List<VillagerTrades.ITrade> GENERIC_TRADES_WANDERER = ImmutableList.of((Object)((Object)new LazyTrade((IItemProvider)ModItems.COIN_GOLD, 1, (IItemProvider)ModBlocks.MACHINE_ATM.item)), (Object)((Object)new LazyTrade((IItemProvider)ModItems.COIN_IRON, 5, (IItemProvider)ModBlocks.CASH_REGISTER.item)), (Object)((Object)new LazyTrade((IItemProvider)ModItems.COIN_IRON, 5, (IItemProvider)ModBlocks.TERMINAL.item)));
    private static final List<VillagerTrades.ITrade> RARE_TRADES_WANDERER = ImmutableList.of((Object)((Object)new LazyTrade((IItemProvider)ModItems.COIN_GOLD, 2, (IItemProvider)ModItems.COIN_IRON, 4, ModBlocks.DISPLAY_CASE)), (Object)((Object)new LazyTrade((IItemProvider)ModItems.COIN_GOLD, 4, (IItemProvider)ModBlocks.ARMOR_DISPLAY.item)));
    private static final Map<Integer, List<VillagerTrades.ITrade>> TRADES_BANKER = ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)((Object)new LazyTrade(2, (IItemProvider)ModItems.COIN_IRON, 5, ModBlocks.MACHINE_MINT)), (Object)((Object)new LazyTrade(2, (IItemProvider)ModItems.COIN_GOLD, 1, ModBlocks.MACHINE_ATM)), (Object)((Object)new LazyTrade(1, (IItemProvider)ModItems.COIN_IRON, 5, ModBlocks.CASH_REGISTER)), (Object)((Object)new LazyTrade(1, (IItemProvider)ModItems.COIN_IRON, 4, (IItemProvider)ModItems.COIN_COPPER, 8, (IItemProvider)ModItems.TRADING_CORE))), (Object)2, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new IItemProvider[]{ModBlocks.SHELF.get(Reference.WoodType.OAK), ModBlocks.SHELF.get(Reference.WoodType.BIRCH), ModBlocks.SHELF.get(Reference.WoodType.SPRUCE), ModBlocks.SHELF.get(Reference.WoodType.JUNGLE)}, 12, 5, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new IItemProvider[]{ModBlocks.SHELF.get(Reference.WoodType.ACACIA), ModBlocks.SHELF.get(Reference.WoodType.DARK_OAK), ModBlocks.SHELF.get(Reference.WoodType.WARPED), ModBlocks.SHELF.get(Reference.WoodType.CRIMSON)}, 12, 5, 0.05f), (Object)((Object)new LazyTrade(5, (IItemProvider)ModItems.COIN_IRON, 10, ModBlocks.DISPLAY_CASE))), (Object)3, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 15), new IItemProvider[]{ModBlocks.CARD_DISPLAY.get(Reference.WoodType.OAK), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.BIRCH), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.SPRUCE), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.JUNGLE)}, 12, 10, 0.05f), (Object)new RandomItemForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 15), new IItemProvider[]{ModBlocks.CARD_DISPLAY.get(Reference.WoodType.ACACIA), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.DARK_OAK), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.CRIMSON), ModBlocks.CARD_DISPLAY.get(Reference.WoodType.WARPED)}, 12, 10, 0.05f), (Object)((Object)new LazyTrade(10, (IItemProvider)ModItems.COIN_IRON, 20, ModBlocks.ARMOR_DISPLAY)), (Object)((Object)new LazyTrade(10, (IItemProvider)ModItems.COIN_IRON, 15, ModBlocks.ITEM_TRADER_SERVER_SMALL)), (Object)((Object)new LazyTrade(10, (IItemProvider)ModItems.COIN_IRON, 10, ModBlocks.TERMINAL))), (Object)4, (Object)ImmutableList.of((Object)new RandomItemSetForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 25), ModBlocks.VENDING_MACHINE1, 12, 15, 0.05f), (Object)((Object)new LazyTrade(15, (IItemProvider)ModItems.COIN_IRON, 30, ModBlocks.ITEM_TRADER_SERVER_MEDIUM)), (Object)((Object)new LazyTrade(20, (IItemProvider)ModItems.COIN_IRON, 30, ModBlocks.FREEZER))), (Object)5, (Object)ImmutableList.of((Object)new RandomItemSetForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 25), ModBlocks.VENDING_MACHINE2, 12, 30, 0.05f), (Object)((Object)new LazyTrade(30, (IItemProvider)ModItems.COIN_GOLD, 6, ModBlocks.ITEM_TRADER_SERVER_LARGE)), (Object)((Object)new LazyTrade(30, (IItemProvider)ModItems.COIN_GOLD, 10, ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE))));
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;
    private static final Map<Integer, List<VillagerTrades.ITrade>> TRADES_CASHIER = ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 4), new ItemStack((IItemProvider)ModItems.COIN_COPPER, 5), new ItemStack((IItemProvider)Items.field_151025_P, 6), 16, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 7), new ItemStack((IItemProvider)Items.field_203797_aN), 16, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 4), new ItemStack((IItemProvider)Items.field_151097_aZ), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 8), new ItemStack((IItemProvider)Items.field_151032_g, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 2), new ItemStack((IItemProvider)Blocks.field_150342_X), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD), new ItemStack((IItemProvider)ModItems.COIN_IRON, 5), new ItemStack((IItemProvider)Items.field_151148_bJ), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON), new ItemStack((IItemProvider)Items.field_151137_ax), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new ItemStack((IItemProvider)Items.field_151165_aa), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_151167_ab), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)ModItems.COIN_IRON, 3), new ItemStack((IItemProvider)Items.field_151028_Y), 12, 1, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 2), new ItemStack((IItemProvider)Items.field_151030_Z), 12, 1, 0.05f), (Object[])new VillagerTrades.ITrade[]{new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new ItemStack((IItemProvider)Items.field_151036_c), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 3, (IItemProvider)Items.field_151040_l, 12, 1, 0.05f, 0.25), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON), new ItemStack((IItemProvider)Items.field_151049_t), 12, 1, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON), new ItemStack((IItemProvider)Items.field_151051_r), 12, 1, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON), new ItemStack((IItemProvider)Items.field_151050_s), 12, 1, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON), new ItemStack((IItemProvider)Items.field_151018_J), 12, 1, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Items.field_179560_bq), 12, 1, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Items.field_151118_aC, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_151158_bO, 4), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new ItemStack((IItemProvider)Items.field_151034_e, 4), 16, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 3), new ItemStack((IItemProvider)Items.field_196086_aW, 15), 16, 10, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_222433_lV), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_196556_aL), 16, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 4), new ItemStack((IItemProvider)Items.field_151031_f), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_222432_lU), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 3), Structure.field_236376_l_, MapDecoration.Type.MONUMENT, 12, 5), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Items.field_196128_bn), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 4), new ItemStack((IItemProvider)Blocks.field_222431_lT), 12, 5, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 9), new ItemStack((IItemProvider)ModItems.COIN_COPPER, 5), new ItemStack((IItemProvider)Items.field_151022_W), 12, 5, 0.05f), (Object[])new VillagerTrades.ITrade[]{new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new ItemStack((IItemProvider)ModItems.COIN_COPPER, 3), new ItemStack((IItemProvider)Items.field_151029_X), 12, 5, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 3), new ItemStack((IItemProvider)Items.field_151147_al, 6), 16, 5, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 3), new ItemStack((IItemProvider)Items.field_151077_bg, 8), 16, 5, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_196702_dl, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_151106_aX, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 2, (IItemProvider)Items.field_151112_aM, 3, 10, 0.05f, 0.25), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 7), new ItemStack((IItemProvider)Items.field_222114_py), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 3), new ItemStack((IItemProvider)Blocks.field_150359_w, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 4), Structure.field_236368_d_, MapDecoration.Type.MANSION, 12, 10), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD), new ItemStack((IItemProvider)Blocks.field_150426_aN), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 7), new ItemStack((IItemProvider)ModItems.COIN_COPPER, 4), new ItemStack((IItemProvider)Items.field_151020_U), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 10), new ItemStack((IItemProvider)ModItems.COIN_COPPER, 5), new ItemStack((IItemProvider)Items.field_151023_V), 12, 10, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 6), new ItemStack((IItemProvider)Items.field_185159_cQ), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 5, (IItemProvider)Items.field_151036_c, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 4, (IItemProvider)Items.field_151037_a, 3, 12, 0.05f, 0.25), (Object[])new VillagerTrades.ITrade[]{new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 6, (IItemProvider)Items.field_151035_b, 3, 12, 0.05f, 0.25), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_DIAMOND, 2), new ItemStack((IItemProvider)ModItems.COIN_IRON, 1), new ItemStack((IItemProvider)Items.field_151012_L), 3, 10, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_196657_h, 4), 16, 10, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_196655_f, 4), 16, 10, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_196652_d, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 2), new ItemStack((IItemProvider)Blocks.field_150414_aQ), 12, 15, 0.05f), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76439_r, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76430_j, 160, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76437_t, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76440_q, 120, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76436_u, 100, 15), (Object)new SuspiciousStewForItemTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), Effects.field_76443_y, 7, 15), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 5, (IItemProvider)Items.field_151031_f, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 5), new ItemStack((IItemProvider)Items.field_151113_aN), 12, 15, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 2), new ItemStack((IItemProvider)Items.field_151111_aL), 12, 15, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD), new ItemStack((IItemProvider)Items.field_151160_bD), 12, 15, 0.05f), (Object[])new VillagerTrades.ITrade[]{new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD), new ItemStack((IItemProvider)Items.field_151079_bi), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 7, (IItemProvider)Items.field_151173_ae, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 5, (IItemProvider)Items.field_151175_af, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 4, (IItemProvider)Items.field_151056_x, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 3, (IItemProvider)Items.field_151056_x, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 2, (IItemProvider)Items.field_151047_v, 3, 15, 0.05f, 0.25), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_150405_ch, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 15), new ItemStack((IItemProvider)Items.field_151150_bK), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 2), new ItemStack((IItemProvider)Items.field_151060_bw), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 5), new ItemStack((IItemProvider)Items.field_151159_an), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_IRON, 10, (IItemProvider)Items.field_222114_py, 3, 15, 0.05f, 0.25), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_151057_cb), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_222099_pF), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_EMERALD, 1), new ItemStack((IItemProvider)Blocks.field_150388_bm, 12), 12, 30, 0.05f), (Object)new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 5), new ItemStack((IItemProvider)Items.field_151062_by), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 8, (IItemProvider)Items.field_151163_ad, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 6, (IItemProvider)Items.field_151161_ac, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 4, (IItemProvider)Items.field_151048_u, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((IItemProvider)ModItems.COIN_DIAMOND, 4, (IItemProvider)Items.field_151046_w, 3, 30, 0.05f, 0.25), (Object[])new VillagerTrades.ITrade[]{new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_GOLD, 1), new ItemStack((IItemProvider)Items.field_151141_av), 12, 30, 0.05f), new BasicTrade(new ItemStack((IItemProvider)ModItems.COIN_IRON, 2), new ItemStack((IItemProvider)Blocks.field_150371_ca), 12, 30, 0.05f)}));

    @SubscribeEvent
    public static void OnVillagerTradeSetup(VillagerTradesEvent event) {
        block3: {
            block2: {
                if (event.getType() != CustomProfessions.BANKER || !((Boolean)Config.COMMON.addBankerVillager.get()).booleanValue()) break block2;
                LightmansCurrency.LogInfo("Registering banker trades.");
                for (int i = 1; i <= 5; ++i) {
                    List currentTrades = (List)event.getTrades().get(i);
                    List<VillagerTrades.ITrade> newTrades = TRADES_BANKER.get(i);
                    newTrades.forEach(trade -> currentTrades.add(trade));
                }
                break block3;
            }
            if (event.getType() != CustomProfessions.CASHIER || !((Boolean)Config.COMMON.addCashierVillager.get()).booleanValue()) break block3;
            LightmansCurrency.LogInfo("Registering cashier trades.");
            for (int i = 1; i <= 5; ++i) {
                List currentTrades = (List)event.getTrades().get(i);
                List<VillagerTrades.ITrade> newTrades = TRADES_CASHIER.get(i);
                newTrades.forEach(trade -> currentTrades.add(trade));
            }
        }
    }

    @SubscribeEvent
    public static void OnWandererTradeSetup(WandererTradesEvent event) {
        if (!((Boolean)Config.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            return;
        }
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        GENERIC_TRADES_WANDERER.forEach(trade -> genericTrades.add(trade));
        RARE_TRADES_WANDERER.forEach(trade -> rareTrades.add(trade));
    }

    public static class RandomItemForItemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack price1;
        private final ItemStack price2;
        private final IItemProvider[] sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemForItemTrade(ItemStack price, IItemProvider[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, ItemStack.field_190927_a, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(ItemStack price1, ItemStack price2, IItemProvider[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int index = rand.nextInt(this.sellItemOptions.length);
            ItemStack sellItem = new ItemStack(this.sellItemOptions[index]);
            return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    public static class RandomItemSetForItemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack price1;
        private final ItemStack price2;
        private final IItemSet<?> sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemSetForItemTrade(ItemStack price, IItemSet<?> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, ItemStack.field_190927_a, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemSetForItemTrade(ItemStack price1, ItemStack price2, IItemSet<?> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            List<Item> items = this.sellItemOptions.getAllItems();
            int index = rand.nextInt(items.size());
            ItemStack sellItem = new ItemStack((IItemProvider)items.get(index));
            return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    private static class ItemsForMapTrade
    implements VillagerTrades.ITrade {
        private final ItemStack price1;
        private final ItemStack price2;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public ItemsForMapTrade(ItemStack price, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this(price, ItemStack.field_190927_a, structureName, mapDecorationType, maxUses, xpValue);
        }

        public ItemsForMapTrade(ItemStack price1, ItemStack price2, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockPos = serverworld.func_241117_a_(this.structureName, trader.func_233580_cy_(), 100, true);
            if (blockPos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockPos.func_177958_n(), (int)blockPos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(this.price1, this.price2, itemstack, this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    private static class EnchantedBookForCoinsTrade
    implements VillagerTrades.ITrade {
        private static final Item baseCoin = ModItems.COIN_GOLD;
        private static final int baseCoinAmount = 5;
        private final int xpValue;

        public EnchantedBookForCoinsTrade(int xpValue) {
            this.xpValue = xpValue;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            List list = GameRegistry.findRegistry(Enchantment.class).getValues().stream().filter(Enchantment::func_230309_h_).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
            int level = 1;
            if (enchantment.func_77325_b() > 0) {
                level = MathHelper.func_76136_a((Random)rand, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            } else {
                LightmansCurrency.LogError("Enchantment of type '" + enchantment.getRegistryName().toString() + "' has a max enchantment level of " + enchantment.func_77325_b() + ". Unable to properly randomize the enchantment level for a villager trade. Will default to a level 1 enchantment.");
            }
            ItemStack itemstack = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, level));
            long coinValue = MoneyUtil.getValue(baseCoin);
            long baseValue = coinValue * 5L;
            int valueRandom = rand.nextInt(5 + level * 10);
            long value = baseValue + coinValue * (long)(level + valueRandom);
            if (enchantment.func_185261_e()) {
                value *= 2L;
            }
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(value);
            ItemStack price1 = ItemStack.field_190927_a;
            ItemStack price2 = ItemStack.field_190927_a;
            if (coins.size() > 0) {
                price1 = coins.get(0);
            }
            if (coins.size() > 1) {
                price2 = coins.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedBookForCoinsTrade.getOffer() -> \nbaseValue=" + baseValue + "\ncoinValue=" + coinValue + "\nlevel=" + level + "\nvalueRandom=" + valueRandom + "\nvalue=" + value + "\nprice1=" + price1.func_190916_E() + "x" + price1.func_77973_b().getRegistryName() + "\nprice2=" + price2.func_190916_E() + "x" + price2.func_77973_b().getRegistryName());
            return new MerchantOffer(price1, price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    private static class EnchantedItemForCoinsTrade
    implements VillagerTrades.ITrade {
        private final Item baseCoin;
        private final int baseCoinCount;
        private final Item sellItem;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;
        private final double basePriceModifier;

        private EnchantedItemForCoinsTrade(IItemProvider baseCoin, int baseCoinCount, IItemProvider sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
            this.baseCoin = baseCoin.func_199767_j();
            this.baseCoinCount = baseCoinCount;
            this.sellItem = sellItem.func_199767_j();
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
            this.basePriceModifier = basePriceModifier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int i = 5 + rand.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)this.sellItem), (int)i, (boolean)false);
            long coinValue = MoneyUtil.getValue(this.baseCoin);
            long baseValue = coinValue * (long)this.baseCoinCount;
            long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
            ItemStack price1 = ItemStack.field_190927_a;
            ItemStack price2 = ItemStack.field_190927_a;
            List<ItemStack> priceStacks = MoneyUtil.getCoinsOfValue(priceValue);
            if (priceStacks.size() > 0) {
                price1 = priceStacks.get(0);
            }
            if (priceStacks.size() > 1) {
                price2 = priceStacks.get(1);
            }
            LightmansCurrency.LogInfo("EnchantedItemForCoinsTrade.getOffer() -> \ni=" + i + "\ncoinValue=" + coinValue + "\nbaseValue=" + baseValue + "\npriceValue=" + priceValue + "\nprice1=" + price1.func_190916_E() + "x" + price1.func_77973_b().getRegistryName() + "\nprice2=" + price2.func_190916_E() + "x" + price2.func_77973_b().getRegistryName());
            return new MerchantOffer(price1, price2, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class SuspiciousStewForItemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack price1;
        private final ItemStack price2;
        private final Effect effect;
        private final int duration;
        private final int xpValue;

        private SuspiciousStewForItemTrade(ItemStack price, Effect effect, int duration, int xpValue) {
            this(price, ItemStack.field_190927_a, effect, duration, xpValue);
        }

        private SuspiciousStewForItemTrade(ItemStack price1, ItemStack price2, Effect effect, int duration, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.effect = effect;
            this.duration = duration;
            this.xpValue = xpValue;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_222115_pz, 1);
            SuspiciousStewItem.func_220037_a((ItemStack)itemstack, (Effect)this.effect, (int)this.duration);
            return new MerchantOffer(this.price1, this.price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    public static class SetTrade
    extends BasicTrade {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public SetTrade(IItemProvider priceItem, int priceCount, IItemProvider forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public SetTrade(IItemProvider priceItem, int priceCount, IItemProvider forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, IItemProvider priceItem, int priceCount, IItemProvider forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public SetTrade(int xpValue, IItemProvider priceItem, int priceCount, IItemProvider forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public SetTrade(IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public SetTrade(IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public SetTrade(int xpValue, IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public SetTrade(int xpValue, IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }
    }

    public static class LazyTrade
    extends BasicTrade {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;

        public LazyTrade(IItemProvider priceItem, int priceCount, IItemProvider forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public LazyTrade(IItemProvider priceItem, int priceCount, IItemProvider forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, IItemProvider priceItem, int priceCount, IItemProvider forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, IItemProvider priceItem, int priceCount, IItemProvider forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem, priceCount), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public LazyTrade(IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, IItemProvider priceItem1, int priceCount1, IItemProvider priceItem2, int priceCount2, IItemProvider forsaleItem, int forsaleCount) {
            super(new ItemStack(priceItem1, priceCount1), new ItemStack(priceItem2, priceCount2), new ItemStack(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }
    }
}

