/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting;

import com.google.gson.JsonElement;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.crafting.RecipeType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CoinMintRecipe
implements IRecipe<IInventory> {
    private ResourceLocation id;
    private MintType type;
    private Ingredient ingredient;
    private Item result;

    public static MintType readType(JsonElement json) {
        try {
            return CoinMintRecipe.readType(json.getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return MintType.OTHER;
        }
    }

    public static MintType readType(String typeName) {
        for (MintType type : MintType.values()) {
            if (!type.name().equals(typeName)) continue;
            return type;
        }
        return MintType.OTHER;
    }

    public CoinMintRecipe(ResourceLocation id, MintType type, Ingredient ingredient, IItemProvider result) {
        this.id = id;
        this.type = type;
        this.ingredient = ingredient;
        this.result = result.func_199767_j();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        if (this.isValid()) {
            return new ItemStack((IItemProvider)this.result);
        }
        return ItemStack.field_190927_a;
    }

    public MintType getMintType() {
        return this.type;
    }

    public boolean allowed() {
        if (this.type == MintType.MINT) {
            return (Boolean)Config.SERVER.allowCoinMinting.get() != false && Config.canMint(this.result);
        }
        if (this.type == MintType.MELT) {
            try {
                return (Boolean)Config.SERVER.allowCoinMelting.get() != false && Config.canMelt(this.ingredient.func_193365_a()[0].func_77973_b());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return !this.ingredient.func_203189_d() && this.result.func_199767_j() != Items.field_190931_a && this.allowed();
    }

    public boolean func_77569_a(IInventory inventory, World worldIn) {
        if (!this.isValid()) {
            return false;
        }
        ItemStack firstStack = inventory.func_70301_a(0);
        return this.ingredient.test(firstStack);
    }

    public ItemStack func_77572_b(IInventory inventory) {
        return this.getResult();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.getResult();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.COIN_MINT;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeType.COIN_MINT;
    }

    public static enum MintType {
        MINT,
        MELT,
        OTHER;

    }
}

