/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CoinMintRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<CoinMintRecipe> {
    public CoinMintRecipe read(ResourceLocation recipeId, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an item.");
        }
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("ingredient"));
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result. Expected to find an item.");
        }
        ItemStack result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("result").getAsString())));
        if (result.func_190926_b()) {
            throw new JsonSyntaxException("Result is empty.");
        }
        CoinMintRecipe.MintType type = CoinMintRecipe.MintType.OTHER;
        if (json.has("mintType")) {
            type = CoinMintRecipe.readType(json.get("mintType"));
        }
        return new CoinMintRecipe(recipeId, type, ingredient, (IItemProvider)result.func_77973_b());
    }

    public CoinMintRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        CoinMintRecipe.MintType type = CoinMintRecipe.readType(buffer.func_150789_c(16));
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack result = buffer.func_150791_c();
        return new CoinMintRecipe(recipeId, type, ingredient, (IItemProvider)result.func_77973_b());
    }

    public void write(PacketBuffer buffer, CoinMintRecipe recipe) {
        buffer.func_211400_a(recipe.getMintType().name(), 16);
        recipe.getIngredient().func_199564_a(buffer);
        buffer.func_150788_a(recipe.getResult());
    }
}

