/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.crafting.RecipeType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;

public class RecipeValidator {
    public static Results getValidRecipes(World world) {
        Results results = new Results();
        RecipeManager recipeManager = world.func_199532_z();
        for (IRecipe<?> recipe : RecipeValidator.getRecipes(recipeManager, RecipeType.COIN_MINT)) {
            CoinMintRecipe mintRecipe;
            if (!(recipe instanceof CoinMintRecipe) || !(mintRecipe = (CoinMintRecipe)recipe).isValid()) continue;
            results.coinMintRecipes.add(mintRecipe);
        }
        return results;
    }

    private static Collection<IRecipe<?>> getRecipes(RecipeManager recipeManager, IRecipeType<?> recipeType) {
        return recipeManager.func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == recipeType).collect(Collectors.toSet());
    }

    public static class Results {
        private final List<CoinMintRecipe> coinMintRecipes = Lists.newArrayList();

        public List<CoinMintRecipe> getCoinMintRecipes() {
            return this.coinMintRecipes;
        }
    }
}

