/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting.deprecated;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class OldWalletUpgradeRecipe
extends SpecialRecipe {
    private static final List<UpgradeData> UPGRADE_DATA = Lists.newArrayList((Object[])new UpgradeData[]{new UpgradeData(ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.COIN_IRON), new UpgradeData(ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.COIN_GOLD, Items.field_151137_ax), new UpgradeData(ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.COIN_EMERALD, Items.field_151079_bi), new UpgradeData(ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.COIN_DIAMOND), new UpgradeData(ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE, ModItems.COIN_NETHERITE)});

    public OldWalletUpgradeRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack wallet = null;
        ArrayList upgradeItems = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack thisItem = inv.func_70301_a(i);
            if (thisItem.func_190926_b()) continue;
            if (thisItem.func_77973_b() instanceof WalletItem) {
                if (wallet == null) {
                    wallet = thisItem;
                    continue;
                }
                return false;
            }
            upgradeItems.add(thisItem);
        }
        UpgradeData data = OldWalletUpgradeRecipe.getUpgradeData(wallet, upgradeItems);
        return data != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack wallet = null;
        ArrayList upgradeItems = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack thisItem = inv.func_70301_a(i);
            if (thisItem.func_190926_b()) continue;
            if (thisItem.func_77973_b() instanceof WalletItem) {
                if (wallet == null) {
                    wallet = thisItem;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            upgradeItems.add(thisItem);
        }
        UpgradeData data = OldWalletUpgradeRecipe.getUpgradeData(wallet, upgradeItems);
        if (data != null) {
            ItemStack walletOut = new ItemStack((IItemProvider)data.walletOut);
            WalletItem.CopyWalletContents(wallet, walletOut);
            return walletOut;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    private static UpgradeData getUpgradeData(ItemStack wallet, List<ItemStack> upgradeItems) {
        for (int i = 0; i < UPGRADE_DATA.size(); ++i) {
            if (!UPGRADE_DATA.get(i).matches(wallet, upgradeItems)) continue;
            return UPGRADE_DATA.get(i);
        }
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.WALLET_UPGRADE;
    }

    public static void addUpgradeData(WalletItem walletIn, WalletItem walletOut, Item ... upgradeItems) {
        UPGRADE_DATA.add(new UpgradeData(walletIn, walletOut, upgradeItems));
    }

    private static class UpgradeData {
        private final WalletItem walletIn;
        public final WalletItem walletOut;
        private final List<Item> upgradeItems;

        public UpgradeData(WalletItem walletIn, WalletItem walletOut, Item ... upgradeItems) {
            this.walletIn = walletIn;
            this.walletOut = walletOut;
            this.upgradeItems = Lists.newArrayList((Object[])upgradeItems);
        }

        public boolean matches(ItemStack walletIn, List<ItemStack> upgradeItems) {
            if (walletIn == null || upgradeItems == null) {
                return false;
            }
            if (this.walletIn == walletIn.func_77973_b() && this.upgradeItems.size() == upgradeItems.size()) {
                for (int i = 0; i < this.upgradeItems.size(); ++i) {
                    Item thisItem = this.upgradeItems.get(i);
                    boolean foundMatch = false;
                    for (int z = 0; z < upgradeItems.size() && !foundMatch; ++z) {
                        if (upgradeItems.get(z).func_77973_b() != thisItem) continue;
                        upgradeItems.remove(z);
                        foundMatch = true;
                    }
                    if (foundMatch) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

