/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CoinMintRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final CoinMintRecipe.MintType type;
    private final Ingredient ingredient;
    private final Item result;

    public CoinMintRecipeBuilder(IRecipeSerializer<?> serializer, CoinMintRecipe.MintType type, Ingredient ingredient, IItemProvider result) {
        this.serializer = serializer;
        this.type = type;
        this.ingredient = ingredient;
        this.result = result.func_199767_j();
    }

    public static CoinMintRecipeBuilder minting(Ingredient ingredient, IItemProvider result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.MINT, ingredient, result);
    }

    public static CoinMintRecipeBuilder melting(Ingredient ingredient, IItemProvider result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.MELT, ingredient, result);
    }

    public static CoinMintRecipeBuilder other(Ingredient ingredient, IItemProvider result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.OTHER, ingredient, result);
    }

    public void save(Consumer<IFinishedRecipe> consumer, String name) {
        this.save(consumer, new ResourceLocation(name));
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.serializer, this.type, this.ingredient, this.result));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final IRecipeSerializer<?> serializer;
        private final CoinMintRecipe.MintType type;
        private final Ingredient ingredient;
        private final Item result;

        private Result(ResourceLocation id, IRecipeSerializer<?> serializer, CoinMintRecipe.MintType type, Ingredient ingredient, Item result) {
            this.id = id;
            this.serializer = serializer;
            this.type = type;
            this.ingredient = ingredient;
            this.result = result;
        }

        public void func_218610_a(JsonObject object) {
            object.addProperty("mintType", this.type.name());
            object.add("ingredient", this.ingredient.func_200304_c());
            object.addProperty("result", this.result.getRegistryName().toString());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

