/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.datagen.CoinMintRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.WalletUpgradeRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RecipeGen
extends RecipeProvider {
    private static final String UPGRADE_GROUP = "wallet_upgrades";

    public RecipeGen(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        RecipeGen.mint(consumer, (IItemProvider)Items.field_151042_j, (IItemProvider)ModItems.COIN_IRON);
        RecipeGen.melt(consumer, (IItemProvider)Items.field_151042_j, (IItemProvider)ModItems.COIN_IRON);
        RecipeGen.mint(consumer, (IItemProvider)Items.field_151043_k, (IItemProvider)ModItems.COIN_GOLD);
        RecipeGen.melt(consumer, (IItemProvider)Items.field_151043_k, (IItemProvider)ModItems.COIN_GOLD);
        RecipeGen.mint(consumer, (IItemProvider)Items.field_151166_bC, (IItemProvider)ModItems.COIN_EMERALD);
        RecipeGen.melt(consumer, (IItemProvider)Items.field_151166_bC, (IItemProvider)ModItems.COIN_EMERALD);
        RecipeGen.mint(consumer, (IItemProvider)Items.field_151045_i, (IItemProvider)ModItems.COIN_DIAMOND);
        RecipeGen.melt(consumer, (IItemProvider)Items.field_151045_i, (IItemProvider)ModItems.COIN_DIAMOND);
        RecipeGen.mint(consumer, (IItemProvider)Items.field_234759_km_, (IItemProvider)ModItems.COIN_NETHERITE);
        RecipeGen.melt(consumer, (IItemProvider)Items.field_234759_km_, (IItemProvider)ModItems.COIN_NETHERITE);
        RecipeGen.upgrade(consumer, (IItemProvider)ModItems.WALLET_COPPER, (IItemProvider)ModItems.WALLET_IRON, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.COIN_IRON}));
        RecipeGen.upgrade(consumer, (IItemProvider)ModItems.WALLET_IRON, (IItemProvider)ModItems.WALLET_GOLD, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.COIN_GOLD}));
        RecipeGen.upgrade(consumer, (IItemProvider)ModItems.WALLET_GOLD, (IItemProvider)ModItems.WALLET_EMERALD, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.COIN_EMERALD}));
        RecipeGen.upgrade(consumer, (IItemProvider)ModItems.WALLET_EMERALD, (IItemProvider)ModItems.WALLET_DIAMOND, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.COIN_DIAMOND}));
        RecipeGen.upgrade(consumer, (IItemProvider)ModItems.WALLET_DIAMOND, (IItemProvider)ModItems.WALLET_NETHERITE, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.COIN_NETHERITE}));
    }

    private static void mint(Consumer<IFinishedRecipe> consumer, IItemProvider material, IItemProvider coin) {
        CoinMintRecipeBuilder.minting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{material}), coin).save(consumer, RecipeGen.recipeId(CoinMintRecipe.MintType.MINT, coin));
    }

    private static void melt(Consumer<IFinishedRecipe> consumer, IItemProvider material, IItemProvider coin) {
        CoinMintRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{coin}), material).save(consumer, RecipeGen.recipeId(CoinMintRecipe.MintType.MELT, coin));
    }

    private static void upgrade(Consumer<IFinishedRecipe> consumer, IItemProvider walletIn, IItemProvider walletOut, Ingredient ... materials) {
        WalletUpgradeRecipeBuilder.walletUpgrade(walletIn, walletOut, UPGRADE_GROUP, materials).save(consumer, RecipeGen.upgradeId(walletOut));
    }

    protected static ResourceLocation recipeId(CoinMintRecipe.MintType type, IItemProvider coin) {
        String prefix = "coinmint_";
        if (type == CoinMintRecipe.MintType.MINT) {
            prefix = "mint_";
        } else if (type == CoinMintRecipe.MintType.MELT) {
            prefix = "melt_";
        }
        return RecipeGen.recipeId(prefix, coin);
    }

    protected static ResourceLocation recipeId(String prefix, IItemProvider coin) {
        ResourceLocation coinItemID = coin.func_199767_j().getRegistryName();
        return new ResourceLocation(coinItemID.func_110624_b(), prefix + coinItemID.func_110623_a());
    }

    protected static ResourceLocation upgradeId(IItemProvider wallet) {
        ResourceLocation walletItemID = wallet.func_199767_j().getRegistryName();
        return new ResourceLocation(walletItemID.func_110624_b(), "upgraded_" + walletItemID.func_110623_a());
    }
}

