/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.discord.listeners;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmansconsole.LightmansDiscordIntegration;
import io.github.lightman314.lightmansconsole.discord.links.AccountManager;
import io.github.lightman314.lightmansconsole.discord.links.LinkedAccount;
import io.github.lightman314.lightmansconsole.discord.listeners.types.SingleChannelListener;
import io.github.lightman314.lightmansconsole.message.MessageManager;
import io.github.lightman314.lightmansconsole.util.MessageUtil;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordPostTradeEvent;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordTraderSearchEvent;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.priv.PrivateMessageReceivedEvent;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class CurrencyListener
extends SingleChannelListener {
    private final Timer timer;
    private static final long PENDING_MESSAGE_TIMER = 300000L;
    private static final long ANNOUCEMENT_DELAY = 60000L;
    Map<String, List<String>> pendingMessages = new HashMap<String, List<String>>();

    public CurrencyListener(Supplier<String> consoleChannel) {
        super(consoleChannel, () -> LightmansDiscordIntegration.PROXY.getJDA());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new NotifyTraderOwnerTask(this), 0L, 300000L);
    }

    protected void onChannelMessageReceived(MessageReceivedEvent event) {
        this.handleMessage(event.getChannel(), event.getMessage(), event.getAuthor());
    }

    public void onPrivateMessageReceived(PrivateMessageReceivedEvent event) {
        this.handleMessage((MessageChannel)event.getChannel(), event.getMessage(), event.getAuthor());
    }

    private void handleMessage(MessageChannel channel, Message message, User author) {
        String prefix;
        if (author.isBot()) {
            return;
        }
        String input = message.getContentDisplay();
        if (input.startsWith(prefix = (String)Config.SERVER.currencyBotCommandPrefix.get())) {
            String command = input.substring(prefix.length());
            if (command.startsWith("help")) {
                ArrayList<String> output = new ArrayList<String>();
                output.add(prefix + "notifications <help|enable|disable> - " + MessageManager.M_HELP_LC_NOTIFICATIONS.get());
                output.add(prefix + "search <sales|purchases|barters|all> [searchText] - " + MessageManager.M_HELP_LC_SEARCH1.get());
                output.add(prefix + "search <players|shops> [searchText] - " + MessageManager.M_HELP_LC_SEARCH2.get());
                MessageUtil.sendTextMessage((MessageChannel)channel, output);
            } else if (command.startsWith("notifications ")) {
                String subcommand = command.substring(14);
                if (subcommand.startsWith("help")) {
                    ArrayList<String> output = new ArrayList<String>();
                    output.add(AccountManager.currencyNotificationsEnabled((User)author) ? MessageManager.M_NOTIFICATIONS_ENABLED.get() : MessageManager.M_NOTIFICATIONS_DISABLED.get());
                    output.addAll(Lists.newArrayList((Object[])MessageManager.M_NOTIFICATIONS_HELP.get().split("\n")));
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else if (subcommand.startsWith("enable")) {
                    if (AccountManager.enableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_NOTIFICATIONS_ENABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_NOTIFICATIONS_ENABLE_FAIL.get());
                    }
                } else if (subcommand.startsWith("disable")) {
                    if (AccountManager.disableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_NOTIFICATIONS_DISABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_NOTIFICATIONS_DISABLE_FAIL.get());
                    }
                }
            } else if (command.startsWith("search ")) {
                String subcommand = command.substring(7);
                AtomicReference<String> searchText = new AtomicReference<String>("");
                AtomicBoolean findSales = new AtomicBoolean(false);
                AtomicBoolean findPurchases = new AtomicBoolean(false);
                AtomicBoolean findBarters = new AtomicBoolean(false);
                AtomicBoolean findOwners = new AtomicBoolean(false);
                AtomicBoolean findTraders = new AtomicBoolean(false);
                if (subcommand.startsWith("sales")) {
                    findSales.set(true);
                    if (subcommand.length() > 6) {
                        searchText.set(subcommand.substring(6).toLowerCase());
                    }
                } else if (subcommand.startsWith("purchases")) {
                    findPurchases.set(true);
                    if (subcommand.length() > 10) {
                        searchText.set(subcommand.substring(10).toLowerCase());
                    }
                } else if (subcommand.startsWith("barters")) {
                    findBarters.set(true);
                    if (subcommand.length() > 10) {
                        searchText.set(subcommand.substring(10).toLowerCase());
                    }
                } else if (subcommand.startsWith("players")) {
                    findOwners.set(true);
                    if (subcommand.length() > 8) {
                        searchText.set(subcommand.substring(8).toLowerCase());
                    }
                } else if (subcommand.startsWith("shops")) {
                    findTraders.set(true);
                    if (subcommand.length() > 6) {
                        searchText.set(subcommand.substring(6).toLowerCase());
                    }
                } else if (subcommand.startsWith("all")) {
                    findSales.set(true);
                    findPurchases.set(true);
                    findBarters.set(true);
                    if (subcommand.length() > 4) {
                        searchText.set(subcommand.substring(4).toLowerCase());
                    }
                }
                ArrayList output = new ArrayList();
                TradingOffice.getTraders().forEach(trader -> {
                    try {
                        boolean listTrader;
                        boolean bl = listTrader = findOwners.get() && (((String)searchText.get()).isEmpty() || trader.getCoreSettings().getOwnerName().toLowerCase().contains((CharSequence)searchText.get())) || findTraders.get() && (((String)searchText.get()).isEmpty() || trader.getName().getString().toLowerCase().contains((CharSequence)searchText.get()));
                        if (trader instanceof UniversalItemTraderData) {
                            UniversalItemTraderData itemTrader = (UniversalItemTraderData)trader;
                            if (listTrader) {
                                boolean firstTrade = true;
                                for (int i = 0; i < itemTrader.getTradeCount(); ++i) {
                                    String priceText;
                                    String itemName;
                                    ItemStack sellItem;
                                    ItemTradeData trade = itemTrader.getTrade(i);
                                    if (!trade.isValid()) continue;
                                    if (firstTrade) {
                                        output.add("--" + itemTrader.getCoreSettings().getOwnerName() + "'s **" + itemTrader.getName().getString() + "**--");
                                        firstTrade = false;
                                    }
                                    if (trade.isSale()) {
                                        sellItem = trade.getSellItem();
                                        itemName = CurrencyListener.getItemName(sellItem, trade.getCustomName());
                                        priceText = trade.getCost().getString();
                                        output.add("Selling " + sellItem.func_190916_E() + "x " + itemName + " for " + priceText);
                                        continue;
                                    }
                                    if (trade.isPurchase()) {
                                        sellItem = trade.getSellItem();
                                        itemName = CurrencyListener.getItemName(sellItem, "");
                                        priceText = trade.getCost().getString();
                                        output.add("Purchasing " + sellItem.func_190916_E() + "x " + itemName + " for " + priceText);
                                        continue;
                                    }
                                    if (!trade.isBarter()) continue;
                                    sellItem = trade.getSellItem();
                                    String sellItemName = CurrencyListener.getItemName(sellItem, trade.getCustomName());
                                    ItemStack barterItem = trade.getBarterItem();
                                    String barterItemName = CurrencyListener.getItemName(barterItem, "");
                                    output.add("Bartering " + barterItem.func_190916_E() + "x " + barterItemName + " for " + sellItem.func_190916_E() + "x " + sellItemName);
                                }
                            } else {
                                for (int i = 0; i < itemTrader.getTradeCount(); ++i) {
                                    String priceText;
                                    String itemName;
                                    ItemStack sellItem;
                                    ItemTradeData trade = itemTrader.getTrade(i);
                                    if (!trade.isValid()) continue;
                                    if (trade.isSale() && findSales.get()) {
                                        sellItem = trade.getSellItem();
                                        itemName = CurrencyListener.getItemName(sellItem, trade.getCustomName());
                                        if (!((String)searchText.get()).isEmpty() && !itemName.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                        priceText = trade.getCost().getString();
                                        output.add(itemTrader.getCoreSettings().getOwnerName() + " is selling " + sellItem.func_190916_E() + "x " + itemName + " at " + itemTrader.getName().getString() + " for " + priceText);
                                        continue;
                                    }
                                    if (trade.isPurchase() && findPurchases.get()) {
                                        sellItem = trade.getSellItem();
                                        itemName = CurrencyListener.getItemName(sellItem, "");
                                        if (!((String)searchText.get()).isEmpty() && !itemName.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                        priceText = trade.getCost().getString();
                                        output.add(itemTrader.getCoreSettings().getOwnerName() + " is buying " + sellItem.func_190916_E() + "x " + itemName + " at " + itemTrader.getName().getString() + " for " + priceText);
                                        continue;
                                    }
                                    if (!trade.isBarter() || !findBarters.get()) continue;
                                    sellItem = trade.getSellItem();
                                    String sellItemName = CurrencyListener.getItemName(sellItem, trade.getCustomName());
                                    ItemStack barterItem = trade.getBarterItem();
                                    String barterItemName = CurrencyListener.getItemName(barterItem, "");
                                    if (!((String)searchText.get()).isEmpty() && !sellItemName.toLowerCase().contains((CharSequence)searchText.get()) && !barterItemName.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                    output.add(itemTrader.getCoreSettings().getOwnerName() + " is bartering " + barterItem.func_190916_E() + "x " + barterItemName + " for " + sellItem.func_190916_E() + "x " + sellItemName + " at " + itemTrader.getName().getString());
                                }
                            }
                        } else {
                            MinecraftForge.EVENT_BUS.post((Event)new DiscordTraderSearchEvent((UniversalTraderData)trader, (String)searchText.get(), findSales.get(), findPurchases.get(), findBarters.get(), findOwners.get(), findTraders.get(), output));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                if (output.size() > 0) {
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else {
                    MessageUtil.sendTextMessage((MessageChannel)channel, (String)MessageManager.M_SEARCH_NORESULTS.get());
                }
            }
        }
    }

    private static String getItemName(ItemStack item, String customName) {
        StringBuffer itemName = new StringBuffer();
        if (customName.isEmpty()) {
            itemName.append(item.func_200301_q().getString());
        } else {
            itemName.append("*").append(customName).append("*");
        }
        AtomicBoolean firstEnchantment = new AtomicBoolean(true);
        EnchantmentHelper.func_82781_a((ItemStack)item).forEach((enchantment, level) -> {
            if (firstEnchantment.get()) {
                itemName.append(" [").append(enchantment.func_200305_d(level.intValue()).getString());
                firstEnchantment.set(false);
            } else {
                itemName.append(", ").append(enchantment.func_200305_d(level.intValue()).getString());
            }
        });
        if (!firstEnchantment.get()) {
            itemName.append("]");
        }
        return itemName.toString();
    }

    @SubscribeEvent
    public void onTradeCarriedOut(TradeEvent.PostTradeEvent event) {
        try {
            User linkedUser;
            LinkedAccount account;
            PlayerReference recipient = event.getTrader().getCoreSettings().getOwner();
            if (event.getTrader().getCoreSettings().getTeam() != null) {
                recipient = event.getTrader().getCoreSettings().getTeam().getOwner();
            }
            if ((account = AccountManager.getLinkedAccountFromPlayerID((UUID)recipient.id)) != null && AccountManager.currencyNotificationsEnabled((User)(linkedUser = this.getJDA().getUserById(account.discordID)))) {
                if (event.getTrade() instanceof ItemTradeData) {
                    ItemTradeData itemTrade = (ItemTradeData)event.getTrade();
                    StringBuffer message2 = new StringBuffer();
                    message2.append(event.getPlayerReference().lastKnownName());
                    switch (itemTrade.getTradeType()) {
                        case SALE: {
                            message2.append(" bought ");
                            break;
                        }
                        case PURCHASE: {
                            message2.append(" sold ");
                            break;
                        }
                        case BARTER: {
                            message2.append("bartered ");
                            break;
                        }
                        default: {
                            message2.append(" ??? ");
                        }
                    }
                    if (itemTrade.isBarter()) {
                        ItemStack barteredItem = itemTrade.getBarterItem();
                        message2.append(barteredItem.func_190916_E()).append(" ").append(barteredItem.func_200301_q().getString());
                        ItemStack boughtItem = itemTrade.getSellItem();
                        String boughtItemName = itemTrade.getCustomName().isEmpty() ? boughtItem.func_200301_q().getString() : itemTrade.getCustomName();
                        message2.append(boughtItem.func_190916_E()).append(" ").append(boughtItemName);
                    } else {
                        ItemStack boughtItem = itemTrade.getSellItem();
                        String boughtItemName = itemTrade.getCustomName().isEmpty() || itemTrade.getTradeType() != ItemTradeData.ItemTradeType.SALE ? boughtItem.func_200301_q().getString() : itemTrade.getCustomName();
                        message2.append(boughtItem.func_190916_E()).append(" ").append(boughtItemName);
                        message2.append(" for ");
                        if (event.getPricePaid().isFree() || event.getPricePaid().getRawValue() <= 0L) {
                            message2.append("free");
                        } else {
                            message2.append(event.getPricePaid().getString());
                        }
                    }
                    message2.append(" from your ").append(event.getTrader().getName().getString());
                    this.addPendingMessage(linkedUser, message2.toString());
                    if (event.getTrader() instanceof IItemTrader && itemTrade.stockCount((IItemTrader)event.getTrader()) < 1) {
                        this.addPendingMessage(linkedUser, MessageManager.M_NOTIFICATION_OUTOFSTOCK.get());
                    }
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new DiscordPostTradeEvent(event, message -> this.addPendingMessage(linkedUser, (String)message)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPendingMessage(User user, String message) {
        String userId = user.getId();
        ArrayList pendingMessages = this.pendingMessages.containsKey(userId) ? this.pendingMessages.get(userId) : Lists.newArrayList();
        pendingMessages.add(message);
        this.pendingMessages.put(userId, pendingMessages);
    }

    public void addPendingMessage(User user, List<String> messages) {
        String userId = user.getId();
        ArrayList pendingMessages = this.pendingMessages.containsKey(userId) ? this.pendingMessages.get(userId) : Lists.newArrayList();
        messages.forEach(message -> pendingMessages.add(message));
        this.pendingMessages.put(userId, pendingMessages);
    }

    public void sendPendingMessages() {
        this.pendingMessages.forEach((userId, messages) -> {
            try {
                User user = this.getJDA().getUserById(userId);
                if (user != null) {
                    MessageUtil.sendPrivateMessage((User)user, (List)messages);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.pendingMessages.clear();
    }

    @SubscribeEvent
    public void onUniversalTraderRegistered(UniversalTraderEvent.UniversalTradeCreateEvent event) {
        new Timer().schedule((TimerTask)new AnnouncementTask(this, event), 60000L);
    }

    @SubscribeEvent
    public void onServerStop(FMLServerStoppingEvent event) {
        this.timer.cancel();
        this.sendPendingMessages();
    }

    private static class AnnouncementTask
    extends TimerTask {
        private final CurrencyListener cl;
        private final UniversalTraderEvent.UniversalTradeCreateEvent event;

        public AnnouncementTask(CurrencyListener cl, UniversalTraderEvent.UniversalTradeCreateEvent event) {
            this.cl = cl;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                if (this.event.getData() == null) {
                    return;
                }
                if (this.event.getData().getCoreSettings().hasCustomName()) {
                    this.cl.sendTextMessage(MessageManager.M_NEWTRADER_NAMED.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName(), this.event.getData().getCoreSettings().getCustomName()}));
                } else {
                    this.cl.sendTextMessage(MessageManager.M_NEWTRADER.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName()}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class NotifyTraderOwnerTask
    extends TimerTask {
        private final CurrencyListener cl;

        public NotifyTraderOwnerTask(CurrencyListener cl) {
            this.cl = cl;
        }

        @Override
        public void run() {
            this.cl.sendPendingMessages();
        }
    }
}

