/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.events;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import net.minecraftforge.eventbus.api.Event;

public class TradeEditEvent
extends Event {
    private final Supplier<ITrader> traderSource;
    protected final int tradeIndex;

    public final ITrader getTrader() {
        return (ITrader)this.traderSource.get();
    }

    public final int getTradeIndex() {
        return this.tradeIndex;
    }

    public TradeEditEvent(Supplier<ITrader> trader, int tradeIndex) {
        this.traderSource = trader;
        this.tradeIndex = tradeIndex;
    }

    public static class TradePriceEditEvent
    extends TradeEditEvent {
        private final CoinValue oldPrice;

        public final CoinValue getOldPrice() {
            return this.oldPrice;
        }

        public final boolean getWasFree() {
            return this.oldPrice.isFree();
        }

        public TradePriceEditEvent(Supplier<ITrader> trader, int tradeIndex, CoinValue oldPrice) {
            super(trader, tradeIndex);
            this.oldPrice = oldPrice;
        }
    }
}

