/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.events;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.eventbus.api.Event;

public abstract class TradeEvent
extends Event {
    private final PlayerReference player;
    private final TradeData trade;
    private final Supplier<ITrader> traderSource;

    public final PlayerReference getPlayerReference() {
        return this.player;
    }

    @Deprecated
    public final PlayerEntity getPlayer() {
        return this.player.getPlayer();
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final ITrader getTrader() {
        return (ITrader)this.traderSource.get();
    }

    protected TradeEvent(PlayerReference player, TradeData trade, Supplier<ITrader> trader) {
        this.player = player;
        this.trade = trade;
        this.traderSource = trader;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final CoinValue pricePaid;

        public CoinValue getPricePaid() {
            return this.pricePaid;
        }

        public PostTradeEvent(PlayerReference player, TradeData trade, Supplier<ITrader> trader, CoinValue pricePaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private double costMultiplier = 1.0;
        CoinValue currentCost;

        public double getCostMultiplier() {
            return this.costMultiplier;
        }

        public void applyCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(this.costMultiplier * newCostMultiplier, 0.0, 2.0);
        }

        public void setCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(newCostMultiplier, 0.0, 2.0);
        }

        public CoinValue getBaseCost() {
            return this.currentCost;
        }

        public CoinValue getCostResult() {
            return this.currentCost.ApplyMultiplier(this.costMultiplier);
        }

        public TradeCostEvent(PlayerReference player, TradeData trade, Supplier<ITrader> trader) {
            super(player, trade, trader);
            this.currentCost = trade.getCost();
        }
    }

    public static class PreTradeEvent
    extends TradeEvent {
        private final List<ITextComponent> denialText = Lists.newArrayList();

        public PreTradeEvent(PlayerReference player, TradeData trade, Supplier<ITrader> trader) {
            super(player, trade, trader);
        }

        public void denyTrade(ITextComponent reason) {
            this.denialText.add(reason);
            this.setCanceled(true);
        }

        public List<ITextComponent> getDenialReasons() {
            return this.denialText;
        }

        public boolean isCancelable() {
            return true;
        }
    }
}

