/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import io.github.lightman314.lightmanscurrency.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CashRegisterItem
extends BlockItem {
    private static final SoundEvent soundEffect = new SoundEvent(new ResourceLocation("minecraft", "entity.experience_orb.pickup"));

    public CashRegisterItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos lookPos = context.func_195995_a();
        World world = context.func_195991_k();
        if (lookPos != null && world.func_180495_p(lookPos).func_177230_c() instanceof ITraderBlock) {
            ITraderBlock block = (ITraderBlock)world.func_180495_p(lookPos).func_177230_c();
            TileEntity tileEntity = block.getTileEntity(world.func_180495_p(lookPos), (IWorld)world, lookPos);
            if (!this.HasEntity(context.func_195996_i(), tileEntity) && tileEntity instanceof TraderTileEntity) {
                this.AddEntity(context.func_195996_i(), tileEntity);
                if (world.field_72995_K) {
                    world.func_184133_a(context.func_195999_j(), tileEntity.func_174877_v(), soundEffect, SoundCategory.NEUTRAL, 1.0f, 0.0f);
                }
                return ActionResultType.SUCCESS;
            }
            if (tileEntity instanceof TraderTileEntity) {
                if (world.field_72995_K) {
                    world.func_184133_a(context.func_195999_j(), tileEntity.func_174877_v(), soundEffect, SoundCategory.NEUTRAL, 1.0f, 1.35f);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }

    private boolean HasEntity(ItemStack stack, TileEntity tileEntity) {
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (!tag.func_74764_b("TraderPos")) {
            return false;
        }
        ListNBT storageList = tag.func_150295_c("TraderPos", 10);
        for (int i = 0; i < storageList.size(); ++i) {
            CompoundNBT thisEntry = storageList.func_150305_b(i);
            if (!thisEntry.func_74764_b("x") || !thisEntry.func_74764_b("y") || !thisEntry.func_74764_b("z") || thisEntry.func_74762_e("x") != tileEntity.func_174877_v().func_177958_n() || thisEntry.func_74762_e("y") != tileEntity.func_174877_v().func_177956_o() || thisEntry.func_74762_e("z") != tileEntity.func_174877_v().func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private void AddEntity(ItemStack stack, TileEntity tileEntity) {
        CompoundNBT tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        ListNBT storageList = (tag = stack.func_77978_p()).func_74764_b("TraderPos") ? tag.func_150295_c("TraderPos", 10) : new ListNBT();
        CompoundNBT newEntry = new CompoundNBT();
        newEntry.func_74768_a("x", tileEntity.func_174877_v().func_177958_n());
        newEntry.func_74768_a("y", tileEntity.func_174877_v().func_177956_o());
        newEntry.func_74768_a("z", tileEntity.func_174877_v().func_177952_p());
        storageList.add((Object)newEntry);
        tag.func_218657_a("TraderPos", (INBT)storageList);
    }

    private List<BlockPos> readNBT(ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (!stack.func_77942_o()) {
            return positions;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag.func_74764_b("TraderPos")) {
            ListNBT list = tag.func_150295_c("TraderPos", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT thisPos = list.func_150305_b(i);
                if (!thisPos.func_74764_b("x") || !thisPos.func_74764_b("y") || !thisPos.func_74764_b("z")) continue;
                positions.add(new BlockPos(thisPos.func_74762_e("x"), thisPos.func_74762_e("y"), thisPos.func_74762_e("z")));
            }
        }
        return positions;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        List<BlockPos> data = this.readNBT(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooptip.lightmanscurrency.cash_register", new Object[]{data.size()}));
        if (!Screen.func_231173_s_() || data.size() <= 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooptip.lightmanscurrency.cash_register.instructions"));
        }
        if (Screen.func_231173_s_()) {
            for (int i = 0; i < data.size(); ++i) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.cash_register.details", new Object[]{i + 1, data.get(i).func_177958_n(), data.get(i).func_177956_o(), data.get(i).func_177952_p()}));
            }
        } else if (data.size() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooptip.lightmanscurrency.cash_register.holdshift"));
        }
    }
}

