/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CoinItem
extends Item {
    public CoinItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CoinItem.addCoinTooltips(stack, tooltip);
    }

    public static void addCoinTooltips(ItemStack stack, List<ITextComponent> tooltip) {
        CoinData coinData = MoneyUtil.getData(stack.func_77973_b());
        if (coinData != null) {
            switch ((CoinItemTooltipType)((Object)Config.SERVER.coinTooltipType.get())) {
                case DEFAULT: {
                    Pair<Item, Integer> upwardConversion;
                    if (coinData.convertsDownwards()) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.coinworth.down", new Object[]{"\u00a7e" + coinData.getDownwardConversion().getSecond(), "\u00a7e" + ((Item)coinData.getDownwardConversion().getFirst()).func_200296_o().getString()}));
                    }
                    if ((upwardConversion = MoneyUtil.getUpwardConversion(stack.func_77973_b())) == null) break;
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.coinworth.up", new Object[]{"\u00a7e" + upwardConversion.getSecond(), "\u00a7e" + ((Item)upwardConversion.getFirst()).func_200296_o().getString()}));
                    break;
                }
                case VALUE: {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a7e" + Config.formatValueDisplay(coinData.getDisplayValue())));
                    break;
                }
            }
        }
    }

    public static enum CoinItemTooltipType {
        DEFAULT,
        VALUE,
        NONE;

    }
}

