/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import io.github.lightman314.lightmanscurrency.core.ModItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TicketItem
extends Item {
    public static final ResourceLocation TICKET_TAG = new ResourceLocation("lightmanscurrency", "ticket");
    public static final ResourceLocation TICKET_MATERIAL_TAG = new ResourceLocation("lightmanscurrency", "ticket_material");

    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        UUID ticketID;
        if (Screen.func_231173_s_() && (ticketID = TicketItem.GetTicketID(stack)) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.ticket.id", new Object[]{ticketID}));
        }
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.func_190926_b() || !ticket.func_77942_o()) {
            return false;
        }
        return ticket.func_77973_b() == ModItems.TICKET_MASTER;
    }

    public static UUID GetTicketID(ItemStack ticket) {
        if (ticket.func_190926_b() || !(ticket.func_77973_b() instanceof TicketItem) || !ticket.func_77942_o()) {
            return null;
        }
        CompoundNBT ticketTag = ticket.func_77978_p();
        if (!ticketTag.func_74764_b("TicketID")) {
            return null;
        }
        return ticketTag.func_186857_a("TicketID");
    }

    public static ItemStack CreateMasterTicket(UUID ticketID) {
        ItemStack ticket = new ItemStack((IItemProvider)ModItems.TICKET_MASTER);
        if (ticketID != null) {
            ticket.func_196082_o().func_186854_a("TicketID", ticketID);
        }
        return ticket;
    }

    public static ItemStack CreateTicket(UUID ticketID, int count) {
        ItemStack ticket = new ItemStack((IItemProvider)ModItems.TICKET, count);
        if (ticketID != null) {
            ticket.func_196082_o().func_186854_a("TicketID", ticketID);
        }
        return ticket;
    }
}

