/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.containers.providers.WalletContainerProvider;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = new SoundEvent(new ResourceLocation("minecraft", "item.armor.equip_leather"));
    private final ResourceLocation MODEL_TEXTURE;
    private final int level;
    private final int storageSize;

    public WalletItem(int level, int storageSize, String modelName, Item.Properties properties) {
        super(properties);
        this.level = level;
        this.storageSize = storageSize;
        this.MODEL_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/entity/" + modelName + ".png");
    }

    public static boolean validWalletStack(ItemStack walletStack) {
        if (walletStack.func_190926_b()) {
            return true;
        }
        return WalletItem.isWallet(walletStack.func_77973_b());
    }

    public static boolean isWallet(Item item) {
        return item instanceof WalletItem;
    }

    public static boolean CanConvert(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletConvertLevel.get() || wallet.level >= (Integer)Config.SERVER.walletPickupLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)Config.SERVER.walletBankLevel.get();
    }

    public static int InventorySize(WalletItem wallet) {
        if (wallet == null) {
            return 0;
        }
        return wallet.storageSize;
    }

    public static int InventorySize(ItemStack wallet) {
        if (wallet.func_77973_b() instanceof WalletItem) {
            return WalletItem.InventorySize((WalletItem)wallet.func_77973_b());
        }
        return 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CoinValue contents;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (WalletItem.CanPickup(this)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.pickup"));
        }
        if (WalletItem.CanConvert(this)) {
            if (WalletItem.CanPickup(this)) {
                TranslationTextComponent onOffText = WalletItem.getAutoConvert(stack) ? new TranslationTextComponent("tooltip.lightmanscurrency.wallet.autoConvert.on") : new TranslationTextComponent("tooltip.lightmanscurrency.wallet.autoConvert.off");
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.autoConvert", new Object[]{onOffText}));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.manualConvert"));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.bankaccount"));
        }
        if ((contents = new CoinValue(WalletItem.getWalletInventory(stack))).getRawValue() > 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.lightmanscurrency.wallet.storedmoney", new Object[]{"\u00a72" + contents.getString()}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack wallet = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int walletSlot = WalletItem.GetWalletSlot(player.field_71071_by, wallet);
            if (walletSlot >= 0) {
                if (player.func_213453_ef()) {
                    AtomicBoolean equippedWallet = new AtomicBoolean(false);
                    WalletCapability.getWalletHandler((Entity)player).ifPresent(walletHandler -> {
                        if (walletHandler.getWallet().func_190926_b()) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                            walletHandler.setWallet(wallet);
                            equippedWallet.set(true);
                        }
                    });
                    if (equippedWallet.get()) {
                        walletSlot = -1;
                    }
                }
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new WalletContainerProvider(walletSlot), (Consumer)new DataWriter(walletSlot));
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), emptyOpenSound, SoundCategory.PLAYERS, 0.75f, 1.25f + player.field_70170_p.field_73012_v.nextFloat() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), CurrencySoundEvents.COINS_CLINKING, SoundCategory.PLAYERS, 0.4f, 1.0f);
            }
        }
        return ActionResult.func_226248_a_((Object)wallet);
    }

    public static boolean isEmpty(ItemStack wallet) {
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private static int GetWalletSlot(PlayerInventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        ItemStack returnValue = coins.func_77946_l();
        NonNullList<ItemStack> inventory = WalletItem.getWalletInventory(wallet);
        for (int i = 0; i < inventory.size() && !returnValue.func_190926_b(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.func_190926_b()) {
                inventory.set(i, (Object)returnValue.func_77946_l());
                returnValue = ItemStack.field_190927_a;
                continue;
            }
            if (thisStack.func_77973_b() != returnValue.func_77973_b()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.func_190916_E(), 0, thisStack.func_77976_d() - thisStack.func_190916_E());
            thisStack.func_190920_e(thisStack.func_190916_E() + amountToAdd);
            returnValue.func_190920_e(returnValue.func_190916_E() - amountToAdd);
        }
        inventory = WalletItem.getAutoConvert(wallet) ? WalletItem.ConvertCoins(inventory) : MoneyUtil.SortCoins(inventory);
        WalletItem.putWalletInventory(wallet, inventory);
        return returnValue;
    }

    private static NonNullList<ItemStack> ConvertCoins(NonNullList<ItemStack> inventory) {
        inventory = MoneyUtil.ConvertAllCoinsUp(inventory);
        return MoneyUtil.SortCoins(inventory);
    }

    public static void putWalletInventory(ItemStack wallet, NonNullList<ItemStack> inventory) {
        if (!(wallet.func_77973_b() instanceof WalletItem)) {
            return;
        }
        CompoundNBT compound = wallet.func_196082_o();
        ListNBT invList = new ListNBT();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack thisStack = (ItemStack)inventory.get(i);
            if (thisStack.func_190926_b()) continue;
            CompoundNBT thisItemCompound = thisStack.func_77955_b(new CompoundNBT());
            thisItemCompound.func_74774_a("Slot", (byte)i);
            invList.add((Object)thisItemCompound);
        }
        compound.func_218657_a("Items", (INBT)invList);
    }

    public static NonNullList<ItemStack> getWalletInventory(ItemStack wallet) {
        CompoundNBT compound = wallet.func_196082_o();
        if (!(wallet.func_77973_b() instanceof WalletItem)) {
            return NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        }
        NonNullList value = NonNullList.func_191197_a((int)WalletItem.InventorySize((WalletItem)wallet.func_77973_b()), (Object)ItemStack.field_190927_a);
        if (!compound.func_74764_b("Items")) {
            return value;
        }
        ListNBT invList = compound.func_150295_c("Items", 10);
        for (int i = 0; i < invList.size(); ++i) {
            CompoundNBT thisCompound = invList.func_150305_b(i);
            ItemStack thisStack = ItemStack.func_199557_a((CompoundNBT)thisCompound);
            int j = thisCompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= value.size()) continue;
            value.set(j, (Object)thisStack);
        }
        return value;
    }

    public static boolean getAutoConvert(ItemStack wallet) {
        if (!(wallet.func_77973_b() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.func_77973_b()) || !WalletItem.CanPickup((WalletItem)wallet.func_77973_b())) {
            return false;
        }
        CompoundNBT tag = wallet.func_196082_o();
        if (!tag.func_74764_b("AutoConvert")) {
            tag.func_74757_a("AutoConvert", true);
            return true;
        }
        return tag.func_74767_n("AutoConvert");
    }

    public static void toggleAutoConvert(ItemStack wallet) {
        if (!(wallet.func_77973_b() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanConvert((WalletItem)wallet.func_77973_b())) {
            return;
        }
        CompoundNBT tag = wallet.func_196082_o();
        boolean oldValue = WalletItem.getAutoConvert(wallet);
        tag.func_74757_a("AutoConvert", !oldValue);
    }

    public static void CopyWalletContents(ItemStack walletIn, ItemStack walletOut) {
        if (!(walletIn.func_77973_b() instanceof WalletItem) || !(walletIn.func_77973_b() instanceof WalletItem)) {
            LightmansCurrency.LogError("WalletItem.CopyWalletContents() -> One or both of the wallet stacks are not WalletItems.");
            return;
        }
        WalletItem walletItemIn = (WalletItem)walletIn.func_77973_b();
        WalletItem walletItemOut = (WalletItem)walletOut.func_77973_b();
        NonNullList<ItemStack> walletInventory1 = WalletItem.getWalletInventory(walletIn);
        NonNullList<ItemStack> walletInventory2 = WalletItem.getWalletInventory(walletOut);
        if (walletInventory1.size() > walletInventory2.size()) {
            LightmansCurrency.LogWarning("WalletItem.CopyWalletContents() -> walletIn has a larger inventory size than walletOut. This may result in a loss of wallet contents.");
        }
        for (int i = 0; i < walletInventory1.size() && i < walletInventory2.size(); ++i) {
            walletInventory2.set(i, (Object)((ItemStack)walletInventory1.get(i)).func_77946_l());
        }
        WalletItem.putWalletInventory(walletOut, walletInventory2);
        if (WalletItem.CanConvert(walletItemIn) && WalletItem.CanConvert(walletItemOut) && WalletItem.CanPickup(walletItemIn) && WalletItem.CanPickup(walletItemOut) && WalletItem.getAutoConvert(walletIn) != WalletItem.getAutoConvert(walletOut)) {
            WalletItem.toggleAutoConvert(walletOut);
        }
        if (walletIn.func_82837_s()) {
            walletOut.func_200302_a(walletIn.func_200301_q());
        }
        EnchantmentHelper.func_82781_a((ItemStack)walletIn).forEach((enchantment, level) -> walletOut.func_77966_a(enchantment, level.intValue()));
    }

    public ResourceLocation getModelTexture() {
        return this.MODEL_TEXTURE;
    }

    public static class DataWriter
    implements Consumer<PacketBuffer> {
        private int slotIndex;

        public DataWriter(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.writeInt(this.slotIndex);
        }
    }
}

