/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.money;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class CoinValue {
    public static final String DEFAULT_KEY = "CoinValue";
    private boolean isFree = false;
    public final List<CoinValuePair> coinValues;
    public static final CoinValue EMPTY = new CoinValue(new CoinValuePair[0]);

    public boolean isFree() {
        return this.isFree;
    }

    public void setFree(boolean free) {
        this.isFree = free;
        if (this.isFree) {
            this.coinValues.clear();
        }
    }

    public boolean isValid() {
        return this.isFree || this.coinValues.size() > 0;
    }

    public CoinValue(CompoundNBT compound) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.readFromNBT(compound, DEFAULT_KEY);
        this.roundValue();
    }

    public CoinValue(long rawValue) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.readFromOldValue(rawValue);
        this.roundValue();
    }

    public CoinValue(NonNullList<ItemStack> inventory) {
        this.coinValues = new ArrayList<CoinValuePair>();
        this.readFromOldValue(MoneyUtil.getValue(inventory));
        this.roundValue();
    }

    public CoinValue(CoinValue otherValue) {
        this.isFree = otherValue.isFree;
        this.coinValues = new ArrayList<CoinValuePair>();
        if (!this.isFree) {
            for (CoinValuePair pricePair : otherValue.coinValues) {
                this.coinValues.add(pricePair.copy());
            }
            this.roundValue();
        }
    }

    @SafeVarargs
    public CoinValue(CoinValuePair ... priceValues) {
        this.coinValues = new ArrayList<CoinValuePair>();
        for (CoinValuePair value : priceValues) {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (this.coinValues.get((int)i).coin != value.coin) continue;
                this.coinValues.get((int)i).amount += value.amount;
                value.amount = 0;
            }
            if (value.amount <= 0) continue;
            this.coinValues.add(value);
        }
        this.roundValue();
    }

    private CoinValue(List<CoinValuePair> priceValues, boolean validateChain) {
        if (validateChain) {
            this.coinValues = new ArrayList<CoinValuePair>();
            for (int i = 0; i < priceValues.size(); ++i) {
                this.addValue(priceValues.get((int)i).coin, priceValues.get((int)i).amount);
            }
        } else {
            this.coinValues = priceValues;
            this.roundValue();
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT compound, String key) {
        if (this.isFree) {
            compound.func_74757_a(key, true);
        } else {
            ListNBT list = new ListNBT();
            for (CoinValuePair value : this.coinValues) {
                CompoundNBT thisCompound = new CompoundNBT();
                ResourceLocation resource = value.coin.getRegistryName();
                if (resource == null || !MoneyUtil.isCoin(value.coin)) continue;
                thisCompound.func_74778_a("id", resource.toString());
                thisCompound.func_74768_a("amount", value.amount);
                list.add((Object)thisCompound);
            }
            compound.func_218657_a(key, (INBT)list);
        }
        return compound;
    }

    public void readFromNBT(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 3)) {
            this.readFromOldValue(compound.func_74762_e(key));
        } else if (compound.func_150297_b(key, 9)) {
            ListNBT listNBT = compound.func_150295_c(key, 10);
            if (listNBT != null) {
                this.coinValues.clear();
                for (int i = 0; i < listNBT.size(); ++i) {
                    CompoundNBT thisCompound = listNBT.func_150305_b(i);
                    Item priceCoin = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(thisCompound.func_74779_i("id")));
                    int amount = thisCompound.func_74762_e("amount");
                    this.coinValues.add(new CoinValuePair(priceCoin, amount));
                }
            }
        } else if (compound.func_74764_b(key)) {
            this.setFree(compound.func_74767_n(key));
        }
    }

    public void readFromOldValue(long oldPrice) {
        this.coinValues.clear();
        List<ItemStack> coinItems = MoneyUtil.getCoinsOfValue(oldPrice);
        for (ItemStack stack : coinItems) {
            Item coinItem = stack.func_77973_b();
            int amount = stack.func_190916_E();
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (this.coinValues.get((int)i).coin != coinItem) continue;
                this.coinValues.get((int)i).amount += amount;
                amount = 0;
            }
            if (amount <= 0) continue;
            this.coinValues.add(new CoinValuePair(coinItem, amount));
        }
    }

    public void addValue(CoinValue other) {
        CoinValue otherPrice = other.copy();
        for (int i = 0; i < this.coinValues.size(); ++i) {
            for (int j = 0; j < otherPrice.coinValues.size(); ++j) {
                if (this.coinValues.get((int)i).coin != otherPrice.coinValues.get((int)j).coin) continue;
                this.coinValues.get((int)i).amount += otherPrice.coinValues.get((int)j).amount;
                otherPrice.coinValues.get((int)j).amount = 0;
            }
        }
        for (CoinValuePair pair : otherPrice.coinValues) {
            if (pair.amount <= 0) continue;
            this.coinValues.add(pair);
        }
        this.roundValue();
    }

    public void addValue(Item coin, int amount) {
        long newValue = this.getRawValue() + MoneyUtil.getValue(coin) * (long)amount;
        this.readFromOldValue(newValue);
        this.roundValue();
    }

    public void removeValue(Item coin, int amount) {
        long newValue = this.getRawValue() - MoneyUtil.getValue(coin) * (long)amount;
        this.readFromOldValue(newValue);
        this.roundValue();
    }

    private void roundValue() {
        while (this.needsRounding()) {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (!this.needsRounding(i)) continue;
                CoinValuePair pair = this.coinValues.get(i);
                Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
                int largeAmount = 0;
                while (pair.amount >= (Integer)conversion.getSecond()) {
                    ++largeAmount;
                    pair.amount -= ((Integer)conversion.getSecond()).intValue();
                }
                if (pair.amount == 0) {
                    this.coinValues.remove(i);
                    --i;
                }
                for (CoinValuePair thisPair : this.coinValues) {
                    if (thisPair.coin != conversion.getFirst()) continue;
                    thisPair.amount += largeAmount;
                    largeAmount = 0;
                }
                if (largeAmount <= 0) continue;
                this.coinValues.add(new CoinValuePair((Item)conversion.getFirst(), largeAmount));
            }
        }
        this.sortValue();
    }

    private void sortValue() {
        ArrayList<CoinValuePair> newList = new ArrayList<CoinValuePair>();
        while (this.coinValues.size() > 0) {
            long largestValue = MoneyUtil.getValue(this.coinValues.get((int)0).coin);
            int largestIndex = 0;
            for (int i = 1; i < this.coinValues.size(); ++i) {
                long thisValue = MoneyUtil.getValue(this.coinValues.get((int)i).coin);
                if (thisValue <= largestValue) continue;
                largestIndex = i;
                largestValue = thisValue;
            }
            newList.add(this.coinValues.get(largestIndex));
            this.coinValues.remove(largestIndex);
        }
        for (int i = 0; i < newList.size(); ++i) {
            this.coinValues.add((CoinValuePair)newList.get(i));
        }
    }

    private boolean needsRounding() {
        for (int i = 0; i < this.coinValues.size(); ++i) {
            if (!this.needsRounding(i)) continue;
            return true;
        }
        return false;
    }

    private boolean needsRounding(int index) {
        CoinValuePair pair = this.coinValues.get(index);
        Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
        return conversion != null && pair.amount >= (Integer)conversion.getSecond();
    }

    public int getEntry(Item coinItem) {
        for (CoinValuePair pair : this.coinValues) {
            if (pair.coin != coinItem) continue;
            return pair.amount;
        }
        return 0;
    }

    public CoinValue copy() {
        return new CoinValue(this);
    }

    public double getDisplayValue() {
        double totalValue = 0.0;
        for (int i = 0; i < this.coinValues.size(); ++i) {
            CoinValuePair pricePair = this.coinValues.get(i);
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            totalValue += coinData.getDisplayValue() * (double)pricePair.amount;
        }
        return totalValue;
    }

    public String getString() {
        return this.getString("");
    }

    public String getString(String emptyFiller) {
        if (this.isFree) {
            return new TranslationTextComponent("gui.coinvalue.free").getString();
        }
        switch ((ValueType)((Object)Config.SERVER.coinValueType.get())) {
            case DEFAULT: {
                String string = "";
                for (int i = 0; i < this.coinValues.size(); ++i) {
                    CoinValuePair pricePair = this.coinValues.get(i);
                    CoinData coinData = MoneyUtil.getData(pricePair.coin);
                    if (coinData == null) continue;
                    string = string + String.valueOf(pricePair.amount);
                    string = string + coinData.getInitial().getString();
                }
                if (string.isEmpty()) {
                    return emptyFiller;
                }
                return string;
            }
            case VALUE: {
                return Config.formatValueDisplay(this.getDisplayValue());
            }
        }
        return "?";
    }

    public long getRawValue() {
        long value = 0L;
        for (CoinValuePair pricePair : this.coinValues) {
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            value += (long)pricePair.amount * coinData.getValue();
        }
        return value;
    }

    public CoinValue ApplyMultiplier(double costMultiplier) {
        CoinValue multipliedValue = new CoinValue(new CoinValuePair[0]);
        if (this.isFree) {
            multipliedValue.setFree(true);
            return multipliedValue;
        }
        costMultiplier = MathUtil.clamp(costMultiplier, 0.0, 10.0);
        for (int i = 0; i < this.coinValues.size(); ++i) {
            int amount = this.coinValues.get((int)i).amount;
            Item coin = this.coinValues.get((int)i).coin;
            double newAmount = (double)amount * costMultiplier;
            double leftoverAmount = newAmount % 1.0;
            multipliedValue.addValue(coin, (int)newAmount);
            CoinData coinData = MoneyUtil.getData(coin);
            while (coinData != null && coinData.convertsDownwards() && leftoverAmount > 0.0) {
                Pair<Item, Integer> conversion = coinData.getDownwardConversion();
                coin = (Item)conversion.getFirst();
                coinData = MoneyUtil.getData(coin);
                newAmount = leftoverAmount * (double)((Integer)conversion.getSecond()).intValue();
                leftoverAmount = newAmount % 1.0;
                multipliedValue.addValue(coin, (int)newAmount);
            }
        }
        if (multipliedValue.getRawValue() <= 0L) {
            multipliedValue.setFree(true);
        }
        return multipliedValue;
    }

    public Pair<ItemStack, ItemStack> getTradeItems() {
        List<ItemStack> coins = MoneyUtil.getCoinsOfValue(this);
        ItemStack stack1 = ItemStack.field_190927_a;
        ItemStack stack2 = ItemStack.field_190927_a;
        if (coins.size() > 0) {
            stack1 = coins.get(0);
        } else {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
        }
        if (coins.size() > 1) {
            stack2 = coins.get(1);
        }
        if (coins.size() > 2) {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave more than two stacks of coins of output.");
        }
        return new Pair((Object)stack1, (Object)stack2);
    }

    public ItemStack getTradeItem() {
        List<ItemStack> coins = MoneyUtil.getCoinsOfValue(this);
        ItemStack stack = ItemStack.field_190927_a;
        if (coins.size() > 0) {
            stack = coins.get(0);
        } else {
            LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
        }
        if (coins.size() > 1) {
            LightmansCurrency.LogWarning("A CoinValue used in a trade output gave more than one stack of coins of output.");
        }
        return stack;
    }

    public static CoinValue easyBuild1(ItemStack ... stack) {
        ArrayList<CoinValuePair> pairs = new ArrayList<CoinValuePair>();
        for (int i = 0; i < stack.length; ++i) {
            if (MoneyUtil.isCoin(stack[i])) {
                pairs.add(new CoinValuePair(stack[i].func_77973_b(), stack[i].func_190916_E()));
                continue;
            }
            LightmansCurrency.LogWarning("CoinValue.easyBuild1: ItemStack at index " + i + " is not a valid coin.");
        }
        return new CoinValue(pairs, false);
    }

    public static CoinValue easyBuild2(IInventory inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static CoinValue Parse(JsonElement json) throws Exception {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return new CoinValue(primitive.getAsNumber().longValue());
            }
            if (primitive.isBoolean() && primitive.getAsBoolean()) {
                CoinValue val = new CoinValue(new CoinValuePair[0]);
                val.setFree(true);
                return val;
            }
            if (primitive.isString()) {
                double displayValue = Double.parseDouble(primitive.getAsString());
                return MoneyUtil.displayValueToCoinValue(displayValue);
            }
        } else if (json.isJsonArray()) {
            ArrayList pairs = Lists.newArrayList();
            JsonArray list = json.getAsJsonArray();
            for (int i = 0; i < list.size(); ++i) {
                JsonObject coinData = list.get(i).getAsJsonObject();
                Item coinItem = Items.field_190931_a;
                int quantity = 1;
                if (coinData.has("coin")) {
                    coinItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(coinData.get("coin").getAsString()));
                }
                if (coinData.has("count")) {
                    quantity = coinData.get("count").getAsInt();
                }
                if (quantity <= 0) {
                    LightmansCurrency.LogWarning("Coin Count (" + quantity + ") is <= 0. Entry will be ignored.");
                    continue;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogWarning("Coin Item (" + coinItem.getRegistryName() + ") is not a valid coin. Entry will be ignored.");
                    continue;
                }
                pairs.add(new CoinValuePair(coinItem, quantity));
            }
            if (pairs.size() <= 0) {
                throw new Exception("Coin Value entry has no valid coin/count entries to parse.");
            }
            return new CoinValue(pairs, true);
        }
        throw new Exception("Coin Value entry input is not a valid Json Element.");
    }

    public JsonElement toJson() {
        if (this.isFree) {
            return new JsonPrimitive(Boolean.valueOf(this.isFree));
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.coinValues.size(); ++i) {
            JsonObject entry = new JsonObject();
            CoinValuePair pair = this.coinValues.get(i);
            entry.addProperty("coin", pair.coin.getRegistryName().toString());
            entry.addProperty("count", (Number)pair.amount);
            array.add((JsonElement)entry);
        }
        return array;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isFree, this.coinValues});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoinValue)) {
            return false;
        }
        CoinValue coinValue = (CoinValue)other;
        if (coinValue.isFree && this.isFree) {
            return true;
        }
        return coinValue.getRawValue() == this.getRawValue();
    }

    public static class CoinValuePair {
        public final Item coin;
        public int amount = 0;

        public CoinValuePair(Item coin, int amount) {
            this.coin = coin;
            this.amount = amount;
        }

        public CoinValuePair copy() {
            return new CoinValuePair(this.coin, this.amount);
        }
    }

    public static enum ValueType {
        DEFAULT,
        VALUE;

    }
}

