/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.money;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.events.GetDefaultMoneyDataEvent;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class MoneyUtil {
    public static final String MONEY_FILE_LOCATION = "config/lightmanscurrency/MasterCoinList.json";
    public static final String MAIN_CHAIN = "main";
    private static MoneyData moneyData = null;

    public static MoneyData getMoneyData() {
        return moneyData;
    }

    public static void receiveMoneyData(MoneyData data) {
        moneyData = data;
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        LightmansCurrency.LogInfo("Setting up Money System for server.");
        MoneyUtil.reloadMoneyData();
    }

    public static void reloadMoneyData() {
        LightmansCurrency.LogInfo("Reloading Money Data");
        File mcl = new File(MONEY_FILE_LOCATION);
        if (!mcl.exists()) {
            MoneyUtil.createMoneyDataFile(mcl);
        }
        try {
            JsonObject fileData = JSONUtils.func_212745_a((String)Files.toString((File)mcl, (Charset)StandardCharsets.UTF_8));
            moneyData = MoneyData.fromJson(fileData);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Master Coin List. Using default values for now.", e);
            moneyData = MoneyData.generateDefault();
        }
        LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)moneyData);
    }

    private static void createMoneyDataFile(File mcl) {
        File dir = new File(mcl.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                mcl.createNewFile();
                MoneyData defaultData = MoneyData.generateDefault();
                FileUtil.writeStringToFile(mcl, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)defaultData.toJson()));
                LightmansCurrency.LogInfo("MasterCoinList.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'MasterCoinList.json' file.", e);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(event.getPlayer()), (Object)moneyData);
    }

    @SubscribeEvent
    public static void initializeDefaultCoins(GetDefaultMoneyDataEvent event) {
        LightmansCurrency.LogInfo("Initializing the Money Utilities.");
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_COPPER, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_copper.initial"));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_IRON, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_iron.initial").defineConversion((IItemProvider)ModItems.COIN_COPPER, 10));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_GOLD, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_gold.initial").defineConversion((IItemProvider)ModItems.COIN_IRON, 10));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_EMERALD, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_emerald.initial").defineConversion((IItemProvider)ModItems.COIN_GOLD, 10));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_DIAMOND, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_diamond.initial").defineConversion((IItemProvider)ModItems.COIN_EMERALD, 10));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder((IItemProvider)ModItems.COIN_NETHERITE, MAIN_CHAIN).defineInitial("item.lightmanscurrency.coin_netherite.initial").defineConversion((IItemProvider)ModItems.COIN_DIAMOND, 10));
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_COPPER, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_COPPER, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_COPPER, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_COPPER, 4).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_IRON, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_IRON, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_IRON, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_IRON, 4).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_GOLD, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_GOLD, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_GOLD, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_GOLD, 4).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_EMERALD, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_EMERALD, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_EMERALD, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_EMERALD, 4).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_DIAMOND, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_DIAMOND, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_DIAMOND, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_DIAMOND, 4).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINPILE_NETHERITE, MAIN_CHAIN).defineConversion((IItemProvider)ModItems.COIN_NETHERITE, 9).setHidden());
        event.dataCollector.addCoinBuilder(CoinData.getBuilder(ModBlocks.COINBLOCK_NETHERITE, MAIN_CHAIN).defineConversion(ModBlocks.COINPILE_NETHERITE, 4).setHidden());
    }

    public static boolean isCoin(Item item) {
        return MoneyUtil.isCoin(item, true);
    }

    public static boolean isCoin(Item item, boolean allowHidden) {
        if (item == null) {
            return false;
        }
        CoinData data = MoneyUtil.getData(item);
        if (data == null) {
            return false;
        }
        return allowHidden || !data.isHidden;
    }

    public static boolean isCoinHidden(Item item) {
        if (item == null) {
            return false;
        }
        CoinData data = MoneyUtil.getData(item);
        if (data == null) {
            return false;
        }
        return data.isHidden;
    }

    public static boolean isCoin(@Nonnull ItemStack stack) {
        return MoneyUtil.isCoin(stack, true);
    }

    public static boolean isCoin(@Nonnull ItemStack stack, boolean allowHidden) {
        return MoneyUtil.isCoin(stack.func_77973_b(), allowHidden);
    }

    public static long getValue(Item coinItem) {
        CoinData coinData = MoneyUtil.getData(coinItem);
        if (coinData != null) {
            return coinData.getValue();
        }
        return 0L;
    }

    public static CoinValue getCoinValue(ItemStack coinStack) {
        return new CoinValue(MoneyUtil.getValue(coinStack));
    }

    public static long getValue(ItemStack coinStack) {
        return MoneyUtil.getValue(coinStack.func_77973_b()) * (long)coinStack.func_190916_E();
    }

    public static CoinValue getCoinValue(NonNullList<ItemStack> inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static long getValue(NonNullList<ItemStack> inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.size(); ++i) {
            value += MoneyUtil.getValue((ItemStack)inventory.get(i));
        }
        return value;
    }

    public static CoinValue getCoinValue(IInventory inventory) {
        return new CoinValue(MoneyUtil.getValue(inventory));
    }

    public static long getValue(IInventory inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            value += MoneyUtil.getValue(inventory.func_70301_a(i));
        }
        return value;
    }

    public static void ConvertAllCoinsUp(IInventory inventory) {
        int i;
        if (moneyData == null) {
            return;
        }
        List<Item> coinList = MoneyUtil.getAllCoins(false);
        for (i = 1; i < coinList.size(); ++i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i));
        }
        for (i = coinList.size() - 1; i > 0; --i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i));
        }
    }

    public static NonNullList<ItemStack> ConvertAllCoinsUp(NonNullList<ItemStack> inventoryList) {
        Inventory inventory = InventoryUtil.buildInventory(inventoryList);
        MoneyUtil.ConvertAllCoinsUp((IInventory)inventory);
        return InventoryUtil.buildList((IInventory)inventory);
    }

    public static void ConvertCoinsUp(IInventory inventory, Item smallCoin) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(smallCoin);
        if (upwardConversion == null) {
            return;
        }
        Item largeCoin = (Item)upwardConversion.getFirst();
        int smallCoinCount = (Integer)upwardConversion.getSecond();
        if (!MoneyUtil.isCoin(largeCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, smallCoin) >= smallCoinCount) {
            InventoryUtil.RemoveItemCount(inventory, smallCoin, smallCoinCount);
            ItemStack newCoinStack = new ItemStack((IItemProvider)largeCoin, 1);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new ItemStack((IItemProvider)smallCoin, smallCoinCount));
            return;
        }
    }

    public static void ConvertAllCoinsDown(IInventory inventory) {
        MoneyUtil.ConvertAllCoinsDown(inventory, 2);
    }

    private static void ConvertAllCoinsDown(IInventory inventory, int iterations) {
        if (moneyData == null) {
            return;
        }
        List<CoinData> coinList = moneyData.getCoinList();
        for (int x = 0; x < iterations; ++x) {
            for (int i = 0; i < coinList.size() - 1; ++i) {
                if (coinList.get((int)i).isHidden) continue;
                MoneyUtil.ConvertCoinsDown(inventory, coinList.get((int)i).coinItem);
            }
        }
    }

    public static void ConvertCoinsDown(IInventory inventory, Item largeCoin) {
        CoinData coinData = MoneyUtil.getData(largeCoin);
        Item smallCoin = coinData.worthOtherCoin;
        int smallCoinCount = coinData.worthOtherCoinCount;
        if (!MoneyUtil.isCoin(smallCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, largeCoin) > 0) {
            InventoryUtil.RemoveItemCount(inventory, largeCoin, 1);
            ItemStack newCoinStack = new ItemStack((IItemProvider)smallCoin, smallCoinCount);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new ItemStack((IItemProvider)largeCoin, 1));
            return;
        }
    }

    public static void SortCoins(IInventory inventory) {
        InventoryUtil.MergeStacks(inventory);
        ArrayList<ItemStack> oldInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            oldInventory.add(inventory.func_70301_a(i));
        }
        inventory.func_174888_l();
        int index = 0;
        while (oldInventory.size() > 0) {
            int highestIndex = 0;
            long highestIndividualValue = MoneyUtil.getValue(((ItemStack)oldInventory.get(0)).func_77973_b());
            long highestWholeValue = highestIndividualValue * (long)((ItemStack)oldInventory.get(0)).func_190916_E();
            for (int i = 1; i < oldInventory.size(); ++i) {
                ItemStack stack = (ItemStack)oldInventory.get(i);
                long thisIndividualValue = MoneyUtil.getValue(stack.func_77973_b());
                long thisWholeValue = thisIndividualValue * (long)stack.func_190916_E();
                if (thisIndividualValue > highestIndividualValue) {
                    highestIndex = i;
                    highestIndividualValue = thisIndividualValue;
                    highestWholeValue = thisWholeValue;
                    continue;
                }
                if (thisIndividualValue != highestIndividualValue || thisWholeValue <= highestWholeValue) continue;
                highestIndex = i;
                highestWholeValue = thisWholeValue;
            }
            inventory.func_70299_a(index, (ItemStack)oldInventory.get(highestIndex));
            ++index;
            oldInventory.remove(highestIndex);
        }
    }

    public static NonNullList<ItemStack> SortCoins(NonNullList<ItemStack> inventory) {
        Inventory tempInventory = InventoryUtil.buildInventory(inventory);
        MoneyUtil.SortCoins((IInventory)tempInventory);
        return InventoryUtil.buildList((IInventory)tempInventory);
    }

    public static boolean ProcessPayment(@Nullable IInventory inventory, @Nonnull PlayerEntity player, @Nonnull CoinValue price) {
        return MoneyUtil.ProcessPayment(inventory, player, price, false);
    }

    public static boolean ProcessPayment(@Nullable IInventory inventory, @Nonnull PlayerEntity player, @Nonnull CoinValue price, boolean ignoreWallet) {
        ItemStack wallet = ignoreWallet ? ItemStack.field_190927_a : LightmansCurrency.getWalletStack(player);
        long valueToTake = price.getRawValue();
        long rawInventoryValue = 0L;
        if (inventory != null) {
            rawInventoryValue += MoneyUtil.getValue(inventory);
        }
        if (!wallet.func_190926_b()) {
            rawInventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (rawInventoryValue < valueToTake) {
            return false;
        }
        if (inventory != null) {
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, inventory, true);
        }
        if (valueToTake > 0L && !wallet.func_190926_b()) {
            NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, walletInventory);
            WalletItem.putWalletInventory(wallet, walletInventory);
        }
        if (valueToTake < 0L) {
            List<ItemStack> change = MoneyUtil.getCoinsOfValue(Math.abs(valueToTake));
            for (ItemStack coinStack : change) {
                if (!wallet.func_190926_b()) {
                    coinStack = WalletItem.PickupCoin(wallet, coinStack);
                }
                if (!coinStack.func_190926_b() && inventory != null) {
                    coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
                }
                if (coinStack.func_190926_b()) continue;
                player.field_71071_by.func_191975_a(player.field_70170_p, coinStack);
            }
        }
        return true;
    }

    public static void ProcessChange(@Nullable IInventory inventory, @Nonnull PlayerEntity player, @Nonnull CoinValue change) {
        MoneyUtil.ProcessChange(inventory, player, change, false);
    }

    public static void ProcessChange(@Nullable IInventory inventory, @Nonnull PlayerEntity player, @Nonnull CoinValue change, boolean ignoreWallet) {
        ItemStack wallet = ignoreWallet ? ItemStack.field_190927_a : LightmansCurrency.getWalletStack(player);
        List<ItemStack> changeCoins = MoneyUtil.getCoinsOfValue(change);
        for (ItemStack coinStack : changeCoins) {
            if (!wallet.func_190926_b()) {
                coinStack = WalletItem.PickupCoin(wallet, coinStack);
            }
            if (!coinStack.func_190926_b() && inventory != null) {
                coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
            }
            if (coinStack.func_190926_b()) continue;
            player.field_71071_by.func_191975_a(player.field_70170_p, coinStack);
        }
    }

    public static long takeObjectsOfValue(long value, IInventory inventory, boolean forceTake) {
        ItemStack itemStack;
        int i;
        long coinValue;
        if (moneyData == null) {
            return value;
        }
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        List<CoinData> coinList = moneyData.getCoinList();
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.func_70302_i_() && coinValue <= value; ++i) {
                itemStack = inventory.func_70301_a(i);
                if (!inventory.func_70301_a(i).func_77973_b().equals(coinData.coinItem)) continue;
                while (coinValue <= value && !itemStack.func_190926_b()) {
                    value -= coinValue;
                    itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                    if (!itemStack.func_190926_b()) continue;
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                Item coin = coinList.get((int)c).coinItem;
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.func_70302_i_() && value > 0L; ++i) {
                    itemStack = inventory.func_70301_a(i);
                    if (itemStack.func_77973_b() != coin) continue;
                    while (value > 0L && !itemStack.func_190926_b()) {
                        value -= coinValue;
                        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                        if (!itemStack.func_190926_b()) continue;
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                    }
                }
            }
        }
        return value;
    }

    private static long takeObjectsOfValue(long value, NonNullList<ItemStack> inventory) {
        return MoneyUtil.takeObjectsOfValue(value, inventory, false);
    }

    private static long takeObjectsOfValue(long value, NonNullList<ItemStack> inventory, boolean forceTake) {
        ItemStack itemStack;
        int i;
        long coinValue;
        if (moneyData == null) {
            return value;
        }
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        List<CoinData> coinList = moneyData.getCoinList();
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.size() && coinValue <= value; ++i) {
                itemStack = (ItemStack)inventory.get(i);
                if (!((ItemStack)inventory.get(i)).func_77973_b().equals(coinData.coinItem)) continue;
                while (coinValue <= value && !itemStack.func_190926_b()) {
                    value -= coinValue;
                    itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                    if (!itemStack.func_190926_b()) continue;
                    inventory.set(i, (Object)ItemStack.field_190927_a);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                Item coin = coinList.get((int)c).coinItem;
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.size() && value > 0L; ++i) {
                    itemStack = (ItemStack)inventory.get(i);
                    if (itemStack.func_77973_b() != coin) continue;
                    while (value > 0L && !itemStack.func_190926_b()) {
                        value -= coinValue;
                        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                        if (!itemStack.func_190926_b()) continue;
                        inventory.set(i, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }
        return value;
    }

    public static List<ItemStack> getCoinsOfValue(long value) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (value <= 0L || moneyData == null) {
            return items;
        }
        List<CoinData> coinList = moneyData.getCoinList(MAIN_CHAIN);
        for (int i = 0; i < coinList.size(); ++i) {
            if (coinList.get((int)i).isHidden) continue;
            Item coin = coinList.get((int)i).coinItem;
            int coinsToGive = 0;
            long coinValue = coinList.get(i).getValue();
            while (coinValue <= value) {
                value -= coinValue;
                ++coinsToGive;
            }
            while (coinsToGive > 0) {
                int giveCount = coinsToGive;
                if (giveCount > 64) {
                    giveCount = 64;
                }
                coinsToGive -= giveCount;
                ItemStack newStack = new ItemStack((IItemProvider)coin, giveCount);
                items.add(newStack);
            }
        }
        return items;
    }

    public static List<ItemStack> getCoinsOfValue(CoinValue value) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (CoinValue.CoinValuePair pricePair : value.coinValues) {
            int amountToAdd;
            for (int amount = pricePair.amount; amount > 0; amount -= amountToAdd) {
                ItemStack newStack = new ItemStack((IItemProvider)pricePair.coin);
                amountToAdd = MathUtil.clamp(amount, 0, newStack.func_77976_d());
                newStack.func_190920_e(amountToAdd);
                items.add(newStack);
            }
        }
        return items;
    }

    public static String getStringOfValue(long value) {
        return new CoinValue(value).getString();
    }

    public static CoinData getData(Item coinItem) {
        if (moneyData == null) {
            return null;
        }
        return moneyData.getData(coinItem);
    }

    public static List<Item> getAllCoins() {
        return MoneyUtil.getAllCoins(false);
    }

    public static List<Item> getAllCoins(boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<Item>();
        }
        ArrayList<Item> coinItems = new ArrayList<Item>();
        List<CoinData> coinList = moneyData.getCoinList();
        for (int i = 0; i < coinList.size(); ++i) {
            if (coinList.get((int)i).isHidden && !includeHidden) continue;
            coinItems.add(coinList.get((int)i).coinItem);
        }
        return coinItems;
    }

    public static List<Item> getAllCoins(String chain) {
        return MoneyUtil.getAllCoins(chain, false);
    }

    public static List<Item> getAllCoins(String chain, boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<Item>();
        }
        ArrayList<Item> coinItems = new ArrayList<Item>();
        List<CoinData> coinList = moneyData.getCoinList();
        for (int i = 0; i < coinList.size(); ++i) {
            if (!coinList.get((int)i).chain.contentEquals(chain) || coinList.get((int)i).isHidden && !includeHidden) continue;
            coinItems.add(coinList.get((int)i).coinItem);
        }
        return coinItems;
    }

    public static List<CoinData> getAllData() {
        return MoneyUtil.getAllData(false);
    }

    public static List<CoinData> getAllData(boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<CoinData>();
        }
        List<CoinData> coinList = moneyData.getCoinList();
        if (includeHidden) {
            return coinList;
        }
        ArrayList<CoinData> publicCoinList = new ArrayList<CoinData>();
        for (int i = 0; i < coinList.size(); ++i) {
            if (coinList.get((int)i).isHidden) continue;
            publicCoinList.add(coinList.get(i));
        }
        return publicCoinList;
    }

    public static List<CoinData> getAllData(String chain) {
        return MoneyUtil.getAllData(chain, false);
    }

    public static List<CoinData> getAllData(String chain, boolean includeHidden) {
        if (moneyData == null) {
            return new ArrayList<CoinData>();
        }
        List<CoinData> coinList = moneyData.getCoinList(chain);
        if (includeHidden) {
            return coinList;
        }
        ArrayList<CoinData> publicCoinList = new ArrayList<CoinData>();
        for (int i = 0; i < coinList.size(); ++i) {
            if (coinList.get((int)i).isHidden) continue;
            publicCoinList.add(coinList.get(i));
        }
        return publicCoinList;
    }

    public static Pair<Item, Integer> getUpwardConversion(Item coinItem) {
        if (moneyData == null) {
            return null;
        }
        Item largeCoin = null;
        int amount = Integer.MAX_VALUE;
        List<CoinData> coinList = moneyData.getCoinList();
        CoinData smallCoinData = moneyData.getData(coinItem);
        if (smallCoinData == null) {
            return null;
        }
        for (CoinData coinData : coinList) {
            if (coinData.worthOtherCoin != coinItem || coinData.worthOtherCoinCount >= amount || coinData.isHidden || !smallCoinData.chain.contentEquals(coinData.chain)) continue;
            largeCoin = coinData.coinItem;
            amount = coinData.worthOtherCoinCount;
        }
        if (largeCoin != null) {
            return new Pair(largeCoin, (Object)amount);
        }
        return null;
    }

    public static Pair<Item, Integer> getDownwardConversion(Item coinItem) {
        if (moneyData == null) {
            return null;
        }
        CoinData data = moneyData.getData(coinItem);
        if (data == null) {
            return null;
        }
        if (data.convertsDownwards()) {
            return data.getDownwardConversion();
        }
        return null;
    }

    public static long displayValueToLong(double displayValue) {
        long baseCoinValue = MoneyUtil.getValue(Config.getBaseCoinItem());
        double totalValue = displayValue * (double)baseCoinValue;
        long value = (long)totalValue;
        return totalValue % 1.0 >= 0.5 ? value + 1L : value;
    }

    public static CoinValue displayValueToCoinValue(double displayValue) {
        return new CoinValue(MoneyUtil.displayValueToLong(displayValue));
    }
}

