/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBankInteraction {
    boolean isDeposit;
    CoinValue amount;

    public MessageBankInteraction(boolean isDeposit, CoinValue amount) {
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    public static void encode(MessageBankInteraction message, PacketBuffer buffer) {
        buffer.writeBoolean(message.isDeposit);
        buffer.func_150786_a(message.amount.writeToNBT(new CompoundNBT(), "CoinValue"));
    }

    public static MessageBankInteraction decode(PacketBuffer buffer) {
        return new MessageBankInteraction(buffer.readBoolean(), new CoinValue(buffer.func_150793_b()));
    }

    public static void handle(MessageBankInteraction message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && entity.field_71070_bA instanceof BankAccount.IBankAccountMenu) {
                BankAccount.IBankAccountMenu container = (BankAccount.IBankAccountMenu)entity.field_71070_bA;
                if (message.isDeposit) {
                    BankAccount.DepositCoins(container, message.amount);
                } else {
                    BankAccount.WithdrawCoins(container, message.amount);
                }
                container.onDepositOrWithdraw();
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

