/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferResponse;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBankTransferTeam {
    UUID teamID;
    CoinValue amount;

    public MessageBankTransferTeam(UUID teamID, CoinValue amount) {
        this.teamID = teamID;
        this.amount = amount;
    }

    public static void encode(MessageBankTransferTeam message, PacketBuffer buffer) {
        buffer.func_179252_a(message.teamID);
        buffer.func_150786_a(message.amount.writeToNBT(new CompoundNBT(), "CoinValue"));
    }

    public static MessageBankTransferTeam decode(PacketBuffer buffer) {
        return new MessageBankTransferTeam(buffer.func_179253_g(), new CoinValue(buffer.func_150793_b()));
    }

    public static void handle(MessageBankTransferTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BankAccount.AccountReference destination;
            BankAccount.IBankAccountTransferMenu menu;
            ITextComponent response;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.field_71070_bA instanceof BankAccount.IBankAccountTransferMenu && (response = BankAccount.TransferCoins(menu = (BankAccount.IBankAccountTransferMenu)player.field_71070_bA, message.amount, destination = BankAccount.GenerateReference(false, BankAccount.AccountType.Team, message.teamID))) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageBankTransferResponse(response));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

