/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.item_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.events.TradeEditEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetItemPrice
implements IMessage<MessageSetItemPrice> {
    private BlockPos pos;
    private int tradeIndex;
    private CoinValue newPrice;
    private String customName;
    String newDirection;

    public MessageSetItemPrice() {
    }

    public MessageSetItemPrice(BlockPos pos, int tradeIndex, CoinValue newPrice, String customName, String newDirection) {
        this.pos = pos;
        this.tradeIndex = tradeIndex;
        this.newPrice = newPrice;
        this.customName = customName;
        this.newDirection = newDirection;
    }

    @Override
    public void encode(MessageSetItemPrice message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeInt(message.tradeIndex);
        buffer.func_150786_a(message.newPrice.writeToNBT(new CompoundNBT(), "CoinValue"));
        buffer.func_180714_a(message.customName);
        buffer.func_180714_a(message.newDirection);
    }

    @Override
    public MessageSetItemPrice decode(PacketBuffer buffer) {
        return new MessageSetItemPrice(buffer.func_179259_c(), buffer.readInt(), new CoinValue(buffer.func_150793_b()), buffer.func_150789_c(30), buffer.func_150789_c(ItemTradeData.MaxTradeTypeStringLength()));
    }

    @Override
    public void handle(MessageSetItemPrice message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && (tileEntity = entity.field_70170_p.func_175625_s(message.pos)) != null && tileEntity instanceof ItemTraderTileEntity) {
                ItemTraderTileEntity traderEntity = (ItemTraderTileEntity)tileEntity;
                CoinValue oldPrice = traderEntity.getTrade(message.tradeIndex).getCost();
                traderEntity.getTrade(message.tradeIndex).setCost(message.newPrice);
                traderEntity.getTrade(message.tradeIndex).setCustomName(message.customName);
                traderEntity.getTrade(message.tradeIndex).setTradeType(ItemTradeData.loadTradeType(message.newDirection));
                if (oldPrice.getRawValue() != message.newPrice.getRawValue() || oldPrice.isFree() != message.newPrice.isFree()) {
                    TradeEditEvent.TradePriceEditEvent e = new TradeEditEvent.TradePriceEditEvent((Supplier<ITrader>)((Supplier)() -> {
                        TileEntity te = entity.field_70170_p.func_175625_s(message.pos);
                        if (te instanceof ItemTraderTileEntity) {
                            return (ItemTraderTileEntity)te;
                        }
                        return null;
                    }), message.tradeIndex, oldPrice);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                }
                CompoundNBT compound = traderEntity.writeTrades(new CompoundNBT());
                TileEntityUtil.sendUpdatePacket(tileEntity, traderEntity.superWrite(compound));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

