/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.item_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.events.ItemTradeEditEvent;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetTradeItem
implements IMessage<MessageSetTradeItem> {
    private BlockPos pos;
    private int tradeIndex;
    private ItemStack newItem;
    int slot;

    public MessageSetTradeItem() {
    }

    public MessageSetTradeItem(BlockPos pos, int tradeIndex, ItemStack newItem, int slot) {
        this.pos = pos;
        this.tradeIndex = tradeIndex;
        this.newItem = newItem;
        this.slot = slot;
    }

    @Override
    public void encode(MessageSetTradeItem message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeInt(message.tradeIndex);
        buffer.func_150786_a(message.newItem.func_77955_b(new CompoundNBT()));
        buffer.writeInt(message.slot);
    }

    @Override
    public MessageSetTradeItem decode(PacketBuffer buffer) {
        return new MessageSetTradeItem(buffer.func_179259_c(), buffer.readInt(), ItemStack.func_199557_a((CompoundNBT)buffer.func_150793_b()), buffer.readInt());
    }

    @Override
    public void handle(MessageSetTradeItem message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && (tileEntity = entity.field_70170_p.func_175625_s(message.pos)) != null && tileEntity instanceof ItemTraderTileEntity) {
                ItemTraderTileEntity traderEntity = (ItemTraderTileEntity)tileEntity;
                if (!traderEntity.hasPermission((PlayerEntity)entity, "editTrades")) {
                    return;
                }
                ItemStack oldItem = ItemStack.field_190927_a;
                if (message.slot == 1) {
                    oldItem = traderEntity.getTrade(message.tradeIndex).getBarterItem();
                    traderEntity.getTrade(message.tradeIndex).setBarterItem(message.newItem);
                } else {
                    oldItem = traderEntity.getTrade(message.tradeIndex).getSellItem();
                    traderEntity.getTrade(message.tradeIndex).setSellItem(message.newItem);
                }
                ItemTradeEditEvent.ItemTradeItemEditEvent e = new ItemTradeEditEvent.ItemTradeItemEditEvent((Supplier<ITrader>)((Supplier)() -> {
                    TileEntity te = entity.field_70170_p.func_175625_s(message.pos);
                    if (te instanceof ItemTraderTileEntity) {
                        return (ItemTraderTileEntity)te;
                    }
                    return null;
                }), message.tradeIndex, oldItem, message.slot);
                MinecraftForge.EVENT_BUS.post((Event)e);
                CompoundNBT compound = traderEntity.writeTrades(new CompoundNBT());
                TileEntityUtil.sendUpdatePacket(tileEntity, traderEntity.superWrite(compound));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

