/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.paygate;

import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.tileentity.PaygateTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdatePaygateData
implements IMessage<MessageUpdatePaygateData> {
    private BlockPos pos;
    private CoinValue newPrice;
    private int newDuration;

    public MessageUpdatePaygateData() {
    }

    public MessageUpdatePaygateData(BlockPos pos, CoinValue newPrice, int newDuration) {
        this.pos = pos;
        this.newPrice = newPrice;
        this.newDuration = newDuration;
    }

    @Override
    public void encode(MessageUpdatePaygateData message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.func_150786_a(message.newPrice.writeToNBT(new CompoundNBT(), "CoinValue"));
        buffer.writeInt(message.newDuration);
    }

    @Override
    public MessageUpdatePaygateData decode(PacketBuffer buffer) {
        return new MessageUpdatePaygateData(buffer.func_179259_c(), new CoinValue(buffer.func_150793_b()), buffer.readInt());
    }

    @Override
    public void handle(MessageUpdatePaygateData message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && (tileEntity = entity.field_70170_p.func_175625_s(message.pos)) != null && tileEntity instanceof PaygateTileEntity) {
                PaygateTileEntity paygateEntity = (PaygateTileEntity)tileEntity;
                paygateEntity.setPrice(message.newPrice);
                paygateEntity.setDuration(message.newDuration);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

