/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEditTeam {
    UUID teamID;
    String playerName;
    String category;

    public MessageEditTeam(UUID teamID, String playerName, String category) {
        this.teamID = teamID;
        this.playerName = playerName;
        this.category = category;
    }

    public static void encode(MessageEditTeam message, PacketBuffer buffer) {
        buffer.func_179252_a(message.teamID);
        buffer.func_211400_a(message.playerName, 16);
        buffer.func_180714_a(message.category);
    }

    public static MessageEditTeam decode(PacketBuffer buffer) {
        return new MessageEditTeam(buffer.func_179253_g(), buffer.func_150789_c(16), buffer.func_150789_c(255));
    }

    public static void handle(MessageEditTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TradingOffice.getTeam(message.teamID);
            if (team != null) {
                team.changeAny((PlayerEntity)((NetworkEvent.Context)supplier.get()).getSender(), message.playerName, message.category);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

