/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRenameTeam {
    UUID teamID;
    String newName;

    public MessageRenameTeam(UUID teamID, String newName) {
        this.teamID = teamID;
        this.newName = newName;
    }

    public static void encode(MessageRenameTeam message, PacketBuffer buffer) {
        buffer.func_179252_a(message.teamID);
        buffer.func_211400_a(message.newName, 32);
    }

    public static MessageRenameTeam decode(PacketBuffer buffer) {
        return new MessageRenameTeam(buffer.func_179253_g(), buffer.func_150789_c(32));
    }

    public static void handle(MessageRenameTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TradingOffice.getTeam(message.teamID);
            if (team != null) {
                team.changeName((PlayerEntity)((NetworkEvent.Context)supplier.get()).getSender(), message.newName);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

