/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.ticket_machine;

import io.github.lightman314.lightmanscurrency.containers.TicketMachineContainer;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCraftTicket
implements IMessage<MessageCraftTicket> {
    private boolean fullStack;

    public MessageCraftTicket() {
    }

    public MessageCraftTicket(boolean fullStack) {
        this.fullStack = fullStack;
    }

    @Override
    public void encode(MessageCraftTicket message, PacketBuffer buffer) {
        buffer.writeBoolean(message.fullStack);
    }

    @Override
    public MessageCraftTicket decode(PacketBuffer buffer) {
        return new MessageCraftTicket(buffer.readBoolean());
    }

    @Override
    public void handle(MessageCraftTicket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && entity.field_71070_bA instanceof TicketMachineContainer) {
                TicketMachineContainer container = (TicketMachineContainer)entity.field_71070_bA;
                container.craftTickets(message.fullStack);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

