/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageChangeSettings
implements IMessage<MessageChangeSettings> {
    private final int MAX_TYPE_LENGTH = 100;
    BlockPos pos;
    ResourceLocation type;
    CompoundNBT updateInfo;

    public MessageChangeSettings() {
    }

    public MessageChangeSettings(BlockPos pos, ResourceLocation type, CompoundNBT updateInfo) {
        this.pos = pos;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    @Override
    public void encode(MessageChangeSettings message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.func_211400_a(message.type.toString(), 100);
        buffer.func_150786_a(message.updateInfo);
    }

    @Override
    public MessageChangeSettings decode(PacketBuffer buffer) {
        return new MessageChangeSettings(buffer.func_179259_c(), new ResourceLocation(buffer.func_150789_c(100)), buffer.func_150793_b());
    }

    @Override
    public void handle(MessageChangeSettings message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity requestor = ((NetworkEvent.Context)supplier.get()).getSender();
            if (requestor != null && (tileEntity = requestor.field_70170_p.func_175625_s(message.pos)) instanceof TraderTileEntity) {
                TraderTileEntity trader = (TraderTileEntity)tileEntity;
                trader.changeSettings(message.type, (PlayerEntity)requestor, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

