/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateTradeRule {
    private BlockPos pos;
    private int index;
    private ResourceLocation type;
    private CompoundNBT updateInfo;

    public MessageUpdateTradeRule(BlockPos pos, ResourceLocation type, CompoundNBT updateInfo) {
        this(pos, -1, type, updateInfo);
    }

    public MessageUpdateTradeRule(BlockPos pos, int index, ResourceLocation type, CompoundNBT updateInfo) {
        this.pos = pos;
        this.index = index;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageUpdateTradeRule message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeInt(message.index);
        buffer.func_180714_a(message.type.toString());
        buffer.func_150786_a(message.updateInfo);
    }

    public static MessageUpdateTradeRule decode(PacketBuffer buffer) {
        return new MessageUpdateTradeRule(buffer.func_179259_c(), buffer.readInt(), new ResourceLocation(buffer.func_150789_c(1000)), buffer.func_150793_b());
    }

    public static void handle(MessageUpdateTradeRule message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            TileEntity be;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (be = player.field_70170_p.func_175625_s(message.pos)) instanceof ITradeRuleHandler.ITradeRuleMessageHandler) {
                ((ITradeRuleHandler.ITradeRuleMessageHandler)be).receiveTradeRuleMessage((PlayerEntity)player, message.index, message.type, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

