/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageChangeSettings2
implements IMessage<MessageChangeSettings2> {
    private final int MAX_TYPE_LENGTH = 100;
    UUID traderID;
    ResourceLocation type;
    CompoundNBT updateInfo;

    public MessageChangeSettings2() {
    }

    public MessageChangeSettings2(UUID traderID, ResourceLocation type, CompoundNBT updateInfo) {
        this.traderID = traderID;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    @Override
    public void encode(MessageChangeSettings2 message, PacketBuffer buffer) {
        buffer.func_179252_a(message.traderID);
        buffer.func_211400_a(message.type.toString(), 100);
        buffer.func_150786_a(message.updateInfo);
    }

    @Override
    public MessageChangeSettings2 decode(PacketBuffer buffer) {
        return new MessageChangeSettings2(buffer.func_179253_g(), new ResourceLocation(buffer.func_150789_c(100)), buffer.func_150793_b());
    }

    @Override
    public void handle(MessageChangeSettings2 message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData trader;
            ServerPlayerEntity requestor = ((NetworkEvent.Context)supplier.get()).getSender();
            if (requestor != null && (trader = TradingOffice.getData(message.traderID)) != null) {
                trader.changeSettings(message.type, (PlayerEntity)requestor, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

