/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.events.TradeEditEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetItemPrice2
implements IMessage<MessageSetItemPrice2> {
    private UUID traderID;
    private int tradeIndex;
    private CoinValue newPrice;
    private String customName;
    private String newDirection;

    public MessageSetItemPrice2() {
    }

    public MessageSetItemPrice2(UUID traderID, int tradeIndex, CoinValue newPrice, String customName, String newDirection) {
        this.traderID = traderID;
        this.tradeIndex = tradeIndex;
        this.newPrice = newPrice;
        this.customName = customName;
        this.newDirection = newDirection;
    }

    @Override
    public void encode(MessageSetItemPrice2 message, PacketBuffer buffer) {
        buffer.func_179252_a(message.traderID);
        buffer.writeInt(message.tradeIndex);
        buffer.func_150786_a(message.newPrice.writeToNBT(new CompoundNBT(), "CoinValue"));
        buffer.func_180714_a(message.customName);
        buffer.func_180714_a(message.newDirection);
    }

    @Override
    public MessageSetItemPrice2 decode(PacketBuffer buffer) {
        return new MessageSetItemPrice2(buffer.func_179253_g(), buffer.readInt(), new CoinValue(buffer.func_150793_b()), buffer.func_150789_c(30), buffer.func_150789_c(ItemTradeData.MaxTradeTypeStringLength()));
    }

    @Override
    public void handle(MessageSetItemPrice2 message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data1 = TradingOffice.getData(message.traderID);
            if (data1 != null && data1 instanceof UniversalItemTraderData) {
                UniversalItemTraderData data2 = (UniversalItemTraderData)data1;
                CoinValue oldPrice = data2.getTrade(message.tradeIndex).getCost();
                data2.getTrade(message.tradeIndex).setCost(message.newPrice);
                data2.getTrade(message.tradeIndex).setCustomName(message.customName);
                data2.getTrade(message.tradeIndex).setTradeType(ItemTradeData.loadTradeType(message.newDirection));
                if (oldPrice.getRawValue() != message.newPrice.getRawValue() || oldPrice.isFree() != message.newPrice.isFree()) {
                    TradeEditEvent.TradePriceEditEvent e = new TradeEditEvent.TradePriceEditEvent((Supplier<ITrader>)((Supplier)() -> {
                        UniversalTraderData d = TradingOffice.getData(message.traderID);
                        if (d instanceof UniversalItemTraderData) {
                            return (UniversalItemTraderData)d;
                        }
                        return null;
                    }), message.tradeIndex, oldPrice);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                }
                TradingOffice.MarkDirty(message.traderID);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

