/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.events.ItemTradeEditEvent;
import io.github.lightman314.lightmanscurrency.network.message.IMessage;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetTradeItem2
implements IMessage<MessageSetTradeItem2> {
    private UUID traderID;
    private int tradeIndex;
    ItemStack newItem;
    int slot;

    public MessageSetTradeItem2() {
    }

    public MessageSetTradeItem2(UUID traderID, int tradeIndex, ItemStack newItem, int slot) {
        this.traderID = traderID;
        this.tradeIndex = tradeIndex;
        this.newItem = newItem;
        this.slot = slot;
    }

    @Override
    public void encode(MessageSetTradeItem2 message, PacketBuffer buffer) {
        buffer.func_179252_a(message.traderID);
        buffer.writeInt(message.tradeIndex);
        buffer.func_150786_a(message.newItem.func_77955_b(new CompoundNBT()));
        buffer.writeInt(message.slot);
    }

    @Override
    public MessageSetTradeItem2 decode(PacketBuffer buffer) {
        return new MessageSetTradeItem2(buffer.func_179253_g(), buffer.readInt(), ItemStack.func_199557_a((CompoundNBT)buffer.func_150793_b()), buffer.readInt());
    }

    @Override
    public void handle(MessageSetTradeItem2 message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data1 = TradingOffice.getData(message.traderID);
            if (data1 != null && data1 instanceof UniversalItemTraderData) {
                UniversalItemTraderData data2 = (UniversalItemTraderData)data1;
                if (!data2.hasPermission((PlayerEntity)((NetworkEvent.Context)supplier.get()).getSender(), "editTrades")) {
                    return;
                }
                ItemStack oldItem = ItemStack.field_190927_a;
                ItemTradeData trade = data2.getTrade(message.tradeIndex);
                if (message.slot == 1) {
                    oldItem = trade.getBarterItem();
                    trade.setBarterItem(message.newItem);
                } else {
                    oldItem = trade.getSellItem();
                    trade.setSellItem(message.newItem);
                }
                ItemTradeEditEvent.ItemTradeItemEditEvent e = new ItemTradeEditEvent.ItemTradeItemEditEvent((Supplier<ITrader>)((Supplier)() -> {
                    UniversalTraderData d = TradingOffice.getData(message.traderID);
                    if (d instanceof UniversalItemTraderData) {
                        return (UniversalItemTraderData)d;
                    }
                    return null;
                }), message.tradeIndex, oldItem, message.slot);
                MinecraftForge.EVENT_BUS.post((Event)e);
                TradingOffice.MarkDirty(message.traderID);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

