/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateTradeRule2 {
    private UUID traderID;
    private int index;
    private ResourceLocation type;
    private CompoundNBT updateInfo;

    public MessageUpdateTradeRule2(UUID traderID, ResourceLocation type, CompoundNBT updateInfo) {
        this(traderID, -1, type, updateInfo);
    }

    public MessageUpdateTradeRule2(UUID traderID, int index, ResourceLocation type, CompoundNBT updateInfo) {
        this.traderID = traderID;
        this.index = index;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageUpdateTradeRule2 message, PacketBuffer buffer) {
        buffer.func_179252_a(message.traderID);
        buffer.writeInt(message.index);
        buffer.func_180714_a(message.type.toString());
        buffer.func_150786_a(message.updateInfo);
    }

    public static MessageUpdateTradeRule2 decode(PacketBuffer buffer) {
        return new MessageUpdateTradeRule2(buffer.func_179253_g(), buffer.readInt(), new ResourceLocation(buffer.func_150789_c(1000)), buffer.func_150793_b());
    }

    public static void handle(MessageUpdateTradeRule2 message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData trader;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (trader = TradingOffice.getData(message.traderID)) instanceof ITradeRuleHandler.ITradeRuleMessageHandler) {
                ((ITradeRuleHandler.ITradeRuleMessageHandler)((Object)trader)).receiveTradeRuleMessage((PlayerEntity)player, message.index, message.type, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

