/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.BlockItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemEditScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PaygateScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.model.ModelWallet;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.client.renderer.tileentity.FreezerTraderTileEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.tileentity.ItemTraderTileEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinItem;
import io.github.lightman314.lightmanscurrency.money.CoinData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeLimit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientProxy
extends CommonProxy {
    private long timeOffset = 0L;

    @Override
    public void setupClient() {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.DISPLAY_CASE.block, (RenderType)RenderType.func_228643_e_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE1, RenderType.func_228643_e_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE2, RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ARMOR_DISPLAY.block, (RenderType)RenderType.func_228643_e_());
        ScreenManager.func_216911_a(ModContainers.ATM, ATMScreen::new);
        ScreenManager.func_216911_a(ModContainers.MINT, MintScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_TRADER, ItemTraderScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_TRADER_CR, ItemTraderScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_TRADER_UNIVERSAL, ItemTraderScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_TRADER_STORAGE, ItemTraderStorageScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_TRADER_STORAGE_UNIVERSAL, ItemTraderStorageScreen::new);
        ScreenManager.func_216911_a(ModContainers.ITEM_EDIT, ItemEditScreen::new);
        ScreenManager.func_216911_a(ModContainers.UNIVERSAL_ITEM_EDIT, ItemEditScreen::new);
        ScreenManager.func_216911_a(ModContainers.WALLET, WalletScreen::new);
        ScreenManager.func_216911_a(ModContainers.PAYGATE, PaygateScreen::new);
        ScreenManager.func_216911_a(ModContainers.TICKET_MACHINE, TicketMachineScreen::new);
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.ITEM_TRADER, ItemTraderTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.FREEZER_TRADER, FreezerTraderTileEntityRenderer::new);
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TradeLimit()));
        ClientRegistry.registerKeyBinding((KeyBinding)ClientEvents.KEY_WALLET);
        ClientRegistry.registerKeyBinding((KeyBinding)ClientEvents.KEY_TEAM);
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        this.addWalletLayer((PlayerRenderer)skinMap.get("default"));
        this.addWalletLayer((PlayerRenderer)skinMap.get("slim"));
    }

    private static void setRenderLayerForSet(BlockItemSet<?> blockItemSet, RenderType type) {
        blockItemSet.getAll().forEach(blockItemPair -> RenderTypeLookup.setRenderLayer((Block)blockItemPair.block, (RenderType)type));
    }

    private void addWalletLayer(PlayerRenderer renderer) {
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingRenderer.class, (Object)renderer, (String)"field_177097_h");
        if (layers != null) {
            layers.add(new WalletLayer(renderer, new ModelWallet()));
        }
    }

    @Override
    public void clearClientTraders() {
        ClientTradingOffice.clearData();
    }

    @Override
    public void updateTrader(CompoundNBT compound) {
        ClientTradingOffice.updateTrader(compound);
    }

    @Override
    public void removeTrader(UUID traderID) {
        ClientTradingOffice.removeTrader(traderID);
    }

    @Override
    public void initializeTeams(CompoundNBT compound) {
        if (compound.func_150297_b("Teams", 9)) {
            ArrayList teams = Lists.newArrayList();
            ListNBT teamList = compound.func_150295_c("Teams", 10);
            teamList.forEach(nbt -> teams.add(Team.load((CompoundNBT)nbt)));
            ClientTradingOffice.initTeams(teams);
        }
    }

    @Override
    public void updateTeam(CompoundNBT compound) {
        ClientTradingOffice.updateTeam(compound);
    }

    @Override
    public void removeTeam(UUID teamID) {
        ClientTradingOffice.removeTeam(teamID);
    }

    @Override
    public void initializeBankAccounts(CompoundNBT compound) {
        if (compound.func_150297_b("BankAccounts", 9)) {
            HashMap<UUID, BankAccount> bank = new HashMap<UUID, BankAccount>();
            ListNBT bankList = compound.func_150295_c("BankAccounts", 10);
            for (int i = 0; i < bankList.size(); ++i) {
                CompoundNBT tag = bankList.func_150305_b(i);
                UUID id = tag.func_186857_a("Player");
                BankAccount bankAccount = new BankAccount(tag);
                bank.put(id, bankAccount);
            }
            ClientTradingOffice.initBankAccounts(bank);
        }
    }

    @Override
    public void updateBankAccount(CompoundNBT compound) {
        ClientTradingOffice.updateBankAccount(compound);
    }

    @Override
    public void openTerminalScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new TradingTerminalScreen());
    }

    @Override
    public void openTeamManager() {
        Minecraft.func_71410_x().func_147108_a((Screen)new TeamManagerScreen());
    }

    @Override
    public void createTeamResponse(UUID teamID) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof TeamManagerScreen) {
            TeamManagerScreen screen = (TeamManagerScreen)minecraft.field_71462_r;
            screen.setActiveTeam(teamID);
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        TradingOffice.loadAdminPlayers(serverAdminList);
    }

    public void registerItemColors(ColorHandlerEvent.Item event) {
        LightmansCurrency.LogInfo("Registering Item Colors for Ticket Items");
        event.getItemColors().func_199877_a((IItemColor)new TicketColor(), new IItemProvider[]{ModItems.TICKET, ModItems.TICKET_MASTER});
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().func_77973_b();
        CoinData coinData = MoneyUtil.getData(item);
        if (coinData != null && !(item instanceof CoinItem) && !(item instanceof CoinBlockItem)) {
            CoinItem.addCoinTooltips(event.getItemStack(), event.getToolTip());
        }
    }
}

