/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blocks.RotatableBlock;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.tileentity.ItemTraderTileEntity;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;

public class ArmorDisplayTraderTileEntity
extends ItemTraderTileEntity {
    public static final int TRADE_COUNT = 4;
    ArmorStandEntity armorStand;
    UUID armorStandID = null;

    public ArmorDisplayTraderTileEntity() {
        super(ModTileEntities.ARMOR_TRADER, 4);
        this.validateTradeLimitations();
    }

    private void spawnArmorStand() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.armorStand = new ArmorStandEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
        this.armorStand.func_70012_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5, this.getStandRotation(), 0.0f);
        this.armorStand.func_184224_h(true);
        this.armorStand.func_189654_d(true);
        this.armorStand.func_174810_b(true);
        CompoundNBT compound = this.armorStand.func_189511_e(new CompoundNBT());
        compound.func_74757_a("Marker", true);
        compound.func_74757_a("NoBasePlate", true);
        this.armorStand.func_70020_e(compound);
        this.field_145850_b.func_217376_c((Entity)this.armorStand);
    }

    private void validateTradeLimitations() {
        if (this.tradeCount > 0) {
            this.restrictTrade(0, ItemTradeRestriction.ARMOR_HEAD);
        }
        if (this.tradeCount > 1) {
            this.restrictTrade(1, ItemTradeRestriction.ARMOR_CHEST);
        }
        if (this.tradeCount > 2) {
            this.restrictTrade(2, ItemTradeRestriction.ARMOR_LEGS);
        }
        if (this.tradeCount > 3) {
            this.restrictTrade(3, ItemTradeRestriction.ARMOR_FEET);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.validateTradeLimitations();
        if (!this.field_145850_b.field_72995_K) {
            if (this.armorStandID != null) {
                this.validateArmorStand();
                this.armorStandID = null;
            }
            if (this.armorStand == null || !this.armorStand.func_70089_S()) {
                this.spawnArmorStand();
            }
            if (this.armorStand != null) {
                this.validateArmorStandValues();
                this.armorStand.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.getStandRotation(), 0.0f);
                for (int i = 0; i < 4 && i < this.tradeCount; ++i) {
                    ItemTradeData thisTrade = this.getTrade(i);
                    ItemTradeRestriction r = thisTrade.getRestriction();
                    EquipmentSlotType slot = null;
                    if (r instanceof EquipmentRestriction) {
                        EquipmentRestriction er = (EquipmentRestriction)r;
                        slot = er.getEquipmentSlot();
                    }
                    if (slot == null) continue;
                    if (thisTrade.hasStock(this) || this.coreSettings.isCreative()) {
                        this.armorStand.func_184201_a(slot, thisTrade.getSellItem());
                        continue;
                    }
                    this.armorStand.func_184201_a(slot, ItemStack.field_190927_a);
                }
            }
        }
    }

    protected void validateArmorStand() {
        if (this.armorStandID == null) {
            return;
        }
        if (this.armorStand != null) {
            ArmorStandEntity newArmorStand;
            if (!this.armorStand.func_110124_au().equals(this.armorStandID) && (newArmorStand = this.getArmorStand(this.armorStandID)) != null) {
                this.destroyArmorStand();
                this.armorStand = newArmorStand;
            }
        } else {
            this.armorStand = this.getArmorStand(this.armorStandID);
        }
    }

    protected void validateArmorStandValues() {
        if (!this.armorStand.func_190530_aW()) {
            this.armorStand.func_184224_h(true);
        }
        if (this.armorStand.func_82150_aj()) {
            this.armorStand.func_82142_c(false);
        }
        if (!this.armorStand.func_189652_ae()) {
            this.armorStand.func_189654_d(true);
        }
        if (!this.armorStand.func_174814_R()) {
            this.armorStand.func_174810_b(true);
        }
        if (!this.armorStand.func_181026_s() || !this.armorStand.func_175414_r()) {
            CompoundNBT compound = this.armorStand.func_189511_e(new CompoundNBT());
            if (!this.armorStand.func_181026_s()) {
                compound.func_74757_a("Marker", true);
            }
            if (!this.armorStand.func_175414_r()) {
                compound.func_74757_a("NoBasePlate", true);
            }
            this.armorStand.func_70020_e(compound);
        }
    }

    public void destroyArmorStand() {
        if (this.armorStand != null) {
            this.armorStand.func_70106_y();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeArmorStandData(compound);
        return super.func_189515_b(compound);
    }

    protected CompoundNBT writeArmorStandData(CompoundNBT compound) {
        if (this.armorStand != null) {
            compound.func_186854_a("ArmorStand", this.armorStand.func_110124_au());
        }
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("ArmorStand")) {
            this.armorStandID = compound.func_186857_a("ArmorStand");
        }
    }

    protected ArmorStandEntity getArmorStand(UUID id) {
        Entity entity = null;
        if (this.field_145850_b instanceof ServerWorld) {
            entity = ((ServerWorld)this.field_145850_b).func_217461_a(id);
        }
        if (entity != null && entity instanceof ArmorStandEntity) {
            return (ArmorStandEntity)entity;
        }
        LightmansCurrency.LogError("Could not find an armor stand with UUID " + id);
        return null;
    }

    protected float getStandRotation() {
        Direction facing = Direction.NORTH;
        if (this.func_195044_w().func_235901_b_((Property)RotatableBlock.FACING)) {
            facing = (Direction)this.func_195044_w().func_177229_b((Property)RotatableBlock.FACING);
        }
        if (facing == Direction.SOUTH) {
            return 180.0f;
        }
        if (facing == Direction.NORTH) {
            return 0.0f;
        }
        if (facing == Direction.WEST) {
            return -90.0f;
        }
        if (facing == Direction.EAST) {
            return 90.0f;
        }
        return 0.0f;
    }
}

