/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class CashRegisterTileEntity
extends TileEntity {
    List<BlockPos> positions = new ArrayList<BlockPos>();

    public CashRegisterTileEntity() {
        super(ModTileEntities.CASH_REGISTER);
    }

    public void loadDataFromItems(CompoundNBT itemTag) {
        if (itemTag == null) {
            return;
        }
        this.readPositions(itemTag);
    }

    public void OpenContainer(PlayerEntity player) {
        this.OpenContainer(-1, 0, 1, player);
    }

    public void OpenContainer(int oldIndex, int newIndex, int direction, PlayerEntity player) {
        direction = direction == 0 ? 1 : MathUtil.clamp(direction, -1, 1);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.positions.size() <= 0) {
            LightmansCurrency.LogInfo("Cash Register has no Trader Positions stored. Unable to open container.");
            return;
        }
        if (newIndex < 0) {
            newIndex = this.positions.size() - 1;
        } else if (newIndex >= this.positions.size()) {
            newIndex = 0;
        }
        if (newIndex == oldIndex) {
            LightmansCurrency.LogInfo("Trader Index is the same as the original index.");
            return;
        }
        TraderTileEntity tileEntity = this.getTrader(newIndex);
        if (tileEntity != null) {
            tileEntity.openCashRegisterTradeMenu((PlayerEntity)((ServerPlayerEntity)player), this);
            return;
        }
        if (oldIndex < 0) {
            oldIndex = newIndex;
        }
        this.OpenContainer(oldIndex, newIndex + direction, direction, player);
    }

    public void OpenEditorScreen() {
    }

    public TraderTileEntity getTrader(int index) {
        if (index < 0 || index >= this.positions.size()) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.positions.get(index));
        if (tileEntity instanceof TraderTileEntity) {
            return (TraderTileEntity)tileEntity;
        }
        return null;
    }

    public int getTraderIndex(TraderTileEntity tileEntity) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!this.positions.get(i).equals((Object)tileEntity.func_174877_v())) continue;
            return i;
        }
        return -1;
    }

    public int getPairedTraderSize() {
        return this.positions.size();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT storageList = new ListNBT();
        for (int i = 0; i < this.positions.size(); ++i) {
            CompoundNBT thisEntry = new CompoundNBT();
            BlockPos thisPos = this.positions.get(i);
            thisEntry.func_74768_a("x", thisPos.func_177958_n());
            thisEntry.func_74768_a("y", thisPos.func_177956_o());
            thisEntry.func_74768_a("z", thisPos.func_177952_p());
            storageList.add((Object)thisEntry);
        }
        if (storageList.size() > 0) {
            compound.func_218657_a("TraderPos", (INBT)storageList);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readPositions(compound);
        super.func_230337_a_(state, compound);
    }

    private void readPositions(CompoundNBT compound) {
        if (compound.func_74764_b("TraderPos")) {
            this.positions = new ArrayList<BlockPos>();
            ListNBT storageList = compound.func_150295_c("TraderPos", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundNBT thisEntry = storageList.func_150305_b(i);
                if (!thisEntry.func_74764_b("x") || !thisEntry.func_74764_b("y") || !thisEntry.func_74764_b("z")) continue;
                BlockPos thisPos = new BlockPos(thisEntry.func_74762_e("x"), thisEntry.func_74762_e("y"), thisEntry.func_74762_e("z"));
                this.positions.add(thisPos);
            }
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }
}

