/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;

public class CoinJarTileEntity
extends TileEntity {
    public static int COIN_LIMIT = 64;
    List<ItemStack> storage = new ArrayList<ItemStack>();

    public List<ItemStack> getStorage() {
        return this.storage;
    }

    public CoinJarTileEntity() {
        super(ModTileEntities.COIN_JAR);
    }

    public boolean addCoin(ItemStack coin) {
        if (this.getCurrentCount() >= COIN_LIMIT) {
            return false;
        }
        if (!MoneyUtil.isCoin(coin, false)) {
            return false;
        }
        boolean foundStack = false;
        for (int i = 0; i < this.storage.size() && !foundStack; ++i) {
            if (!InventoryUtil.ItemMatches(coin, this.storage.get(i)) || this.storage.get(i).func_190916_E() >= this.storage.get(i).func_77976_d()) continue;
            this.storage.get(i).func_190917_f(1);
            foundStack = true;
        }
        if (!foundStack) {
            ItemStack newCoin = coin.func_77946_l();
            newCoin.func_190920_e(1);
            this.storage.add(newCoin);
        }
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStorage(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
        return true;
    }

    protected int getCurrentCount() {
        int count = 0;
        for (int i = 0; i < this.storage.size(); ++i) {
            count += this.storage.get(i).func_190916_E();
        }
        return count;
    }

    protected CompoundNBT writeStorage(CompoundNBT compound) {
        ListNBT storageList = new ListNBT();
        for (int i = 0; i < this.storage.size(); ++i) {
            storageList.add((Object)this.storage.get(i).func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("Coins", (INBT)storageList);
        return compound;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeStorage(compound);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListNBT storageList = compound.func_150295_c("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundNBT thisItem = storageList.func_150305_b(i);
                this.storage.add(ItemStack.func_199557_a((CompoundNBT)thisItem));
            }
        }
        super.func_230337_a_(state, compound);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            TileEntityUtil.requestUpdatePacket(this.field_145850_b, this.field_174879_c);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    public void writeItemTag(ItemStack item) {
        CompoundNBT compound = item.func_196082_o();
        compound.func_218657_a("JarData", (INBT)this.writeStorage(new CompoundNBT()));
    }

    public void readItemTag(ItemStack item) {
        CompoundNBT jarData;
        CompoundNBT compound;
        if (item.func_77942_o() && (compound = item.func_77978_p()).func_150297_b("JarData", 10) && (jarData = compound.func_74775_l("JarData")).func_74764_b("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListNBT storageList = jarData.func_150295_c("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundNBT thisItem = storageList.func_150305_b(i);
                this.storage.add(ItemStack.func_199557_a((CompoundNBT)thisItem));
            }
        }
    }
}

